/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.data;

import org.openl.syntax.impl.IdentifierNode;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.impl.AOpenField;
import org.openl.vm.IRuntimeEnv;

public class FieldChain
extends AOpenField {
    private IOpenField[] fields;

    public FieldChain(IOpenClass type, IOpenField[] fields) {
        super(FieldChain.makeNames(fields), type);
        this.fields = fields;
    }

    public FieldChain(IOpenClass type, IOpenField[] fields, IdentifierNode[] fieldAccessorChainTokens, boolean hasAccessByArrayId) {
        super(FieldChain.getFieldName(fields, fieldAccessorChainTokens, hasAccessByArrayId), type);
        this.fields = fields;
    }

    private static String getFieldName(IOpenField[] fields, IdentifierNode[] fieldAccessorChainTokens, boolean hasAccessByArrayId) {
        String name = hasAccessByArrayId ? FieldChain.makeNamesByTokens(fieldAccessorChainTokens) : FieldChain.makeNames(fields);
        return name;
    }

    private static String makeNames(IOpenField[] fields) {
        String name = fields[0].getName();
        for (int i = 1; i < fields.length; ++i) {
            name = name + "." + fields[i].getName();
        }
        return name;
    }

    private static String makeNamesByTokens(IdentifierNode[] fieldAccessorChainTokens) {
        String name = fieldAccessorChainTokens[0].getIdentifier();
        for (int i = 1; i < fieldAccessorChainTokens.length; ++i) {
            name = name + "." + fieldAccessorChainTokens[i].getIdentifier();
        }
        return name;
    }

    public IOpenClass getDeclaringClass() {
        return this.fields[0].getDeclaringClass();
    }

    public IOpenClass getType() {
        return this.fields[this.fields.length - 1].getType();
    }

    public Object get(Object target, IRuntimeEnv env) {
        Object result = null;
        for (IOpenField field : this.fields) {
            if (target == null) {
                result = null;
                break;
            }
            target = result = field.get(target, env);
        }
        return result;
    }

    public void set(Object target, Object value, IRuntimeEnv env) {
        for (int i = 0; i < this.fields.length - 1; ++i) {
            Object newTarget = this.fields[i].get(target, env);
            if (newTarget == null) {
                newTarget = this.fields[i].getType().newInstance(env);
                this.fields[i].set(target, newTarget, env);
            }
            target = newTarget;
        }
        this.fields[this.fields.length - 1].set(target, value, env);
    }

    public IOpenField[] getFields() {
        return (IOpenField[])this.fields.clone();
    }
}

