/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.data;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.impl.NodeType;
import org.openl.binding.impl.SimpleNodeUsage;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.domain.EnumDomain;
import org.openl.domain.IDomain;
import org.openl.meta.StringValue;
import org.openl.rules.binding.RuleRowHelper;
import org.openl.rules.data.ColumnDescriptor;
import org.openl.rules.data.DataTableBindHelper;
import org.openl.rules.data.IDataBase;
import org.openl.rules.data.ITable;
import org.openl.rules.lang.xls.types.CellMetaInfo;
import org.openl.rules.table.ICell;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.LogicalTableHelper;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.impl.DomainOpenClass;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.CollectionUtils;
import org.openl.util.StringTool;
import org.openl.util.text.ILocation;
import org.openl.util.text.TextInfo;

public class ForeignKeyColumnDescriptor
extends ColumnDescriptor {
    private static final String NOT_INITIALIZED = "<not_initialized>";
    private final IdentifierNode foreignKeyTable;
    private final IdentifierNode[] foreignKeyTableAccessorChainTokens;
    private final IdentifierNode foreignKey;
    private String[] foreignKeyColumnChainTokens = new String[0];
    private ICell foreignKeyCell;
    public static final String ARRAY_ACCESS_PATTERN = ".+\\[[0-9]+\\]$";

    public ForeignKeyColumnDescriptor(IOpenField field, IdentifierNode foreignKeyTable, IdentifierNode foreignKey, IdentifierNode[] foreignKeyTableAccessorChainTokens, ICell foreignKeyCell, StringValue displayValue, OpenL openl, boolean constructor, IdentifierNode[] fieldChainTokens) {
        super(field, displayValue, openl, constructor, fieldChainTokens);
        this.foreignKeyTable = foreignKeyTable;
        this.foreignKey = foreignKey;
        this.foreignKeyTableAccessorChainTokens = foreignKeyTableAccessorChainTokens;
        this.foreignKeyCell = foreignKeyCell;
    }

    private String getCellStringValue(ILogicalTable cellTable) {
        String value = cellTable.getSource().getCell(0, 0).getStringValue();
        if (value != null) {
            value = value.trim();
        }
        return value;
    }

    private ArrayList<Object> getArrayValuesByForeignKey(ILogicalTable valuesTable, IBindingContext bindingContext, ITable foreignTable, int foreignKeyIndex, IdentifierNode[] foreignKeyTableAccessorChainTokens, DomainOpenClass domainClass) throws SyntaxNodeException {
        ArrayList<Object> values;
        block7: {
            int valuesHeight;
            block6: {
                String[] tokens;
                valuesHeight = valuesTable.getHeight();
                values = new ArrayList<Object>(valuesHeight);
                if (valuesHeight != 1) break block6;
                if (!bindingContext.isExecutionMode()) {
                    RuleRowHelper.setCellMetaInfo(valuesTable, this.getField().getName(), (IOpenClass)domainClass, true);
                }
                if ((tokens = RuleRowHelper.extractElementsFromCommaSeparatedArray(valuesTable)) == null) break block7;
                for (String token : tokens) {
                    Object res = this.getValueByForeignKeyIndex(bindingContext, foreignTable, foreignKeyIndex, foreignKeyTableAccessorChainTokens, valuesTable, token);
                    this.addResValues(values, res);
                }
                break block7;
            }
            for (int i = 0; i < valuesHeight; ++i) {
                ILogicalTable valueTable = (ILogicalTable)valuesTable.getRow(i);
                String value = this.getCellStringValue(valueTable);
                if (value == null || value.length() == 0) {
                    if (!bindingContext.isExecutionMode()) {
                        RuleRowHelper.setCellMetaInfo(valueTable, this.getField().getName(), (IOpenClass)domainClass, false);
                    }
                    values.add(null);
                    continue;
                }
                if (!bindingContext.isExecutionMode()) {
                    RuleRowHelper.setCellMetaInfo(valueTable, this.getField().getName(), (IOpenClass)domainClass, false);
                }
                Object res = this.getValueByForeignKeyIndex(bindingContext, foreignTable, foreignKeyIndex, foreignKeyTableAccessorChainTokens, valueTable, value);
                this.addResValues(values, res);
            }
        }
        return values;
    }

    private void addResValues(ArrayList<Object> values, Object res) {
        if (res != null && res.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(res); ++i) {
                values.add(Array.get(res, i));
            }
        } else {
            values.add(res);
        }
    }

    private Object getValueByForeignKeyIndex(IBindingContext bindingContext, ITable foreignTable, int foreignKeyIndex, IdentifierNode[] foreignKeyTableAccessorChainTokens, ILogicalTable valueTable, String key) throws SyntaxNodeException {
        Object result = null;
        try {
            if (this.foreignKeyColumnChainTokens.length == 0) {
                this.foreignKeyColumnChainTokens = (String[])ArrayUtils.add((Object[])this.foreignKeyColumnChainTokens, (Object)foreignTable.getColumnName(foreignKeyIndex));
                ColumnDescriptor foreignColumnDescriptor = foreignTable.getDataModel().getDescriptor()[foreignKeyIndex];
                if (foreignColumnDescriptor.isReference() && foreignColumnDescriptor instanceof ForeignKeyColumnDescriptor) {
                    Object[] endOfChain = ((ForeignKeyColumnDescriptor)foreignColumnDescriptor).foreignKeyColumnChainTokens;
                    this.foreignKeyColumnChainTokens = (String[])ArrayUtils.addAll((Object[])this.foreignKeyColumnChainTokens, (Object[])endOfChain);
                }
            }
            if ((result = foreignTable.findObject(foreignKeyIndex, key, bindingContext)) == null) {
                this.throwIndexNotFound(foreignTable, valueTable, key, null, bindingContext);
            }
            if (!ArrayUtils.isEmpty((Object[])foreignKeyTableAccessorChainTokens)) {
                ResultChainObject chainRes = this.getChainObject(result, foreignKeyTableAccessorChainTokens);
                result = chainRes.getValue();
            }
        }
        catch (SyntaxNodeException ex) {
            this.throwIndexNotFound(foreignTable, valueTable, key, (Exception)((Object)ex), bindingContext);
        }
        return result;
    }

    private void throwIndexNotFound(ITable foreignTable, ILogicalTable valuesTable, String src, Exception ex, IBindingContext bindingContext) throws SyntaxNodeException {
        String message = String.format("Index Key %s is not found in the foreign table %s", src, foreignTable.getName());
        throw SyntaxNodeExceptionUtils.createError((String)message, (Throwable)ex, null, (IOpenSourceCodeModule)new GridCellSourceCodeModule(valuesTable.getSource(), bindingContext));
    }

    public Object getLiteralByForeignKey(IOpenClass fieldType, ILogicalTable valuesTable, IDataBase db, IBindingContext bindingContext) throws Exception {
        String foreignKeyTableName = this.foreignKeyTable.getIdentifier();
        ITable foreignTable = db.getTable(foreignKeyTableName);
        Object result = null;
        if (foreignTable == null) {
            String message = String.format("Table '%s' is not found", foreignKeyTableName);
            throw SyntaxNodeExceptionUtils.createError((String)message, null, (ISyntaxNode)this.foreignKeyTable);
        }
        if (foreignTable.getTableSyntaxNode().hasErrors()) {
            String message = String.format("Foreign table '%s' has errors", foreignKeyTableName);
            throw SyntaxNodeExceptionUtils.createError((String)message, null, (ISyntaxNode)this.foreignKeyTable);
        }
        int foreignKeyIndex = 0;
        String columnName = NOT_INITIALIZED;
        if (this.foreignKey != null) {
            columnName = this.foreignKey.getIdentifier();
            foreignKeyIndex = foreignTable.getColumnIndex(columnName);
        }
        if (foreignKeyIndex == -1) {
            String message = "Column '" + columnName + "' is not found";
            throw SyntaxNodeExceptionUtils.createError((String)message, null, (ISyntaxNode)this.foreignKey);
        }
        boolean valuesAnArray = ForeignKeyColumnDescriptor.isValuesAnArray(fieldType);
        if (!valuesAnArray) {
            String value = this.getCellStringValue(valuesTable);
            if (value != null && value.length() > 0) {
                result = this.getValueByForeignKeyIndex(bindingContext, foreignTable, foreignKeyIndex, this.foreignKeyTableAccessorChainTokens, valuesTable, value);
            }
        } else {
            ILogicalTable valueTable;
            String value;
            ArrayList<Object> values = new ArrayList<Object>();
            int valuesHeight = valuesTable.getHeight();
            for (int i = 0; i < valuesHeight && (value = this.getCellStringValue(valueTable = (ILogicalTable)valuesTable.getRow(i))) != null && value.length() != 0; ++i) {
                Object res = this.getValueByForeignKeyIndex(bindingContext, foreignTable, foreignKeyIndex, this.foreignKeyTableAccessorChainTokens, valueTable, value);
                values.add(res);
            }
            IOpenClass componentType = fieldType.getAggregateInfo().getComponentType(fieldType);
            Object ary = fieldType.getAggregateInfo().makeIndexedAggregate(componentType, new int[]{values.size()});
            for (int i = 0; i < values.size(); ++i) {
                Array.set(ary, i, values.get(i));
            }
            result = ary;
        }
        return result;
    }

    @Override
    public boolean isReference() {
        return this.foreignKeyTable != null;
    }

    public void populateLiteralByForeignKey(Object target, ILogicalTable valuesTable, IDataBase db, IBindingContext cxt) throws Exception {
        if (this.getField() != null && this.foreignKeyTable != null) {
            String foreignKeyTableName = this.foreignKeyTable.getIdentifier();
            ITable foreignTable = db.getTable(foreignKeyTableName);
            if (foreignTable == null) {
                String message = String.format("Table '%s' is not found", foreignKeyTableName);
                throw SyntaxNodeExceptionUtils.createError((String)message, null, (ISyntaxNode)this.foreignKeyTable);
            }
            if (foreignTable.getTableSyntaxNode().hasErrors()) {
                String message = String.format("Foreign table '%s' has errors", foreignKeyTableName);
                throw SyntaxNodeExceptionUtils.createError((String)message, null, (ISyntaxNode)this.foreignKeyTable);
            }
            int foreignKeyIndex = 0;
            String columnName = NOT_INITIALIZED;
            if (this.foreignKey != null) {
                columnName = this.foreignKey.getIdentifier();
                foreignKeyIndex = foreignTable.getColumnIndex(columnName);
            }
            if (foreignKeyIndex == -1) {
                String message = "Column '" + columnName + "' is not found";
                throw SyntaxNodeExceptionUtils.createError((String)message, null, (ISyntaxNode)this.foreignKey);
            }
            final Map<String, Integer> index = foreignTable.getFormattedUniqueIndex(foreignKeyIndex);
            Set<String> strings = index.keySet();
            Object[] domainStrings = strings.toArray(new String[strings.size()]);
            Arrays.sort(domainStrings, new Comparator<String>(){

                @Override
                public int compare(String ds1, String ds2) {
                    return ((Integer)index.get(ds1)).compareTo((Integer)index.get(ds2));
                }
            });
            IOpenClass columnType = foreignTable.getColumnType(foreignKeyIndex);
            EnumDomain domain = new EnumDomain(domainStrings);
            DomainOpenClass domainClass = new DomainOpenClass(this.getField().getName(), (IOpenClass)(columnType != null ? columnType : JavaOpenClass.STRING), (IDomain)domain, null);
            valuesTable = LogicalTableHelper.make1ColumnTable(valuesTable);
            IOpenClass fieldType = this.getField().getType();
            boolean valueAnArray = ForeignKeyColumnDescriptor.isValuesAnArray(fieldType);
            boolean isList = List.class.isAssignableFrom(fieldType.getInstanceClass());
            IOpenClass resType = foreignTable.getDataModel().getType();
            String s = this.getCellStringValue(valuesTable);
            if (!StringUtils.isEmpty((CharSequence)s)) {
                try {
                    Object result = foreignTable.findObject(foreignKeyIndex, s, cxt);
                    if (result != null) {
                        ResultChainObject chainRes = this.getChainObject(result, this.foreignKeyTableAccessorChainTokens);
                        Class<?> instanceClass = chainRes.instanceClass;
                        int dim = 0;
                        while (instanceClass.isArray()) {
                            instanceClass = instanceClass.getComponentType();
                            ++dim;
                        }
                        resType = cxt.findType("org.openl.this", instanceClass.getSimpleName());
                        if (dim > 0) {
                            resType = resType.getArrayType(dim);
                        }
                    }
                }
                catch (SyntaxNodeException ex) {
                    this.throwIndexNotFound(foreignTable, valuesTable, s, (Exception)((Object)ex), cxt);
                }
            }
            if (!fieldType.isArray() || !fieldType.getComponentClass().getInstanceClass().equals(resType.getInstanceClass())) {
                if (StringUtils.isEmpty((CharSequence)s)) {
                    if (!cxt.isExecutionMode()) {
                        RuleRowHelper.setCellMetaInfo(valuesTable, this.getField().getName(), (IOpenClass)domainClass, false);
                    }
                } else {
                    if (!cxt.isExecutionMode()) {
                        RuleRowHelper.setCellMetaInfo(valuesTable, this.getField().getName(), (IOpenClass)domainClass, false);
                    }
                    Object res = this.getValueByForeignKeyIndex(cxt, foreignTable, foreignKeyIndex, this.foreignKeyTableAccessorChainTokens, valuesTable, s);
                    IOpenCast cast = cxt.getCast(resType, fieldType);
                    if (cast == null || !cast.isImplicit()) {
                        String message = String.format("Incompatible types: Field '%s' has type [%s] that differs from type of foreign table [%s]", this.getField().getName(), fieldType, resType);
                        throw SyntaxNodeExceptionUtils.createError((String)message, null, (ISyntaxNode)this.foreignKeyTable);
                    }
                    this.getField().set(target, cast.convert(res), this.getRuntimeEnv());
                }
            } else {
                ArrayList<Object> cellValues = this.getArrayValuesByForeignKey(valuesTable, cxt, foreignTable, foreignKeyIndex, this.foreignKeyTableAccessorChainTokens, domainClass);
                List values = CollectionUtils.findAll(cellValues, (CollectionUtils.Predicate)new CollectionUtils.Predicate<Object>(){

                    public boolean evaluate(Object arg) {
                        return arg != null;
                    }
                });
                int size = values.size();
                Object componentType = valueAnArray ? fieldType.getAggregateInfo().getComponentType(fieldType) : JavaOpenClass.OBJECT;
                Object array = fieldType.getAggregateInfo().makeIndexedAggregate((IOpenClass)componentType, new int[]{size});
                for (int i = 0; i < size; ++i) {
                    Array.set(array, i, values.get(i));
                }
                if (isList) {
                    int len = Array.getLength(array);
                    ArrayList<Object> list = new ArrayList<Object>(len);
                    for (int i = 0; i < len; ++i) {
                        list.add(Array.get(array, i));
                    }
                    this.getField().set(target, list, this.getRuntimeEnv());
                } else {
                    this.getField().set(target, array, this.getRuntimeEnv());
                }
            }
        }
    }

    private static int getArrayIndex(IdentifierNode fieldNameNode) {
        String fieldName = fieldNameNode.getIdentifier();
        String txtIndex = fieldName.substring(fieldName.indexOf("[") + 1, fieldName.indexOf("]"));
        return Integer.parseInt(txtIndex);
    }

    private static String getArrayName(IdentifierNode fieldNameNode) {
        String fieldName = fieldNameNode.getIdentifier();
        return fieldName.substring(0, fieldName.indexOf("["));
    }

    private ResultChainObject getChainObject(Object parentObj, IdentifierNode[] fieldChainTokens) throws SyntaxNodeException {
        Object resObj = parentObj;
        Class<?> resInctClass = parentObj.getClass();
        for (int i = 1; i < fieldChainTokens.length; ++i) {
            IdentifierNode token = fieldChainTokens[i];
            if (resObj == null) {
                String message = String.format("Incorrect field '%s' in type [%s]", token.getIdentifier(), resInctClass);
                throw SyntaxNodeExceptionUtils.createError((String)message, null, (ISyntaxNode)this.foreignKeyTable);
            }
            boolean arrayAccess = token.getIdentifier().matches(ARRAY_ACCESS_PATTERN);
            Object prevResObj = resObj;
            try {
                Method method = arrayAccess ? resObj.getClass().getMethod(StringTool.getGetterName((String)ForeignKeyColumnDescriptor.getArrayName(token)), new Class[0]) : resObj.getClass().getMethod(StringTool.getGetterName((String)token.getIdentifier()), new Class[0]);
                resObj = method.invoke(resObj, new Object[0]);
                if (resObj == null) {
                    if (arrayAccess) {
                        String message = String.format("Incorrect array access in field '%s' of type [%s]", token.getIdentifier(), prevResObj.getClass());
                        throw SyntaxNodeExceptionUtils.createError((String)message, null, (ISyntaxNode)this.foreignKeyTable);
                    }
                    resInctClass = method.getReturnType();
                    continue;
                }
                if (arrayAccess) {
                    int arrayIndex = ForeignKeyColumnDescriptor.getArrayIndex(token);
                    resObj = Array.get(resObj, arrayIndex);
                }
                resInctClass = resObj.getClass();
                continue;
            }
            catch (SyntaxNodeException e) {
                throw e;
            }
            catch (Exception e) {
                String message = String.format("Incorrect field '%s' in type [%s]", token.getIdentifier(), resObj == null ? prevResObj.getClass() : resObj.getClass());
                throw SyntaxNodeExceptionUtils.createError((String)message, null, (ISyntaxNode)this.foreignKeyTable);
            }
        }
        return new ResultChainObject(resObj, resInctClass);
    }

    public void setForeignKeyCellMetaInfo(IDataBase db) {
        ITable foreignTable;
        if (this.foreignKeyCell != null && (foreignTable = db.getTable(this.foreignKeyTable.getIdentifier())) != null) {
            ILocation location = this.foreignKeyTable.getLocation();
            SimpleNodeUsage nodeUsage = new SimpleNodeUsage(location.getStart().getAbsolutePosition(new TextInfo(foreignTable.getName())), location.getEnd().getAbsolutePosition(new TextInfo(foreignTable.getName())) - 1, foreignTable.getTableSyntaxNode().getHeaderLineValue().getValue(), foreignTable.getTableSyntaxNode().getUri(), NodeType.DATA);
            CellMetaInfo meta = new CellMetaInfo(CellMetaInfo.Type.DT_CA_CODE, null, (IOpenClass)JavaOpenClass.STRING, false, Collections.singletonList(nodeUsage));
            this.foreignKeyCell.setMetaInfo(meta);
        }
        this.foreignKeyCell = null;
    }

    public IOpenField getForeignKeyField(IOpenClass type, IDataBase db) {
        if (this.foreignKeyColumnChainTokens.length > 0) {
            String fieldName = this.foreignKeyColumnChainTokens[this.foreignKeyColumnChainTokens.length - 1];
            if (ForeignKeyColumnDescriptor.isValuesAnArray(type)) {
                type = type.getComponentClass();
            }
            ITable table = db == null || this.foreignKeyTable == null ? null : db.getTable(this.foreignKeyTable.getIdentifier());
            return table == null ? type.getField(fieldName) : DataTableBindHelper.findField(fieldName, table, type);
        }
        return null;
    }

    static class ResultChainObject {
        private Object value;
        private Class<?> instanceClass;

        ResultChainObject(Object value, Class<?> instanceClass) {
            this.value = value;
            this.instanceClass = instanceClass;
        }

        public Object getValue() {
            return this.value;
        }

        public Class<?> getInstanceClass() {
            return this.instanceClass;
        }
    }
}

