/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.data;

import java.lang.reflect.Array;
import org.openl.exception.OpenLRuntimeException;
import org.openl.message.OpenLMessagesUtils;
import org.openl.types.IOpenClass;
import org.openl.types.impl.AOpenField;
import org.openl.vm.IRuntimeEnv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThisArrayElementField
extends AOpenField {
    private final Logger log = LoggerFactory.getLogger(ThisArrayElementField.class);
    private int elementIndex;

    public ThisArrayElementField(int elementIndex, IOpenClass type) {
        super(ThisArrayElementField.getName("", elementIndex), type);
        this.elementIndex = elementIndex;
    }

    public Object get(Object target, IRuntimeEnv env) {
        if (target == null) {
            return null;
        }
        Object res = null;
        try {
            res = target == null || Array.getLength(target) < this.elementIndex + 1 ? this.getType().nullObject() : Array.get(target, this.elementIndex);
        }
        catch (SecurityException e) {
            this.processError(e);
        }
        return res != null ? res : this.getType().nullObject();
    }

    public void set(Object target, Object value, IRuntimeEnv env) {
        if (target == null) {
            throw new OpenLRuntimeException(String.format("Can not set [%s] field to \"null\" object", this.getName()));
        }
        try {
            Object arr = target;
            if (Array.getLength(arr) < this.elementIndex + 1) {
                Object newArray = Array.newInstance(this.getType().getInstanceClass(), this.elementIndex + 1);
                int oldArryLeng = Array.getLength(arr);
                for (int i = 0; i < oldArryLeng; ++i) {
                    Array.set(newArray, i, Array.get(arr, i));
                }
                Array.set(newArray, this.elementIndex, value);
                env.popThis();
                env.pushThis(newArray);
            } else {
                Array.set(arr, this.elementIndex, value);
            }
        }
        catch (SecurityException e) {
            this.processError(e);
        }
    }

    private void processError(Throwable e1) {
        this.log.error("{}", (Object)this, (Object)e1);
        OpenLMessagesUtils.addError((Throwable)e1);
    }

    public boolean isWritable() {
        return true;
    }

    private static String getName(String name, int index) {
        return name + "[" + index + "]";
    }

    public static final class TargetWrapperForSetterMethod {
        private Object target;

        public TargetWrapperForSetterMethod(Object target) {
            this.target = target;
        }

        public Object getTarget() {
            return this.target;
        }

        public void updateTarget(Object target) {
            this.target = target;
        }
    }
}

