/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.datatype.gen;

import java.util.HashMap;
import java.util.Map;
import org.openl.rules.convertor.IString2DataConvertor;
import org.openl.rules.convertor.String2DataConvertorFactory;
import org.openl.util.StringUtils;

public class FieldDescription {
    private static final Map<String, Class> classMap = new HashMap<String, Class>(8, 1.0f){
        {
            this.put("int", Integer.TYPE);
            this.put("long", Long.TYPE);
            this.put("char", Character.TYPE);
            this.put("short", Short.TYPE);
            this.put("byte", Byte.TYPE);
            this.put("double", Double.TYPE);
            this.put("float", Float.TYPE);
            this.put("boolean", Boolean.TYPE);
        }
    };
    private final String typeName;
    private final String typeDescriptor;
    private String defaultValueAsString;
    private Object defaultValue;

    public FieldDescription(String typeName) {
        this.typeName = typeName;
        if ("byte".equals(typeName)) {
            this.typeDescriptor = "B";
        } else if ("short".equals(typeName)) {
            this.typeDescriptor = "S";
        } else if ("int".equals(typeName)) {
            this.typeDescriptor = "I";
        } else if ("long".equals(typeName)) {
            this.typeDescriptor = "J";
        } else if ("float".equals(typeName)) {
            this.typeDescriptor = "F";
        } else if ("double".equals(typeName)) {
            this.typeDescriptor = "D";
        } else if ("boolean".equals(typeName)) {
            this.typeDescriptor = "Z";
        } else if ("char".equals(typeName)) {
            this.typeDescriptor = "C";
        } else {
            String internal = typeName;
            if (typeName.charAt(0) != '[') {
                internal = 'L' + internal + ';';
            }
            this.typeDescriptor = internal.replace('.', '/');
        }
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getTypeDescriptor() {
        return this.typeDescriptor;
    }

    private Class<?> getType() {
        Class cl = classMap.get(this.typeName);
        if (cl != null) {
            return cl;
        }
        try {
            return Class.forName(this.typeName);
        }
        catch (ClassNotFoundException e) {
            return Object.class;
        }
    }

    public String getDefaultValueAsString() {
        return this.defaultValueAsString;
    }

    public void setDefaultValueAsString(String defaultValueAsString) {
        this.defaultValueAsString = defaultValueAsString;
    }

    public boolean isArray() {
        return this.typeName.indexOf(91) >= 0;
    }

    public String toString() {
        if (StringUtils.isNotBlank((CharSequence)this.typeName)) {
            return this.typeName;
        }
        return super.toString();
    }

    public Object getDefaultValue() {
        if (this.defaultValue == null && this.defaultValueAsString != null) {
            if ("_DEFAULT_".equals(this.defaultValueAsString)) {
                this.defaultValue = "_DEFAULT_";
            } else {
                if (this.typeName.startsWith("[[")) {
                    throw new IllegalStateException("Multi-dimensional arrays aren't supported!");
                }
                IString2DataConvertor<?> convertor = String2DataConvertorFactory.getConvertor(this.getType());
                this.defaultValue = convertor.parse(this.defaultValueAsString, null);
            }
        }
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean hasDefaultValue() {
        return StringUtils.isNotBlank((CharSequence)this.defaultValueAsString) && this.getDefaultValue() != null;
    }

    public boolean hasDefaultKeyWord() {
        return this.hasDefaultValue() && "_DEFAULT_".equals(this.getDefaultValue());
    }
}

