/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.datatype.gen;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Type;
import org.openl.rules.datatype.gen.FieldDescription;
import org.openl.rules.datatype.gen.bean.writers.BeanByteCodeWriter;
import org.openl.rules.datatype.gen.bean.writers.ConstructorWithParametersWriter;
import org.openl.rules.datatype.gen.bean.writers.DefaultBeanByteCodeWriter;
import org.openl.rules.datatype.gen.bean.writers.DefaultConstructorWriter;
import org.openl.rules.datatype.gen.bean.writers.DefaultValue;
import org.openl.rules.datatype.gen.bean.writers.EqualsWriter;
import org.openl.rules.datatype.gen.bean.writers.GettersWriter;
import org.openl.rules.datatype.gen.bean.writers.HashCodeWriter;
import org.openl.rules.datatype.gen.bean.writers.ISO8601DateFormater;
import org.openl.rules.datatype.gen.bean.writers.SettersWriter;
import org.openl.rules.datatype.gen.bean.writers.ToStringWriter;

public class SimpleBeanByteCodeGenerator {
    private byte[] bytes;

    public SimpleBeanByteCodeGenerator(String beanName, Map<String, FieldDescription> beanFields, Class<?> parentClass, Map<String, FieldDescription> parentFields) {
        String beanNameWithPackage = beanName.replace('.', '/');
        LinkedHashMap<String, FieldDescription> allFields = new LinkedHashMap<String, FieldDescription>();
        allFields.putAll(parentFields);
        allFields.putAll(beanFields);
        ArrayList<DefaultBeanByteCodeWriter> writers = new ArrayList<DefaultBeanByteCodeWriter>();
        writers.add(new DefaultConstructorWriter(beanNameWithPackage, parentClass, beanFields));
        if (allFields.size() < 256) {
            writers.add(new ConstructorWithParametersWriter(beanNameWithPackage, parentClass, beanFields, parentFields, allFields));
        }
        writers.add(new GettersWriter(beanNameWithPackage, beanFields));
        writers.add(new SettersWriter(beanNameWithPackage, beanFields));
        writers.add(new ToStringWriter(beanNameWithPackage, allFields));
        writers.add(new EqualsWriter(beanNameWithPackage, allFields));
        writers.add(new HashCodeWriter(beanNameWithPackage, allFields));
        ClassWriter classWriter = new ClassWriter(1);
        SimpleBeanByteCodeGenerator.visitClassDescription(classWriter, beanNameWithPackage, parentClass);
        SimpleBeanByteCodeGenerator.visitJAXBAnnotation(classWriter, beanNameWithPackage);
        SimpleBeanByteCodeGenerator.visitFields(classWriter, beanFields);
        for (BeanByteCodeWriter beanByteCodeWriter : writers) {
            beanByteCodeWriter.write(classWriter);
        }
        this.bytes = classWriter.toByteArray();
    }

    private static void visitClassDescription(ClassWriter classWriter, String className, Class<?> parentClass) {
        String[] interfaces = new String[]{"java/io/Serializable"};
        String parent = Type.getInternalName(parentClass);
        classWriter.visit(50, 33, className, null, parent, interfaces);
    }

    private static void visitJAXBAnnotation(ClassWriter classWriter, String beannameWithPackage) {
        String namespace = SimpleBeanByteCodeGenerator.getNamespace(beannameWithPackage);
        AnnotationVisitor av = classWriter.visitAnnotation("Ljavax/xml/bind/annotation/XmlRootElement;", true);
        av.visit("namespace", (Object)namespace);
        av.visitEnd();
        av = classWriter.visitAnnotation("Ljavax/xml/bind/annotation/XmlType;", true);
        av.visit("namespace", (Object)namespace);
        av.visitEnd();
    }

    private static void visitFields(ClassWriter classWriter, Map<String, FieldDescription> beanFields) {
        for (Map.Entry<String, FieldDescription> field : beanFields.entrySet()) {
            String fieldTypeName = field.getValue().getTypeDescriptor();
            FieldVisitor fieldVisitor = classWriter.visitField(4, field.getKey(), fieldTypeName, null, null);
            if (!field.getValue().hasDefaultValue()) continue;
            AnnotationVisitor annotationVisitor = fieldVisitor.visitAnnotation(Type.getDescriptor(DefaultValue.class), true);
            if (field.getValue().getTypeName().equals(Date.class.getName())) {
                Object value = field.getValue().getDefaultValue();
                if (value instanceof Date) {
                    Date date = (Date)value;
                    String formatedDate = ISO8601DateFormater.format(date);
                    annotationVisitor.visit("value", (Object)formatedDate);
                }
            } else {
                annotationVisitor.visit("value", (Object)field.getValue().getDefaultValueAsString());
            }
            annotationVisitor.visitEnd();
        }
    }

    private static String getNamespace(String beannameWithPackage) {
        String[] parts = beannameWithPackage.split("/");
        StringBuilder builder = new StringBuilder("http://");
        for (int i = parts.length - 2; i >= 0; --i) {
            builder.append(parts[i]);
            if (i == 0) continue;
            builder.append(".");
        }
        return builder.toString();
    }

    public byte[] byteCode() {
        return this.bytes;
    }
}

