/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.datatype.gen.bean.writers;

import java.lang.reflect.Constructor;
import java.util.LinkedHashMap;
import java.util.Map;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.openl.rules.datatype.gen.FieldDescription;
import org.openl.rules.datatype.gen.bean.writers.DefaultBeanByteCodeWriter;

public class ConstructorWithParametersWriter
extends DefaultBeanByteCodeWriter {
    private Map<String, FieldDescription> parentFields;
    private Map<String, FieldDescription> allFields;

    public ConstructorWithParametersWriter(String beanNameWithPackage, Class<?> parentClass, Map<String, FieldDescription> beanFields, Map<String, FieldDescription> parentFields, Map<String, FieldDescription> allFields) {
        super(beanNameWithPackage, parentClass, beanFields);
        this.parentFields = new LinkedHashMap<String, FieldDescription>(parentFields);
        this.allFields = new LinkedHashMap<String, FieldDescription>(allFields);
    }

    @Override
    public void write(ClassWriter classWriter) {
        MethodVisitor methodVisitor;
        Constructor<?> parentConstructor = null;
        for (Constructor<?> constructor : this.getParentClass().getConstructors()) {
            if (constructor.getParameterTypes().length != this.parentFields.size()) continue;
            parentConstructor = constructor;
            break;
        }
        int i = 1;
        String parentName = Type.getInternalName(this.getParentClass());
        if (parentConstructor == null) {
            methodVisitor = classWriter.visitMethod(1, "<init>", ConstructorWithParametersWriter.getMethodSignatureForByteCode(this.getBeanFields()), null, null);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(183, parentName, "<init>", "()V");
        } else {
            methodVisitor = classWriter.visitMethod(1, "<init>", ConstructorWithParametersWriter.getMethodSignatureForByteCode(this.allFields), null, null);
            methodVisitor.visitVarInsn(25, 0);
            for (Map.Entry<String, FieldDescription> fieldEntry : this.parentFields.entrySet()) {
                FieldDescription field = fieldEntry.getValue();
                methodVisitor.visitVarInsn(this.getConstantForVarInsn(field), i);
                if (Long.TYPE.getName().equals(field.getTypeName()) || Double.TYPE.getName().equals(field.getTypeName())) {
                    i += 2;
                    continue;
                }
                ++i;
            }
            methodVisitor.visitMethodInsn(183, parentName, "<init>", ConstructorWithParametersWriter.getMethodSignatureForByteCode(this.parentFields));
        }
        for (Map.Entry<String, FieldDescription> field : this.getBeanFields().entrySet()) {
            String fieldName = field.getKey();
            if (this.parentFields.get(fieldName) != null) continue;
            FieldDescription fieldType = field.getValue();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(this.getConstantForVarInsn(fieldType), i);
            methodVisitor.visitFieldInsn(181, this.getBeanNameWithPackage(), fieldName, fieldType.getTypeDescriptor());
            if (Long.TYPE.getName().equals(fieldType.getTypeName()) || Double.TYPE.getName().equals(fieldType.getTypeName())) {
                i += 2;
                continue;
            }
            ++i;
        }
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
    }

    private static String getMethodSignatureForByteCode(Map<String, FieldDescription> params) {
        StringBuilder signatureBuilder = new StringBuilder("(");
        for (Map.Entry<String, FieldDescription> field : params.entrySet()) {
            String javaType = field.getValue().getTypeDescriptor();
            signatureBuilder.append(javaType);
        }
        signatureBuilder.append(")");
        signatureBuilder.append("V");
        return signatureBuilder.toString();
    }
}

