/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.datatype.gen.bean.writers;

import java.util.LinkedHashMap;
import java.util.Map;
import org.objectweb.asm.Type;
import org.openl.rules.datatype.gen.FieldDescription;
import org.openl.rules.datatype.gen.bean.writers.BeanByteCodeWriter;

public abstract class DefaultBeanByteCodeWriter
implements BeanByteCodeWriter {
    private String beanNameWithPackage;
    private Class<?> parentClass;
    private Map<String, FieldDescription> beanFields;

    public DefaultBeanByteCodeWriter(String beanNameWithPackage, Class<?> parentClass, Map<String, FieldDescription> beanFields) {
        this.beanNameWithPackage = beanNameWithPackage;
        this.parentClass = parentClass;
        this.beanFields = new LinkedHashMap<String, FieldDescription>(beanFields);
    }

    protected int getConstantForVarInsn(FieldDescription field) {
        String retClass = field.getTypeDescriptor();
        Type type = Type.getType((String)retClass);
        return type.getOpcode(21);
    }

    protected String getBeanNameWithPackage() {
        return this.beanNameWithPackage;
    }

    protected Class<?> getParentClass() {
        return this.parentClass;
    }

    protected Map<String, FieldDescription> getBeanFields() {
        return this.beanFields;
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder(128);
        strBuilder.append(this.getClass().getSimpleName());
        strBuilder.append(" for ");
        strBuilder.append(this.beanNameWithPackage);
        return strBuilder.toString();
    }
}

