/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.datatype.gen.bean.writers;

import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;
import org.openl.rules.datatype.gen.FieldDescription;
import org.openl.rules.datatype.gen.bean.writers.DefaultBeanByteCodeWriter;

public class DefaultConstructorWriter
extends DefaultBeanByteCodeWriter {
    private static final Method STR_CONSTR = Method.getMethod((String)"void <init> (java.lang.String)");
    private static final Method DEF_CONSTR = Method.getMethod((String)"void <init> ()");
    public static final Map<String, Class<?>> DEFAULT_COLLECTIONS_INTERFACES;
    private static final Map<String, Class<?>> boxed;

    public DefaultConstructorWriter(String beanNameWithPackage, Class<?> parentClass, Map<String, FieldDescription> beanFields) {
        super(beanNameWithPackage, parentClass, beanFields);
    }

    private static void pushValue(GeneratorAdapter mg, Type type, Object value) {
        switch (type.getSort()) {
            case 1: {
                mg.push(((Boolean)value).booleanValue());
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                mg.push(((Number)value).intValue());
                break;
            }
            case 2: {
                mg.push((int)((Character)value).charValue());
                break;
            }
            case 8: {
                mg.push(((Double)value).doubleValue());
                break;
            }
            case 6: {
                mg.push(((Float)value).floatValue());
                break;
            }
            case 7: {
                mg.push(((Long)value).longValue());
                break;
            }
            case 9: {
                DefaultConstructorWriter.pushArray(mg, type, value);
                break;
            }
            case 10: {
                DefaultConstructorWriter.pushObject(mg, type, value);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported type");
            }
        }
    }

    private static void pushArray(GeneratorAdapter mg, Type type, Object value) {
        int dimensions = type.getDimensions();
        if ("_DEFAULT_".equals(value)) {
            if (dimensions == 1) {
                mg.visitInsn(3);
                Type elementType = type.getElementType();
                mg.newArray(elementType);
            } else {
                for (int i = 0; i < dimensions; ++i) {
                    mg.visitInsn(3);
                }
                mg.visitMultiANewArrayInsn(type.getDescriptor(), dimensions);
            }
        } else {
            int length = Array.getLength(value);
            mg.push(length);
            Type elementType = Type.getType((String)type.getDescriptor().substring(1));
            mg.newArray(elementType);
            for (int i = 0; i < length; ++i) {
                Object element = Array.get(value, i);
                mg.dup();
                mg.push(i);
                DefaultConstructorWriter.pushValue(mg, elementType, element);
                mg.arrayStore(elementType);
            }
        }
    }

    private static void pushObject(GeneratorAdapter mg, Type type, Object value) {
        String className = type.getClassName();
        if ("_DEFAULT_".equals(value)) {
            if (DEFAULT_COLLECTIONS_INTERFACES.containsKey(className)) {
                Class<?> defaultImpl = DEFAULT_COLLECTIONS_INTERFACES.get(className);
                Type defaultImplType = Type.getType(defaultImpl);
                mg.newInstance(defaultImplType);
                mg.dup();
                mg.invokeConstructor(defaultImplType, DEF_CONSTR);
            } else {
                mg.newInstance(type);
                mg.dup();
                mg.invokeConstructor(type, DEF_CONSTR);
            }
        } else if (className.equals(String.class.getName())) {
            mg.push((String)value);
        } else if (className.equals(Date.class.getName())) {
            mg.newInstance(type);
            mg.dup();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss a", Locale.US);
            mg.push(simpleDateFormat.format((Date)value));
            mg.invokeConstructor(type, STR_CONSTR);
        } else if (boxed.containsKey(className)) {
            Class<?> prim = boxed.get(className);
            Type primType = Type.getType(prim);
            DefaultConstructorWriter.pushValue(mg, primType, value);
            mg.valueOf(primType);
        } else if (value.getClass().isEnum()) {
            Class<?> enumClass = value.getClass();
            Type enumType = Type.getType(enumClass);
            mg.getStatic(enumType, ((Enum)value).name(), enumType);
        } else {
            mg.newInstance(type);
            mg.dup();
            mg.push(String.valueOf(value));
            mg.invokeConstructor(type, STR_CONSTR);
        }
    }

    @Override
    public void write(ClassWriter classWriter) {
        GeneratorAdapter mg = new GeneratorAdapter(1, DEF_CONSTR, null, null, (ClassVisitor)classWriter);
        mg.loadThis();
        mg.invokeConstructor(Type.getType(this.getParentClass()), DEF_CONSTR);
        for (Map.Entry<String, FieldDescription> field : this.getBeanFields().entrySet()) {
            FieldDescription fieldDescription = field.getValue();
            if (!fieldDescription.hasDefaultValue()) continue;
            mg.loadThis();
            Object value = fieldDescription.getDefaultValue();
            String retClass = fieldDescription.getTypeDescriptor();
            Type type = Type.getType((String)retClass);
            DefaultConstructorWriter.pushValue(mg, type, value);
            String fieldTypeName = fieldDescription.getTypeDescriptor();
            mg.visitFieldInsn(181, this.getBeanNameWithPackage(), field.getKey(), fieldTypeName);
        }
        mg.returnValue();
        mg.endMethod();
    }

    static {
        boxed = new HashMap(8);
        boxed.put(Byte.class.getName(), Byte.TYPE);
        boxed.put(Short.class.getName(), Short.TYPE);
        boxed.put(Integer.class.getName(), Integer.TYPE);
        boxed.put(Boolean.class.getName(), Boolean.TYPE);
        boxed.put(Character.class.getName(), Character.TYPE);
        boxed.put(Long.class.getName(), Long.TYPE);
        boxed.put(Float.class.getName(), Float.TYPE);
        boxed.put(Double.class.getName(), Double.TYPE);
        HashMap<String, Class<TreeMap>> defaultInterfaceCollections = new HashMap<String, Class<TreeMap>>(6);
        defaultInterfaceCollections.put(Collection.class.getName(), ArrayList.class);
        defaultInterfaceCollections.put(List.class.getName(), ArrayList.class);
        defaultInterfaceCollections.put(Set.class.getName(), HashSet.class);
        defaultInterfaceCollections.put(SortedSet.class.getName(), TreeSet.class);
        defaultInterfaceCollections.put(Map.class.getName(), HashMap.class);
        defaultInterfaceCollections.put(SortedMap.class.getName(), TreeMap.class);
        DEFAULT_COLLECTIONS_INTERFACES = Collections.unmodifiableMap(defaultInterfaceCollections);
    }
}

