/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.datatype.gen.bean.writers;

import java.util.Map;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.openl.rules.datatype.gen.FieldDescription;
import org.openl.rules.datatype.gen.bean.writers.MethodWriter;

public class EqualsWriter
extends MethodWriter {
    public EqualsWriter(String beanNameWithPackage, Map<String, FieldDescription> allFields) {
        super(beanNameWithPackage, allFields);
    }

    @Override
    public void write(ClassWriter classWriter) {
        MethodVisitor mv = classWriter.visitMethod(1, "equals", "(Ljava/lang/Object;)Z", null, null);
        this.trueIfTheSame(mv);
        this.falseIfNull(mv);
        this.falseIfDifferentClassNames(mv);
        this.doCast(mv);
        Label retFalse = new Label();
        for (Map.Entry<String, FieldDescription> field : this.getAllFields().entrySet()) {
            this.pushFieldToStack(mv, 0, field.getKey());
            this.pushFieldToStack(mv, 2, field.getKey());
            String type = field.getValue().getTypeName();
            if ("double".equals(type)) {
                mv.visitMethodInsn(184, "java/lang/Double", "compare", "(DD)I");
                mv.visitJumpInsn(154, retFalse);
            } else if ("float".equals(type)) {
                mv.visitMethodInsn(184, "java/lang/Float", "compare", "(FF)I");
                mv.visitJumpInsn(154, retFalse);
            } else if ("long".equals(type)) {
                mv.visitInsn(148);
                mv.visitJumpInsn(154, retFalse);
            } else if ("int".equals(type) || "boolean".equals(type) || "short".equals(type) || "byte".equals(type) || "char".equals(type)) {
                mv.visitJumpInsn(160, retFalse);
            } else if (type.charAt(0) == '[' && type.length() == 2) {
                mv.visitMethodInsn(184, "java/util/Arrays", "equals", "(" + type + type + ")Z");
                mv.visitJumpInsn(153, retFalse);
            } else if (type.startsWith("[L")) {
                mv.visitMethodInsn(184, "java/util/Arrays", "equals", "([Ljava/lang/Object;[Ljava/lang/Object;)Z");
                mv.visitJumpInsn(153, retFalse);
            } else if (type.startsWith("[[")) {
                mv.visitMethodInsn(184, "java/util/Arrays", "deepEquals", "([Ljava/lang/Object;[Ljava/lang/Object;)Z");
                mv.visitJumpInsn(153, retFalse);
            } else {
                Label endif = new Label();
                Label isNull = new Label();
                mv.visitInsn(90);
                mv.visitJumpInsn(198, isNull);
                mv.visitMethodInsn(182, "java/lang/Object", "equals", "(Ljava/lang/Object;)Z");
                mv.visitJumpInsn(153, retFalse);
                mv.visitJumpInsn(167, endif);
                mv.visitLabel(isNull);
                String internalType = type.replace('.', '/');
                mv.visitFrame(0, 3, new Object[]{this.getBeanNameWithPackage(), "java/lang/Object", this.getBeanNameWithPackage()}, 2, new Object[]{internalType, internalType});
                mv.visitJumpInsn(166, retFalse);
                mv.visitLabel(endif);
            }
            mv.visitFrame(3, 0, null, 0, null);
        }
        mv.visitInsn(4);
        mv.visitInsn(172);
        mv.visitLabel(retFalse);
        mv.visitFrame(3, 0, null, 0, null);
        mv.visitInsn(3);
        mv.visitInsn(172);
        mv.visitMaxs(0, 0);
    }

    private void doCast(MethodVisitor mv) {
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, this.getBeanNameWithPackage());
        mv.visitVarInsn(58, 2);
        mv.visitFrame(1, 1, new Object[]{this.getBeanNameWithPackage()}, 0, new Object[0]);
    }

    private void falseIfDifferentClassNames(MethodVisitor mv) {
        Label endif = new Label();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;");
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;");
        mv.visitJumpInsn(165, endif);
        mv.visitInsn(3);
        mv.visitInsn(172);
        mv.visitLabel(endif);
        mv.visitFrame(3, 0, null, 0, null);
    }

    private void falseIfNull(MethodVisitor mv) {
        Label endif = new Label();
        mv.visitVarInsn(25, 1);
        mv.visitJumpInsn(199, endif);
        mv.visitInsn(3);
        mv.visitInsn(172);
        mv.visitLabel(endif);
        mv.visitFrame(3, 0, null, 0, null);
    }

    private void trueIfTheSame(MethodVisitor mv) {
        Label endif = new Label();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitJumpInsn(166, endif);
        mv.visitInsn(4);
        mv.visitInsn(172);
        mv.visitLabel(endif);
        mv.visitFrame(3, 0, null, 0, null);
    }
}

