/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.datatype.gen.bean.writers;

import java.util.Date;
import java.util.Map;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.openl.rules.datatype.gen.FieldDescription;
import org.openl.rules.datatype.gen.bean.writers.ISO8601DateFormater;
import org.openl.rules.datatype.gen.bean.writers.MethodWriter;
import org.openl.util.StringTool;
import org.openl.util.StringUtils;

public class GettersWriter
extends MethodWriter {
    public GettersWriter(String beanNameWithPackage, Map<String, FieldDescription> beanFields) {
        super(beanNameWithPackage, beanFields);
    }

    @Override
    public void write(ClassWriter classWriter) {
        for (Map.Entry<String, FieldDescription> field : this.getAllFields().entrySet()) {
            if (!this.validField(field.getKey(), field.getValue())) continue;
            this.generateGetter(classWriter, field);
        }
    }

    protected void generateGetter(ClassWriter classWriter, Map.Entry<String, FieldDescription> fieldEntry) {
        String fieldName = fieldEntry.getKey();
        FieldDescription field = fieldEntry.getValue();
        String getterName = StringTool.getGetterName((String)fieldName);
        String javaType = field.getTypeDescriptor();
        String format = new StringBuilder(64).append("()").append(javaType).toString();
        MethodVisitor methodVisitor = classWriter.visitMethod(1, getterName, format, null, null);
        String elementName = fieldName;
        elementName = elementName.length() == 1 ? elementName.toLowerCase() : (fieldName.length() > 1 && Character.isUpperCase(elementName.charAt(1)) ? StringUtils.capitalize((String)elementName) : StringUtils.uncapitalize((String)elementName));
        AnnotationVisitor av = methodVisitor.visitAnnotation("Ljavax/xml/bind/annotation/XmlElement;", true);
        av.visit("name", (Object)elementName);
        if (fieldEntry.getValue().hasDefaultValue()) {
            String defaultFieldValue = fieldEntry.getValue().getDefaultValueAsString();
            if (Boolean.class.getName().equals(fieldEntry.getValue().getTypeName()) || Boolean.TYPE.getName().equals(fieldEntry.getValue().getTypeName())) {
                defaultFieldValue = String.valueOf(fieldEntry.getValue().getDefaultValue());
            }
            if (fieldEntry.getValue().getTypeName().equals(Date.class.getName())) {
                Date date = (Date)fieldEntry.getValue().getDefaultValue();
                defaultFieldValue = ISO8601DateFormater.format(date);
            }
            if ("_DEFAULT_".equals(defaultFieldValue)) {
                av.visit("nillable", (Object)false);
            } else {
                av.visit("defaultValue", (Object)defaultFieldValue);
            }
        } else {
            av.visit("nillable", (Object)true);
        }
        av.visitEnd();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, this.getBeanNameWithPackage(), fieldName, javaType);
        String retClass = field.getTypeDescriptor();
        Type type = Type.getType((String)retClass);
        methodVisitor.visitInsn(type.getOpcode(172));
        methodVisitor.visitMaxs(0, 0);
    }
}

