/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.datatype.gen.bean.writers;

import java.util.Map;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.openl.rules.datatype.gen.FieldDescription;
import org.openl.rules.datatype.gen.bean.writers.MethodWriter;

public class HashCodeWriter
extends MethodWriter {
    public HashCodeWriter(String beanNameWithPackage, Map<String, FieldDescription> allFields) {
        super(beanNameWithPackage, allFields);
    }

    @Override
    public void write(ClassWriter classWriter) {
        MethodVisitor mv = classWriter.visitMethod(1, "hashCode", "()I", null, null);
        mv.visitInsn(8);
        for (Map.Entry<String, FieldDescription> field : this.getAllFields().entrySet()) {
            mv.visitIntInsn(16, 31);
            mv.visitInsn(104);
            mv.visitFrame(4, 0, null, 1, new Object[]{Opcodes.INTEGER});
            this.pushFieldToStack(mv, 0, field.getKey());
            String type = field.getValue().getTypeName();
            if ("double".equals(type)) {
                mv.visitMethodInsn(184, "java/lang/Double", "doubleToLongBits", "(D)J");
                this.hash64bits(mv);
            } else if ("long".equals(type)) {
                this.hash64bits(mv);
            } else if ("float".equals(type)) {
                mv.visitMethodInsn(184, "java/lang/Float", "floatToIntBits", "(F)I");
            } else if (!("int".equals(type) || "short".equals(type) || "byte".equals(type) || "char".equals(type))) {
                Label end;
                if ("boolean".equals(type)) {
                    Label zero = new Label();
                    mv.visitJumpInsn(153, zero);
                    mv.visitInsn(4);
                    end = new Label();
                    mv.visitJumpInsn(167, end);
                    mv.visitLabel(zero);
                    mv.visitFrame(4, 0, null, 1, new Object[]{Opcodes.INTEGER});
                    mv.visitInsn(3);
                    mv.visitLabel(end);
                } else if (type.charAt(0) == '[' && type.length() == 2) {
                    mv.visitMethodInsn(184, "java/util/Arrays", "hashCode", "(" + type + ")I");
                } else if (type.startsWith("[L")) {
                    mv.visitMethodInsn(184, "java/util/Arrays", "hashCode", "([Ljava/lang/Object;)I");
                } else if (type.startsWith("[[")) {
                    mv.visitMethodInsn(184, "java/util/Arrays", "deepHashCode", "([Ljava/lang/Object;)I");
                } else {
                    mv.visitInsn(89);
                    Label isNull = new Label();
                    mv.visitJumpInsn(198, isNull);
                    mv.visitMethodInsn(182, "java/lang/Object", "hashCode", "()I");
                    end = new Label();
                    mv.visitJumpInsn(167, end);
                    mv.visitLabel(isNull);
                    mv.visitFrame(0, 1, new Object[]{this.getBeanNameWithPackage()}, 2, new Object[]{Opcodes.INTEGER, type.replace('.', '/')});
                    mv.visitInsn(87);
                    mv.visitInsn(3);
                    mv.visitLabel(end);
                }
            }
            mv.visitFrame(0, 1, new Object[]{this.getBeanNameWithPackage()}, 2, new Object[]{Opcodes.INTEGER, Opcodes.INTEGER});
            mv.visitInsn(96);
        }
        mv.visitInsn(172);
        mv.visitMaxs(0, 0);
    }

    private void hash64bits(MethodVisitor mv) {
        mv.visitInsn(92);
        mv.visitIntInsn(16, 32);
        mv.visitInsn(125);
        mv.visitInsn(131);
        mv.visitInsn(136);
    }
}

