/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.datatype.gen.bean.writers;

import java.util.Map;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.openl.rules.datatype.gen.FieldDescription;
import org.openl.rules.datatype.gen.bean.writers.MethodWriter;
import org.openl.util.StringTool;

public class SettersWriter
extends MethodWriter {
    public SettersWriter(String beanNameWithPackage, Map<String, FieldDescription> allFields) {
        super(beanNameWithPackage, allFields);
    }

    @Override
    public void write(ClassWriter classWriter) {
        for (Map.Entry<String, FieldDescription> field : this.getAllFields().entrySet()) {
            if (!this.validField(field.getKey(), field.getValue())) continue;
            this.generateSetter(classWriter, field);
        }
    }

    protected void generateSetter(ClassWriter classWriter, Map.Entry<String, FieldDescription> fieldEntry) {
        String fieldName = fieldEntry.getKey();
        FieldDescription field = fieldEntry.getValue();
        MethodVisitor methodVisitor = this.writeMethodSignature(classWriter, field, fieldName);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(this.getConstantForVarInsn(field), 1);
        methodVisitor.visitFieldInsn(181, this.getBeanNameWithPackage(), fieldName, field.getTypeDescriptor());
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
    }

    protected MethodVisitor writeMethodSignature(ClassWriter classWriter, FieldDescription fieldType, String fieldName) {
        String setterName = StringTool.getSetterName((String)fieldName);
        String javaType = fieldType.getTypeDescriptor();
        String format = new StringBuilder(64).append('(').append(javaType).append(")V").toString();
        return classWriter.visitMethod(1, setterName, format, null, null);
    }
}

