/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.datatype.gen.bean.writers;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.openl.rules.datatype.gen.FieldDescription;
import org.openl.rules.datatype.gen.bean.writers.MethodWriter;

public class ToStringWriter
extends MethodWriter {
    private static Map<String, String> PRIMITIVE_DESCRIPTORS = new HashMap<String, String>(8, 1.0f){
        {
            this.put(Byte.TYPE, 'I');
            this.put(Short.TYPE, 'I');
            this.put(Integer.TYPE, 'I');
            this.put(Character.TYPE, 'C');
            this.put(Boolean.TYPE, 'Z');
            this.put(Long.TYPE, 'J');
            this.put(Float.TYPE, 'F');
            this.put(Double.TYPE, 'D');
        }

        @Override
        private void put(Class<?> clazz, char type) {
            this.put(clazz.getName(), "(" + type + ")Ljava/lang/StringBuilder;");
        }
    };
    private static Map<String, String> ARRAY_OF_PRIMITIVES_DESCRIPTORS = new HashMap<String, String>(8, 1.0f){
        {
            this.put(byte[].class);
            this.put(short[].class);
            this.put(int[].class);
            this.put(char[].class);
            this.put(boolean[].class);
            this.put(long[].class);
            this.put(float[].class);
            this.put(double[].class);
        }

        private void put(Class<?> clazz) {
            this.put(clazz.getName(), "(" + clazz.getName() + ")Ljava/lang/String;");
        }
    };

    public ToStringWriter(String beanNameWithPackage, Map<String, FieldDescription> allFields) {
        super(beanNameWithPackage, allFields);
    }

    @Override
    public void write(ClassWriter classWriter) {
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "toString", "()Ljava/lang/String;", null, null);
        methodVisitor.visitTypeInsn(187, "java/lang/StringBuilder");
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "()V");
        methodVisitor.visitVarInsn(25, 0);
        this.invokeAppendClassName(methodVisitor);
        this.invokeAppendValue(methodVisitor, "{ ");
        for (Map.Entry<String, FieldDescription> field : this.getAllFields().entrySet()) {
            this.invokeAppendValue(methodVisitor, field.getKey() + "=");
            this.pushFieldToStack(methodVisitor, 0, field.getKey());
            String type = field.getValue().getTypeName();
            if (PRIMITIVE_DESCRIPTORS.containsKey(type)) {
                this.invokeAppendPrimitive(methodVisitor, type);
            } else if (type.charAt(0) == '[') {
                if (ARRAY_OF_PRIMITIVES_DESCRIPTORS.containsKey(type)) {
                    this.invokeAppendArrayOfPrimitives(methodVisitor, type);
                } else {
                    this.invokeAppendArrayOfObjects(methodVisitor);
                }
            } else {
                this.invokeAppendObject(methodVisitor);
            }
            this.invokeAppendValue(methodVisitor, " ");
        }
        this.invokeAppendValue(methodVisitor, "}");
        this.invokeVirtual(methodVisitor, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;");
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(0, 0);
    }

    private void invokeAppendArrayOfObjects(MethodVisitor methodVisitor) {
        String desc = "([Ljava/lang/Object;)Ljava/lang/String;";
        methodVisitor.visitMethodInsn(184, "java/util/Arrays", "deepToString", desc);
        this.invokeAppendString(methodVisitor);
    }

    private void invokeAppendArrayOfPrimitives(MethodVisitor methodVisitor, String type) {
        String desc = ARRAY_OF_PRIMITIVES_DESCRIPTORS.get(type);
        methodVisitor.visitMethodInsn(184, "java/util/Arrays", "toString", desc);
        this.invokeAppendString(methodVisitor);
    }

    private void invokeAppendClassName(MethodVisitor methodVisitor) {
        this.invokeVirtual(methodVisitor, "java/lang/Object", "getClass", "()Ljava/lang/Class;");
        this.invokeVirtual(methodVisitor, "java/lang/Class", "getSimpleName", "()Ljava/lang/String;");
        this.invokeAppendString(methodVisitor);
    }

    private void invokeAppendValue(MethodVisitor methodVisitor, String str) {
        methodVisitor.visitLdcInsn((Object)str);
        this.invokeAppendString(methodVisitor);
    }

    private void invokeAppendObject(MethodVisitor methodVisitor) {
        String desc = "(Ljava/lang/Object;)Ljava/lang/StringBuilder;";
        this.invokeAppend(methodVisitor, desc);
    }

    private void invokeAppendPrimitive(MethodVisitor methodVisitor, String type) {
        String desc = PRIMITIVE_DESCRIPTORS.get(type);
        this.invokeAppend(methodVisitor, desc);
    }

    private void invokeAppendString(MethodVisitor methodVisitor) {
        this.invokeAppend(methodVisitor, "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
    }

    private void invokeAppend(MethodVisitor methodVisitor, String desc) {
        this.invokeVirtual(methodVisitor, "java/lang/StringBuilder", "append", desc);
    }

    private void invokeVirtual(MethodVisitor methodVisitor, String owner, String method, String desc) {
        methodVisitor.visitMethodInsn(182, owner, method, desc);
    }
}

