/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.openl.exception.OpenLRuntimeException;
import org.openl.rules.dt.IBaseAction;
import org.openl.types.IOpenClass;
import org.openl.types.Invokable;
import org.openl.vm.IRuntimeEnv;

public class ActionInvoker
implements Invokable {
    private final int[] rules;
    private final IBaseAction[] actions;

    ActionInvoker(int[] rules, IBaseAction[] actions) {
        this.rules = rules;
        this.actions = actions;
    }

    private Object addReturnValues(Collection<Object> returnValue, Object[] returnValues, boolean[] f) {
        for (int i = 0; i < returnValues.length; ++i) {
            if (!f[i]) continue;
            returnValue.add(returnValues[i]);
        }
        return returnValue;
    }

    private Object addReturnValues(Map<Object, Object> returnValue, Object[] returnValues, Object[] keyValues, boolean[] f) {
        for (int i = 0; i < returnValues.length; ++i) {
            if (!f[i]) continue;
            returnValue.put(keyValues[i], returnValues[i]);
        }
        return returnValue;
    }

    private Object processReturnValue(Object[] returnValues, Object[] keyValues, boolean[] f, IOpenClass type) {
        if (type.isArray()) {
            int c = 0;
            for (int i = 0; i < returnValues.length; ++i) {
                if (!f[i]) continue;
                ++c;
            }
            if (c == 0) {
                return returnValues;
            }
            Object[] ret = (Object[])Array.newInstance(type.getComponentClass().getInstanceClass(), c);
            int j = 0;
            for (int i = 0; i < returnValues.length; ++i) {
                if (!f[i]) continue;
                ret[j] = returnValues[i];
                ++j;
            }
            return ret;
        }
        if (Map.class.equals((Object)type.getInstanceClass())) {
            return this.addReturnValues(new HashMap<Object, Object>(), returnValues, keyValues, f);
        }
        if (SortedMap.class.equals((Object)type.getInstanceClass())) {
            return this.addReturnValues(new TreeMap<Object, Object>(), returnValues, keyValues, f);
        }
        if (Map.class.isAssignableFrom(type.getInstanceClass())) {
            try {
                return this.addReturnValues((Map)type.getInstanceClass().newInstance(), returnValues, keyValues, f);
            }
            catch (Exception e) {
                throw new OpenLRuntimeException((Throwable)e);
            }
        }
        if (Collection.class.equals((Object)type.getInstanceClass()) || List.class.equals((Object)type.getInstanceClass())) {
            return this.addReturnValues(new ArrayList<Object>(), returnValues, f);
        }
        if (Set.class.equals((Object)type.getInstanceClass())) {
            return this.addReturnValues(new HashSet<Object>(), returnValues, f);
        }
        if (SortedSet.class.equals((Object)type.getInstanceClass())) {
            return this.addReturnValues(new TreeSet<Object>(), returnValues, f);
        }
        if (Collection.class.isAssignableFrom(type.getInstanceClass())) {
            try {
                return this.addReturnValues((Collection)type.getInstanceClass().newInstance(), returnValues, f);
            }
            catch (Exception e) {
                throw new OpenLRuntimeException((Throwable)e);
            }
        }
        throw new OpenLRuntimeException();
    }

    public Object invoke(Object target, Object[] params, IRuntimeEnv env) {
        Object returnValue = null;
        Object[] keyValues = null;
        Object[] returnValues = null;
        boolean[] f = null;
        boolean isCollectReturn = false;
        IOpenClass type = null;
        for (IBaseAction action : this.actions) {
            Object actionResult;
            int i;
            if (action.isCollectReturnAction()) {
                if (returnValues == null) {
                    type = action.getType();
                    returnValues = type.isArray() ? (Object[])Array.newInstance(type.getComponentClass().getInstanceClass(), this.rules.length) : new Object[this.rules.length];
                    if (f == null) {
                        f = new boolean[this.rules.length];
                        Arrays.fill(f, false);
                    }
                }
                for (i = 0; i < this.rules.length; ++i) {
                    actionResult = action.executeAction(this.rules[i], target, params, env);
                    if (returnValues[i] != null || actionResult == null) continue;
                    returnValues[i] = actionResult;
                    f[i] = true;
                }
                returnValue = returnValues;
                isCollectReturn = true;
                continue;
            }
            if (action.isCollectReturnKeyAction()) {
                if (keyValues == null) {
                    keyValues = new Object[this.rules.length];
                    if (f == null) {
                        f = new boolean[this.rules.length];
                        Arrays.fill(f, false);
                    }
                }
                for (i = 0; i < this.rules.length; ++i) {
                    actionResult = action.executeAction(this.rules[i], target, params, env);
                    if (keyValues[i] != null || actionResult == null) continue;
                    keyValues[i] = actionResult;
                    f[i] = true;
                }
                continue;
            }
            i = 0;
            actionResult = null;
            for (i = 0; i < this.rules.length; ++i) {
                if (action.isReturnAction()) {
                    actionResult = action.executeAction(this.rules[i], target, params, env);
                    if (actionResult == null) continue;
                    break;
                }
                action.executeAction(this.rules[i], target, params, env);
            }
            if (returnValue != null || actionResult == null && i >= this.rules.length) continue;
            returnValue = actionResult;
            isCollectReturn = false;
        }
        if (isCollectReturn) {
            return this.processReturnValue((Object[])returnValue, keyValues, f, type);
        }
        return returnValue;
    }

    public int[] getRules() {
        return this.rules;
    }
}

