/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openl.binding.IBindingContext;
import org.openl.binding.impl.NodeType;
import org.openl.binding.impl.SimpleNodeUsage;
import org.openl.exception.OpenLCompilationException;
import org.openl.rules.dt.DecisionTable;
import org.openl.rules.dt.DecisionTableColumnHeaders;
import org.openl.rules.fuzzy.OpenLFuzzySearch;
import org.openl.rules.fuzzy.Token;
import org.openl.rules.helpers.DoubleRange;
import org.openl.rules.helpers.IntRange;
import org.openl.rules.lang.xls.XlsSheetSourceCodeModule;
import org.openl.rules.lang.xls.XlsWorkbookSourceCodeModule;
import org.openl.rules.lang.xls.load.SimpleSheetLoader;
import org.openl.rules.lang.xls.load.SimpleWorkbookLoader;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.types.CellMetaInfo;
import org.openl.rules.table.CompositeGrid;
import org.openl.rules.table.GridRegion;
import org.openl.rules.table.GridTable;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.IWritableGrid;
import org.openl.rules.table.LogicalTableHelper;
import org.openl.rules.table.xls.XlsSheetGridModel;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.StringSourceCodeModule;
import org.openl.syntax.impl.Tokenizer;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;
import org.openl.types.impl.DomainOpenClass;
import org.openl.types.java.JavaOpenClass;

public class DecisionTableHelper {
    private static final Pattern RANGE_PATTERN = Pattern.compile(".*(more|less|[;<>\\[(+]).*|.*\\d+.*(-|\\.\\.).*");
    private static final String RET1_COLUMN_NAME = DecisionTableColumnHeaders.RETURN.getHeaderKey() + "1";
    private static final String CRET1_COLUMN_NAME = DecisionTableColumnHeaders.COLLECT_RETURN.getHeaderKey() + "1";
    private static final String KEY1_COLUMN_NAME = DecisionTableColumnHeaders.KEY.getHeaderKey() + "1";

    public static boolean looksLikeVertical(ILogicalTable table) {
        int cnt2;
        if (table.getWidth() <= 4) {
            return true;
        }
        if (table.getHeight() <= 4) {
            return false;
        }
        int cnt1 = DecisionTableHelper.countConditionsAndActions(table);
        if (cnt1 != (cnt2 = DecisionTableHelper.countConditionsAndActions((ILogicalTable)table.transpose()))) {
            return cnt1 > cnt2;
        }
        return table.getWidth() <= 4;
    }

    public static boolean isValidConditionHeader(String s) {
        return s.length() >= 2 && s.charAt(0) == DecisionTableColumnHeaders.CONDITION.getHeaderKey().charAt(0) && Character.isDigit(s.charAt(1));
    }

    public static boolean isValidHConditionHeader(String headerStr) {
        return headerStr.startsWith(DecisionTableColumnHeaders.HORIZONTAL_CONDITION.getHeaderKey()) && headerStr.length() > 2 && Character.isDigit(headerStr.charAt(2));
    }

    public static boolean isValidMergedConditionHeader(String headerStr) {
        return headerStr.startsWith(DecisionTableColumnHeaders.MERGED_CONDITION.getHeaderKey()) && headerStr.length() > 2 && Character.isDigit(headerStr.charAt(2));
    }

    public static boolean isValidActionHeader(String s) {
        return s.length() >= 2 && s.charAt(0) == DecisionTableColumnHeaders.ACTION.getHeaderKey().charAt(0) && Character.isDigit(s.charAt(1));
    }

    public static boolean isValidRetHeader(String s) {
        return s.length() >= 3 && s.startsWith(DecisionTableColumnHeaders.RETURN.getHeaderKey()) && (s.length() == 3 || Character.isDigit(s.charAt(3)));
    }

    public static boolean isValidKeyHeader(String s) {
        return s.length() >= 3 && s.startsWith(DecisionTableColumnHeaders.KEY.getHeaderKey()) && (s.length() == 3 || Character.isDigit(s.charAt(3)));
    }

    public static boolean isValidCRetHeader(String s) {
        return s.length() >= 4 && s.startsWith(DecisionTableColumnHeaders.COLLECT_RETURN.getHeaderKey()) && (s.length() == 4 || Character.isDigit(s.charAt(4)));
    }

    public static boolean isValidRuleHeader(String s) {
        return s.equals(DecisionTableColumnHeaders.RULE.getHeaderKey());
    }

    public static boolean isActionHeader(String s) {
        return DecisionTableHelper.isValidActionHeader(s) || DecisionTableHelper.isValidRetHeader(s) || DecisionTableHelper.isValidCRetHeader(s) || DecisionTableHelper.isValidKeyHeader(s);
    }

    public static boolean isConditionHeader(String s) {
        return DecisionTableHelper.isValidConditionHeader(s) || DecisionTableHelper.isValidHConditionHeader(s) || DecisionTableHelper.isValidMergedConditionHeader(s);
    }

    public static int countConditionsAndActions(ILogicalTable table) {
        int width = table.getWidth();
        int count = 0;
        for (int i = 0; i < width; ++i) {
            String value = ((ILogicalTable)table.getColumn(i)).getSource().getCell(0, 0).getStringValue();
            if (value == null) continue;
            count += DecisionTableHelper.isValidConditionHeader(value = value.toUpperCase()) || DecisionTableHelper.isActionHeader(value) ? 1 : 0;
        }
        return count;
    }

    public static boolean hasHConditions(ILogicalTable table) {
        return DecisionTableHelper.countHConditions(table) > 0;
    }

    public static ILogicalTable preprocessSimpleDecisionTable(TableSyntaxNode tableSyntaxNode, DecisionTable decisionTable, ILogicalTable originalTable, int numberOfHcondition, int numberOfMergedRows, boolean isSmartDecisionTable, boolean isCollectTable, IBindingContext bindingContext) throws OpenLCompilationException {
        XlsSheetGridModel virtualGrid = DecisionTableHelper.createVirtualGrid();
        DecisionTableHelper.writeVirtualHeadersForSimpleDecisionTable(tableSyntaxNode, virtualGrid, originalTable, decisionTable, numberOfHcondition, numberOfMergedRows, isSmartDecisionTable, isCollectTable, bindingContext);
        int sizeOfVirtualGridTable = virtualGrid.getMaxColumnIndex(0) < originalTable.getSource().getWidth() ? originalTable.getSource().getWidth() - 1 : virtualGrid.getMaxColumnIndex(0) - 1;
        GridTable virtualGridTable = new GridTable(0, 0, 2, sizeOfVirtualGridTable, virtualGrid);
        CompositeGrid grid = new CompositeGrid(new IGridTable[]{virtualGridTable, originalTable.getSource()}, true);
        int sizeofGrid = virtualGridTable.getWidth() < originalTable.getSource().getWidth() ? originalTable.getSource().getWidth() - 1 : virtualGridTable.getWidth() - 1;
        return LogicalTableHelper.logicalTable(new GridTable(0, 0, originalTable.getSource().getHeight() + 3 - 1, sizeofGrid, grid));
    }

    private static void writeVirtualHeadersForSimpleDecisionTable(TableSyntaxNode tableSyntaxNode, IWritableGrid grid, ILogicalTable originalTable, DecisionTable decisionTable, int numberOfHcondition, int numberOfMergedRows, boolean isSmartDecisionTable, boolean isCollectTable, IBindingContext bindingContext) throws OpenLCompilationException {
        Pair<Condition[], Integer> c = DecisionTableHelper.writeConditions(grid, originalTable, decisionTable, numberOfHcondition, isSmartDecisionTable, isCollectTable, bindingContext);
        DecisionTableHelper.writeReturn(tableSyntaxNode, grid, originalTable, decisionTable, (Integer)c.getRight(), (Condition[])c.getLeft(), numberOfMergedRows, numberOfHcondition > 0, isSmartDecisionTable, isCollectTable, bindingContext);
    }

    private static boolean isCompoundReturnType(ILogicalTable originalTable, DecisionTable decisionTable, int firstReturnColumn, boolean isCollectTable) {
        int c = firstReturnColumn;
        int compoundTypeParameterCount = 0;
        while (c < originalTable.getSource().getWidth() && originalTable.getSource().getCell(c, 0).getStringValue() != null && !originalTable.getSource().getCell(c, 0).getStringValue().trim().isEmpty()) {
            c += originalTable.getSource().getCell(c, 0).getWidth();
            ++compoundTypeParameterCount;
        }
        IOpenClass returnType = decisionTable.getType();
        if (isCollectTable) {
            return compoundTypeParameterCount > 1;
        }
        return compoundTypeParameterCount > 1 && !returnType.isArray();
    }

    private static void validateCompoundReturnType(IOpenClass compoundType) throws OpenLCompilationException {
        try {
            compoundType.getInstanceClass().getConstructor(new Class[0]);
        }
        catch (Exception e) {
            throw new OpenLCompilationException(String.format("Invalid compound return type: There is no default constructor in return type '%s'", compoundType.getDisplayName(0)));
        }
    }

    private static void writeCompoundReturnColumns(TableSyntaxNode tableSyntaxNode, IWritableGrid grid, ILogicalTable originalTable, DecisionTable decisionTable, int firstReturnColumn, int numberOfMergedRows, Condition[] conditions, boolean isSmartDecisionTable, boolean isCollectTable, int retParameterIndex, IBindingContext bindingContext) throws OpenLCompilationException {
        int numberOfConditions = conditions.length;
        int compoundReturnColumnsCount = DecisionTableHelper.calculateCompoundReturnColumnsCount(originalTable, numberOfConditions, numberOfMergedRows);
        IOpenClass compoundType = isCollectTable ? (tableSyntaxNode.getHeader().getCollectParameters().length > 0 ? bindingContext.findType("org.openl.this", tableSyntaxNode.getHeader().getCollectParameters()[retParameterIndex]) : (decisionTable.getType().isArray() ? decisionTable.getType().getComponentClass() : decisionTable.getType())) : decisionTable.getType();
        DecisionTableHelper.validateCompoundReturnType(compoundType);
        StringBuilder sb = new StringBuilder();
        sb.append(compoundType.getName() + " ret = new " + compoundType.getName() + "();");
        if (isSmartDecisionTable) {
            for (int i = 0; i < numberOfConditions; ++i) {
                String descriptionOfCondition = conditions[i].getDescription();
                try {
                    IOpenMethod bestMatchConditionMethod = DecisionTableHelper.findBestMatchOpenMethod(descriptionOfCondition, compoundType, true);
                    sb.append("ret.");
                    sb.append(bestMatchConditionMethod.getName());
                    sb.append("(");
                    sb.append(String.valueOf(decisionTable.getSignature().getParameterName(conditions[i].getParameterIndex())));
                    sb.append(");");
                    continue;
                }
                catch (OpenLCompilationException bestMatchConditionMethod) {
                    // empty catch block
                }
            }
        }
        HashSet<String> generatedNames = new HashSet<String>();
        while (generatedNames.size() < compoundReturnColumnsCount) {
            generatedNames.add(RandomStringUtils.random((int)8, (boolean)true, (boolean)false));
        }
        String[] compoundColumnParamNames = generatedNames.toArray(new String[0]);
        int column = firstReturnColumn;
        HashMap variables = new HashMap();
        for (int i = 0; i < compoundReturnColumnsCount; ++i) {
            StringBuilder fieldChainSb = null;
            IOpenClass type = compoundType;
            int h = 0;
            String currentVariable = "ret";
            int previoush = h;
            while (h < numberOfMergedRows) {
                IOpenMethod bestMatchMethod;
                String description = originalTable.getSource().getCell(column, h).getStringValue();
                previoush = h;
                h += originalTable.getSource().getCell(column, h).getHeight();
                IOpenMethod[] m = null;
                if (h < numberOfMergedRows && (bestMatchMethod = DecisionTableHelper.findBestMatchOpenMethod(description, type, false)) != null) {
                    m = new IOpenMethod[]{bestMatchMethod};
                }
                if (m == null) {
                    m = DecisionTableHelper.findBestMatchOpenMethodRecursively(description, type);
                }
                if (!bindingContext.isExecutionMode()) {
                    if (fieldChainSb == null) {
                        fieldChainSb = new StringBuilder();
                    } else {
                        fieldChainSb.append(".");
                    }
                    IOpenClass t = type;
                    for (int j = 0; j < m.length; ++j) {
                        IOpenField openField = t.getField(m[j].getName().substring(3), false);
                        fieldChainSb.append(openField.getDisplayName(0));
                        if (j < m.length - 1) {
                            fieldChainSb.append(".");
                        }
                        t = m[j].getSignature().getParameterType(0);
                    }
                }
                for (int j = 0; j < m.length; ++j) {
                    String var = null;
                    type = m[j].getSignature().getParameterType(0);
                    if (h < numberOfMergedRows || j < m.length - 1) {
                        HashMap<IOpenMethod, String> vm = (HashMap<IOpenMethod, String>)variables.get(currentVariable);
                        if (vm == null || vm.get(m[j]) == null) {
                            var = RandomStringUtils.random((int)8, (boolean)true, (boolean)false);
                            while (generatedNames.contains(var)) {
                                var = RandomStringUtils.random((int)8, (boolean)true, (boolean)false);
                            }
                            generatedNames.add(var);
                            sb.append(type.getName() + " " + var + " = new " + type.getName() + "();");
                            vm = new HashMap<IOpenMethod, String>();
                            vm.put(m[j], var);
                            variables.put(currentVariable, vm);
                        } else {
                            var = (String)vm.get(m[j]);
                        }
                    }
                    sb.append(currentVariable + ".");
                    sb.append(m[j].getName());
                    sb.append("(");
                    if (h < numberOfMergedRows || j < m.length - 1) {
                        sb.append(var);
                        currentVariable = var;
                    } else {
                        sb.append(compoundColumnParamNames[i]);
                    }
                    sb.append(");");
                }
            }
            grid.setCellValue(column, 2, type.getName() + " " + compoundColumnParamNames[i]);
            int mergedColumnsCounts = originalTable.getSource().getCell(column, numberOfMergedRows).getWidth();
            if (mergedColumnsCounts > 1) {
                grid.addMergedRegion(new GridRegion(2, column, 2, column + mergedColumnsCounts - 1));
            }
            if (!bindingContext.isExecutionMode()) {
                String stringValue = originalTable.getSource().getCell(column, numberOfMergedRows - 1).getStringValue();
                String description = "Return: " + type.getDisplayName(0) + " " + fieldChainSb.toString();
                ICell cell = originalTable.getSource().getCell(column, previoush);
                SimpleNodeUsage simpleNodeUsage = new SimpleNodeUsage(0, stringValue.length() - 1, description, null, NodeType.OTHER);
                CellMetaInfo meta = new CellMetaInfo(CellMetaInfo.Type.DT_CA_CODE, null, (IOpenClass)JavaOpenClass.STRING, false, Collections.singletonList(simpleNodeUsage));
                cell.setMetaInfo(meta);
            }
            column += mergedColumnsCounts;
        }
        sb.append("ret;");
        grid.setCellValue(firstReturnColumn, 1, sb.toString());
        for (int row = 0; row < 2; ++row) {
            grid.addMergedRegion(new GridRegion(row, firstReturnColumn, row, column - 1));
        }
    }

    private static int calculateCompoundReturnColumnsCount(ILogicalTable originalTable, int numberOfConditions, int numberOfMergedRows) {
        return ((ILogicalTable)originalTable.getRow(numberOfMergedRows)).getWidth() - numberOfConditions;
    }

    private static IOpenMethod findBestMatchOpenMethod(String description, IOpenClass openClass, boolean validateEmptyResult) throws OpenLCompilationException {
        Map<Token, IOpenMethod[]> openClassFuzzyTokens = OpenLFuzzySearch.tokensMapToOpenClassSetterMethods(openClass);
        String tokenizedDescriptionString = OpenLFuzzySearch.toTokenString(description);
        Token[] fuzzyBestMatches = OpenLFuzzySearch.openlFuzzyExtract(tokenizedDescriptionString, openClassFuzzyTokens.keySet().toArray(new Token[0]));
        if (fuzzyBestMatches.length == 0) {
            if (validateEmptyResult) {
                throw new OpenLCompilationException(String.format("Change title: No field match in the return type for the title '%s'.", description));
            }
            return null;
        }
        if (fuzzyBestMatches.length > 1) {
            throw new OpenLCompilationException(String.format("Change title: More than one field match in the return type for the title '%s'.", description));
        }
        if (openClassFuzzyTokens.get(fuzzyBestMatches[0]) == null || openClassFuzzyTokens.get(fuzzyBestMatches[0]).length == 0) {
            if (validateEmptyResult) {
                throw new OpenLCompilationException(String.format("Change title: No field match in the return type for the title '%s'.", description));
            }
            return null;
        }
        if (openClassFuzzyTokens.get(fuzzyBestMatches[0]).length > 1) {
            throw new OpenLCompilationException(String.format("Change title: More than one field match in the return type for the title '%s'.", description));
        }
        return openClassFuzzyTokens.get(fuzzyBestMatches[0])[0];
    }

    private static IOpenMethod[] findBestMatchOpenMethodRecursively(String description, IOpenClass openClass) throws OpenLCompilationException {
        Map<Token, IOpenMethod[][]> openClassFuzzyTokens = OpenLFuzzySearch.tokensMapToOpenClassSetterMethodsRecursively(openClass);
        String tokenizedDescriptionString = OpenLFuzzySearch.toTokenString(description);
        Token[] fuzzyBestMatches = OpenLFuzzySearch.openlFuzzyExtract(tokenizedDescriptionString, openClassFuzzyTokens.keySet().toArray(new Token[0]));
        if (fuzzyBestMatches.length == 0) {
            throw new OpenLCompilationException(String.format("Change title: No field match in the return type for the title '%s'.", description));
        }
        if (fuzzyBestMatches.length > 1) {
            throw new OpenLCompilationException(String.format("Change title: More than one field match in the return type for the title '%s'.", description));
        }
        if (openClassFuzzyTokens.get(fuzzyBestMatches[0]) == null || openClassFuzzyTokens.get(fuzzyBestMatches[0]).length == 0) {
            throw new OpenLCompilationException(String.format("Change title: No field match in the return type for the title '%s'.", description));
        }
        if (openClassFuzzyTokens.get(fuzzyBestMatches[0]).length > 1) {
            throw new OpenLCompilationException(String.format("Change title: More than one field match in the return type for the title '%s'.", description));
        }
        return openClassFuzzyTokens.get(fuzzyBestMatches[0])[0];
    }

    private static void validateCollectSyntaxNode(TableSyntaxNode tableSyntaxNode, DecisionTable decisionTable, ILogicalTable originalTable, IBindingContext bindingContext) throws OpenLCompilationException {
        int parametersCount = tableSyntaxNode.getHeader().getCollectParameters().length;
        IOpenClass type = decisionTable.getType();
        if ((type.isArray() || Collection.class.isAssignableFrom(type.getInstanceClass())) && parametersCount > 1) {
            throw new OpenLCompilationException(String.format("Error: Cannot bind node: '%s'. Found more than one parameter for '%s'.", Tokenizer.firstToken((IOpenSourceCodeModule)tableSyntaxNode.getHeader().getModule(), (String)"").getIdentifier(), type.getComponentClass().getDisplayName(0)));
        }
        if (Map.class.isAssignableFrom(type.getInstanceClass())) {
            if (parametersCount > 2) {
                throw new OpenLCompilationException(String.format("Error: Cannot bind node: '%s'. Found more than two parameter for '%s'.", Tokenizer.firstToken((IOpenSourceCodeModule)tableSyntaxNode.getHeader().getModule(), (String)"").getIdentifier(), type.getDisplayName(0)));
            }
            if (parametersCount == 1) {
                throw new OpenLCompilationException(String.format("Error: Cannot bind node: '%s'. Found only one parameter for '%s'.", Tokenizer.firstToken((IOpenSourceCodeModule)tableSyntaxNode.getHeader().getModule(), (String)"").getIdentifier(), type.getDisplayName(0)));
            }
        }
        for (String parameterType : tableSyntaxNode.getHeader().getCollectParameters()) {
            IOpenClass t = bindingContext.findType("org.openl.this", parameterType);
            if (t == null) {
                throw new OpenLCompilationException(String.format("Error: Cannot bind node: '%s'. Cannot find type: '%s'.", Tokenizer.firstToken((IOpenSourceCodeModule)tableSyntaxNode.getHeader().getModule(), (String)"").getIdentifier(), parameterType));
            }
            if (!type.isArray() || bindingContext.getCast(t, type.getComponentClass()) != null) continue;
            throw new OpenLCompilationException(String.format("Error: Cannot bind node: '%s'. Incompatible types: '%s' and '%s'.", Tokenizer.firstToken((IOpenSourceCodeModule)tableSyntaxNode.getHeader().getModule(), (String)"").getIdentifier(), type.getComponentClass().getDisplayName(0), t.getDisplayName(0)));
        }
    }

    private static void writeReturn(TableSyntaxNode tableSyntaxNode, IWritableGrid grid, ILogicalTable originalTable, DecisionTable decisionTable, int firstColumnAfterConditionColumns, Condition[] conditions, int numberOfMergedRows, boolean isLookupTable, boolean isSmartDecisionTable, boolean isCollectTable, IBindingContext bindingContext) throws OpenLCompilationException {
        int firstReturnColumn = firstColumnAfterConditionColumns;
        int retParameterIndex = 0;
        if (isCollectTable) {
            DecisionTableHelper.validateCollectSyntaxNode(tableSyntaxNode, decisionTable, originalTable, bindingContext);
            if (Map.class.isAssignableFrom(decisionTable.getType().getInstanceClass())) {
                grid.setCellValue(firstReturnColumn, 0, KEY1_COLUMN_NAME);
                if (tableSyntaxNode.getHeader().getCollectParameters().length > 0) {
                    grid.setCellValue(firstReturnColumn, 1, "keyRet");
                    grid.setCellValue(firstReturnColumn, 2, tableSyntaxNode.getHeader().getCollectParameters()[retParameterIndex] + " " + "keyRet");
                    ++retParameterIndex;
                }
                int mergedColumnsCounts = originalTable.getSource().getCell(firstReturnColumn, numberOfMergedRows).getWidth();
                firstReturnColumn += mergedColumnsCounts;
            }
            grid.setCellValue(firstReturnColumn, 0, CRET1_COLUMN_NAME);
            if (tableSyntaxNode.getHeader().getCollectParameters().length > 0) {
                grid.setCellValue(firstReturnColumn, 1, "extraRet");
                grid.setCellValue(firstReturnColumn, 2, tableSyntaxNode.getHeader().getCollectParameters()[retParameterIndex] + " " + "extraRet");
            } else if (decisionTable.getType().isArray()) {
                IOpenClass componentOpenClass;
                grid.setCellValue(firstReturnColumn, 1, "extraRet");
                String componentClassName = decisionTable.getType().getComponentClass().getName();
                if (decisionTable.getType().getAggregateInfo() != null && (componentOpenClass = decisionTable.getType().getAggregateInfo().getComponentType(decisionTable.getType())) != null) {
                    componentClassName = componentOpenClass.getName();
                }
                grid.setCellValue(firstReturnColumn, 2, componentClassName + " " + "extraRet");
            }
        } else {
            grid.setCellValue(firstReturnColumn, 0, RET1_COLUMN_NAME);
        }
        if (!isLookupTable) {
            if (originalTable.getWidth() > conditions.length) {
                boolean isCompoundReturnType = DecisionTableHelper.isCompoundReturnType(originalTable, decisionTable, firstReturnColumn, isCollectTable);
                if (isCompoundReturnType) {
                    DecisionTableHelper.writeCompoundReturnColumns(tableSyntaxNode, grid, originalTable, decisionTable, firstReturnColumn, numberOfMergedRows, conditions, isSmartDecisionTable, isCollectTable, retParameterIndex, bindingContext);
                } else {
                    int mergedColumnsCounts = originalTable.getColumnWidth(conditions.length);
                    if (mergedColumnsCounts > 1) {
                        for (int row = 0; row < 3; ++row) {
                            grid.addMergedRegion(new GridRegion(row, firstReturnColumn, row, firstReturnColumn + mergedColumnsCounts - 1));
                        }
                    }
                }
            } else {
                throw new OpenLCompilationException("Wrong table structure: There is no column for return values");
            }
        }
    }

    private static Pair<Condition[], Integer> writeConditions(IWritableGrid grid, ILogicalTable originalTable, DecisionTable decisionTable, int numberOfHcondition, boolean isSmartDecisionTable, boolean isCollectTable, IBindingContext bindingContext) throws OpenLCompilationException {
        int numberOfConditions;
        Condition[] conditions;
        if (isSmartDecisionTable) {
            conditions = DecisionTableHelper.findConditionsForParameters(originalTable, decisionTable, numberOfHcondition, isCollectTable);
            numberOfConditions = conditions.length;
        } else {
            numberOfConditions = DecisionTableHelper.getNumberOfConditions(decisionTable);
            conditions = new Condition[numberOfConditions];
            for (int i = 0; i < numberOfConditions; ++i) {
                conditions[i] = new Condition(i);
            }
        }
        int column = 0;
        int vColumnCounter = 0;
        int hColumn = -1;
        for (int i = 0; i < numberOfConditions; ++i) {
            boolean lastCondition;
            if (column >= originalTable.getSource().getWidth()) {
                String message = "Wrong table structure: Columns count is less than parameters count";
                throw new OpenLCompilationException(message);
            }
            boolean isThatVCondition = i < numberOfConditions - numberOfHcondition;
            boolean bl = lastCondition = i + 1 == numberOfConditions;
            if (isThatVCondition) {
                ++vColumnCounter;
                if (i == 0 && numberOfHcondition == 0 && numberOfConditions < 2) {
                    grid.setCellValue(column, 0, (DecisionTableColumnHeaders.MERGED_CONDITION.getHeaderKey() + (i + 1)).intern());
                } else {
                    grid.setCellValue(column, 0, (DecisionTableColumnHeaders.CONDITION.getHeaderKey() + (i + 1)).intern());
                }
            } else {
                if (hColumn < 0) {
                    hColumn = column;
                }
                grid.setCellValue(column, 0, (DecisionTableColumnHeaders.HORIZONTAL_CONDITION.getHeaderKey() + (i + 1)).intern());
            }
            grid.setCellValue(column, 1, decisionTable.getSignature().getParameterName(conditions[i].getParameterIndex()));
            Pair<String, String> typeOfValue = DecisionTableHelper.checkTypeOfValues(originalTable, i, decisionTable.getSignature().getParameterTypes()[conditions[i].getParameterIndex()], isThatVCondition, lastCondition, vColumnCounter);
            grid.setCellValue(column, 2, typeOfValue.getLeft());
            if (!bindingContext.isExecutionMode()) {
                DecisionTableHelper.writeMetaInfoForCondition(originalTable, column, decisionTable.getSignature().getParameterName(conditions[i].getParameterIndex()), (String)typeOfValue.getRight());
            }
            if (isThatVCondition || lastCondition) {
                int mergedColumnsCounts;
                int n = mergedColumnsCounts = isThatVCondition ? originalTable.getColumnWidth(i) : originalTable.getSource().getCell(vColumnCounter, i - vColumnCounter).getWidth();
                if (mergedColumnsCounts > 1) {
                    for (int row = 0; row < 3; ++row) {
                        grid.addMergedRegion(new GridRegion(row, column, row, column + mergedColumnsCounts - 1));
                    }
                }
                column += mergedColumnsCounts;
                continue;
            }
            ++column;
        }
        if (!bindingContext.isExecutionMode()) {
            DecisionTableHelper.writeMetaInfoForHConditions(originalTable, decisionTable, conditions, numberOfHcondition, numberOfConditions, hColumn);
        }
        return new ImmutablePair((Object)conditions, (Object)column);
    }

    private static void writeMetaInfoForHConditions(ILogicalTable originalTable, DecisionTable decisionTable, Condition[] conditions, int numberOfHcondition, int numberOfConditions, int hColumn) {
        int j = 0;
        for (int i = numberOfConditions - numberOfHcondition; i < numberOfConditions; ++i) {
            for (int c = hColumn; c <= originalTable.getSource().getWidth(); c += originalTable.getSource().getCell(c, j).getWidth()) {
                String cellValue = originalTable.getSource().getCell(c, j).getFormattedValue();
                String text = String.format("Condition for %s: %s", decisionTable.getSignature().getParameterName(conditions[i].getParameterIndex()), decisionTable.getSignature().getParameterType(i).getDisplayName(0));
                ICell cell = originalTable.getSource().getCell(c, j);
                SimpleNodeUsage simpleNodeUsage = new SimpleNodeUsage(0, cellValue.length() - 1, text, null, NodeType.OTHER);
                CellMetaInfo meta = new CellMetaInfo(CellMetaInfo.Type.DT_CA_CODE, null, (IOpenClass)JavaOpenClass.STRING, false, Collections.singletonList(simpleNodeUsage));
                cell.setMetaInfo(meta);
            }
            ++j;
        }
    }

    private static void writeMetaInfoForCondition(ILogicalTable originalTable, int column, String parameterName, String typeOfValue) {
        String cellValue = originalTable.getSource().getCell(column, 0).getFormattedValue();
        String text = String.format("Condition for %s: %s", parameterName, typeOfValue);
        ICell cell = originalTable.getSource().getCell(column, 0);
        SimpleNodeUsage simpleNodeUsage = new SimpleNodeUsage(0, cellValue.length() - 1, text, null, NodeType.OTHER);
        CellMetaInfo meta = new CellMetaInfo(CellMetaInfo.Type.DT_CA_CODE, null, (IOpenClass)JavaOpenClass.STRING, false, Collections.singletonList(simpleNodeUsage));
        cell.setMetaInfo(meta);
    }

    /*
     * WARNING - void declaration
     */
    private static Condition[] findConditionsForParameters(ILogicalTable originalTable, DecisionTable decisionTable, int numberOfHcondition, boolean isCollectTable) throws OpenLCompilationException {
        int numberOfParameters = decisionTable.getSignature().getNumberOfParameters();
        int column = 0;
        ArrayList<List<Object>> vConditions = new ArrayList<List<Object>>();
        DualHashBidiMap parameterTokensMap = new DualHashBidiMap();
        Token[] parameterTokens = new Token[numberOfParameters - numberOfHcondition];
        for (int i = 0; i < numberOfParameters - numberOfHcondition; ++i) {
            String tokenString = OpenLFuzzySearch.toTokenString(decisionTable.getSignature().getParameterName(i));
            parameterTokensMap.put((Object)tokenString, (Object)i);
            parameterTokens[i] = new Token(tokenString, 0);
        }
        int firstColumnHeight = originalTable.getCell(0, 0).getHeight();
        for (int j = 0; j < numberOfParameters - numberOfHcondition && originalTable.getCell(column, 0).getHeight() == firstColumnHeight; ++j) {
            String tokenizedDescriptionString;
            Token[] bestMatchedTokens;
            String description = originalTable.getCell(column, 0).getStringValue();
            if ((column += originalTable.getColumnWidth(column)) >= originalTable.getWidth() || isCollectTable && Map.class.isAssignableFrom(decisionTable.getType().getInstanceClass()) && column + originalTable.getColumnWidth(column) >= originalTable.getWidth() || (bestMatchedTokens = OpenLFuzzySearch.openlFuzzyExtract(tokenizedDescriptionString = OpenLFuzzySearch.toTokenString(description), parameterTokens)).length == 0) break;
            if (bestMatchedTokens.length > 1) {
                void var17_27;
                ArrayList<Condition> arrayList = new ArrayList<Condition>();
                Token[] tokenArray = bestMatchedTokens;
                int n = tokenArray.length;
                boolean bl = false;
                while (var17_27 < n) {
                    Token token = tokenArray[var17_27];
                    arrayList.add(new Condition((Integer)parameterTokensMap.get((Object)token.getValue()), description));
                    ++var17_27;
                }
                vConditions.add(arrayList);
                continue;
            }
            Condition condition = new Condition((Integer)parameterTokensMap.get((Object)bestMatchedTokens[0].getValue()), description);
            boolean alreadyExists = false;
            for (List list : vConditions) {
                if (list.size() != 1 || ((Condition)list.get(0)).getParameterIndex() != condition.getParameterIndex()) continue;
                alreadyExists = true;
                break;
            }
            if (alreadyExists) break;
            for (List list : vConditions) {
                if (list.size() <= 1) continue;
                list.remove(condition);
                if (list.size() != 1) continue;
                Integer index = ((Condition)list.get(0)).getParameterIndex();
                parameterTokensMap.removeValue((Object)index);
            }
            vConditions.add(Collections.singletonList(condition));
        }
        Condition[] conditions = new Condition[vConditions.size() + numberOfHcondition];
        int v = 0;
        for (List list : vConditions) {
            if (list.size() > 1) {
                throw new OpenLCompilationException(String.format("Change title: More than one input parameter match the title '%s'.", ((Condition)list.get(0)).getDescription()));
            }
            conditions[v] = (Condition)list.get(0);
            ++v;
        }
        for (int i = numberOfParameters - numberOfHcondition; i < numberOfParameters; ++i) {
            conditions[vConditions.size() + i - (numberOfParameters - numberOfHcondition)] = new Condition(i);
        }
        return conditions;
    }

    private static Pair<String, String> checkTypeOfValues(ILogicalTable originalTable, int column, IOpenClass type, boolean isThatVCondition, boolean lastCondition, int vColumnCounter) {
        int width;
        ILogicalTable decisionValues;
        List<String> intType = Arrays.asList("byte", "short", "int", "java.lang.Byte", "org.openl.meta.ByteValue", "org.openl.meta.ShortValue", "org.openl.meta.IntValue", "org.openl.meta.BigIntegerValue", "java.lang.Integer", "org.openl.meta.IntegerValue");
        List<String> doubleType = Arrays.asList("long", "float", "double", "java.lang.Long", "java.lang.Float", "java.lang.Double", "org.openl.meta.LongValue", "org.openl.meta.FloatValue", "org.openl.meta.DoubleValue", "org.openl.meta.BigDecimalValue");
        if (isThatVCondition) {
            decisionValues = (ILogicalTable)originalTable.getColumn(column);
            width = decisionValues.getHeight();
        } else {
            int numOfHRow = column - vColumnCounter;
            decisionValues = LogicalTableHelper.logicalTable((IGridTable)originalTable.getSource().getRow(numOfHRow));
            width = decisionValues.getWidth();
        }
        if (isThatVCondition || lastCondition) {
            boolean isMerged;
            int mergedColumnsCounts = isThatVCondition ? originalTable.getColumnWidth(column) : originalTable.getSource().getCell(vColumnCounter, column - vColumnCounter).getWidth();
            boolean bl = isMerged = mergedColumnsCounts > 1;
            if (isMerged) {
                if (!type.isArray()) {
                    return new ImmutablePair((Object)(type.getName() + "[]"), (Object)(type.getDisplayName(0) + "[]"));
                }
                return new ImmutablePair((Object)type.getName(), (Object)type.getDisplayName(0));
            }
        }
        for (int valueNum = 1; valueNum < width; ++valueNum) {
            String typeName;
            ILogicalTable cellValue = isThatVCondition ? (ILogicalTable)decisionValues.getRow(valueNum) : (ILogicalTable)decisionValues.getColumn(valueNum);
            if (cellValue.getSource().getCell(0, 0).getStringValue() == null || !DecisionTableHelper.maybeIsRange(cellValue.getSource().getCell(0, 0).getStringValue())) continue;
            String string = typeName = type instanceof DomainOpenClass ? type.getInstanceClass().getCanonicalName() : type.getName();
            if (intType.contains(typeName)) {
                try {
                    IntRange range = new IntRange(cellValue.getSource().getCell(0, 0).getStringValue());
                    return new ImmutablePair((Object)range.getClass().getSimpleName(), (Object)range.getClass().getSimpleName());
                }
                catch (Exception e) {
                    continue;
                }
            }
            if (!doubleType.contains(typeName)) continue;
            try {
                DoubleRange range = new DoubleRange(cellValue.getSource().getCell(0, 0).getStringValue());
                return new ImmutablePair((Object)range.getClass().getSimpleName(), (Object)range.getClass().getSimpleName());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!type.isArray()) {
            return new ImmutablePair((Object)(type.getName() + "[]"), (Object)(type.getDisplayName(0) + "[]"));
        }
        return new ImmutablePair((Object)type.getName(), (Object)type.getDisplayName(0));
    }

    private static boolean maybeIsRange(String cellValue) {
        Matcher m = RANGE_PATTERN.matcher(cellValue);
        return m.matches();
    }

    private static int getNumberOfConditions(DecisionTable decisionTable) {
        return decisionTable.getSignature().getNumberOfParameters();
    }

    public static IWritableGrid createVirtualGrid(String poiSheetName, int numberOfColumns) {
        XSSFWorkbook workbook = numberOfColumns > 256 ? new XSSFWorkbook() : new HSSFWorkbook();
        Sheet sheet = workbook.createSheet(poiSheetName);
        return DecisionTableHelper.createVirtualGrid(sheet);
    }

    public static boolean isSimpleDecisionTableOrSmartDecisionTable(TableSyntaxNode tableSyntaxNode) {
        return DecisionTableHelper.isSimpleDecisionTable(tableSyntaxNode) || DecisionTableHelper.isSmartDecisionTable(tableSyntaxNode);
    }

    public static boolean isCollectDecisionTable(TableSyntaxNode tableSyntaxNode) {
        return tableSyntaxNode.getHeader().isCollect();
    }

    public static boolean isSimpleDecisionTable(TableSyntaxNode tableSyntaxNode) {
        String dtType = tableSyntaxNode.getHeader().getHeaderToken().getIdentifier();
        return "SimpleRules".equals(dtType);
    }

    public static boolean isSmartDecisionTable(TableSyntaxNode tableSyntaxNode) {
        String dtType = tableSyntaxNode.getHeader().getHeaderToken().getIdentifier();
        return "SmartRules".equals(dtType);
    }

    public static boolean isSmartSimpleLookupTable(TableSyntaxNode tableSyntaxNode) {
        String dtType = tableSyntaxNode.getHeader().getHeaderToken().getIdentifier();
        return "SmartLookup".equals(dtType);
    }

    public static boolean isSimpleLookupTable(TableSyntaxNode tableSyntaxNode) {
        String dtType = tableSyntaxNode.getHeader().getHeaderToken().getIdentifier();
        return "SimpleLookup".equals(dtType) || DecisionTableHelper.isSmartSimpleLookupTable(tableSyntaxNode);
    }

    public static int countHConditions(ILogicalTable table) {
        int width = table.getWidth();
        int cnt = 0;
        for (int i = 0; i < width; ++i) {
            String value = ((ILogicalTable)table.getColumn(i)).getSource().getCell(0, 0).getStringValue();
            if (value == null || !DecisionTableHelper.isValidHConditionHeader(value = value.toUpperCase())) continue;
            ++cnt;
        }
        return cnt;
    }

    public static int countVConditions(ILogicalTable table) {
        int width = table.getWidth();
        int cnt = 0;
        for (int i = 0; i < width; ++i) {
            String value = ((ILogicalTable)table.getColumn(i)).getSource().getCell(0, 0).getStringValue();
            if (value == null || !DecisionTableHelper.isValidConditionHeader(value = value.toUpperCase()) && !DecisionTableHelper.isValidMergedConditionHeader(value)) continue;
            ++cnt;
        }
        return cnt;
    }

    public static XlsSheetGridModel createVirtualGrid() {
        HSSFSheet sheet = new HSSFWorkbook().createSheet();
        return DecisionTableHelper.createVirtualGrid((Sheet)sheet);
    }

    private static XlsSheetGridModel createVirtualGrid(Sheet sheet) {
        StringSourceCodeModule sourceCodeModule = new StringSourceCodeModule("", null);
        SimpleWorkbookLoader workbookLoader = new SimpleWorkbookLoader(sheet.getWorkbook());
        XlsWorkbookSourceCodeModule mockWorkbookSource = new XlsWorkbookSourceCodeModule((IOpenSourceCodeModule)sourceCodeModule, workbookLoader);
        XlsSheetSourceCodeModule mockSheetSource = new XlsSheetSourceCodeModule(new SimpleSheetLoader(sheet), mockWorkbookSource);
        return new XlsSheetGridModel(mockSheetSource);
    }

    private static final class Condition {
        int parameterIndex;
        String description;

        public Condition(int parameterIndex) {
            this.parameterIndex = parameterIndex;
        }

        public Condition(int parameterIndex, String description) {
            this.parameterIndex = parameterIndex;
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public int getParameterIndex() {
            return this.parameterIndex;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.parameterIndex;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Condition other = (Condition)obj;
            return this.parameterIndex == other.parameterIndex;
        }
    }
}

