/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt;

import java.util.ArrayList;
import java.util.List;
import org.openl.exception.OpenLCompilationException;
import org.openl.rules.dt.DTScale;
import org.openl.rules.dt.DecisionTableColumnHeaders;
import org.openl.rules.dt.DecisionTableHelper;
import org.openl.rules.dt.LookupHeadersTransformer;
import org.openl.rules.dt.TwoDimensionDecisionTableTranformer;
import org.openl.rules.table.CoordinatesTransformer;
import org.openl.rules.table.GridRegion;
import org.openl.rules.table.GridTable;
import org.openl.rules.table.IGrid;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.TransformedGridTable;
import org.openl.rules.utils.ParserUtils;

public class DecisionTableLookupConvertor {
    public static final int HEADER_ROW = 0;
    public static final int EXPR_ROW = 1;
    public static final int PARAM_ROW = 2;
    public static final int DISPLAY_ROW = 3;
    private List<ILogicalTable> hcHeaders = new ArrayList<ILogicalTable>();
    private ILogicalTable retTable;
    private DTScale scale;

    public IGridTable convertTable(ILogicalTable table) throws OpenLCompilationException {
        ILogicalTable headerRow = (ILogicalTable)table.getRow(0);
        int firstLookupColumn = this.findFirstLookupColumn(headerRow);
        this.loadHorizConditionsAndReturnColumns(headerRow, firstLookupColumn);
        this.validateLookupSection();
        IGridRegion displayRowRegion = this.getDisplayRowRegion(table);
        int firstLookupGridColumn = ((ILogicalTable)headerRow.getColumn(firstLookupColumn)).getSource().getGridColumn(0, 0);
        IGrid grid = table.getSource().getGrid();
        this.processHorizConditionsHeaders(displayRowRegion, firstLookupGridColumn, grid);
        IGridTable lookupValuesTable = this.getLookupValuesTable(table, firstLookupGridColumn, grid);
        Integer lookupValuesTableHeight = this.getlookupValuesTableHeight(table, firstLookupGridColumn, grid);
        this.isMultiplier(lookupValuesTable);
        CoordinatesTransformer transformer = this.getTransformer(headerRow, table, lookupValuesTable, lookupValuesTableHeight);
        return new TransformedGridTable(table.getSource(), transformer);
    }

    private int findFirstEmptyCellInHeader(ILogicalTable headerRow) {
        int ncol = headerRow.getSource().getWidth();
        for (int columnIndex = 0; columnIndex < ncol; ++columnIndex) {
            String headerStr = headerRow.getSource().getCell(columnIndex, 0).getStringValue();
            if (headerStr != null) continue;
            return columnIndex;
        }
        return 0;
    }

    private CoordinatesTransformer getTransformer(ILogicalTable headerRow, ILogicalTable table, IGridTable lookupValuesTable, Integer lookupValuesTableHeight) throws OpenLCompilationException {
        int retColumnStart = this.findRetColumnStart(headerRow);
        int firstEmptyCell = this.findFirstEmptyCellInHeader(headerRow);
        int retTableWidth = this.retTable.getSource().getCell(0, 0).getWidth();
        if (lookupValuesTableHeight == null) {
            lookupValuesTableHeight = lookupValuesTable.getHeight();
        }
        this.scale = new DTScale(lookupValuesTableHeight, lookupValuesTable.getWidth() / retTableWidth);
        if (this.isRetLastColumn(retColumnStart, retTableWidth, firstEmptyCell)) {
            return new TwoDimensionDecisionTableTranformer(table.getSource(), lookupValuesTable, retTableWidth);
        }
        return new LookupHeadersTransformer(table.getSource(), lookupValuesTable, retTableWidth, retColumnStart, firstEmptyCell);
    }

    private boolean isRetLastColumn(int retColumnStart, int retTableWidth, int firstEmptyCell) {
        return retColumnStart + retTableWidth == firstEmptyCell;
    }

    private int findRetColumnStart(ILogicalTable headerRow) throws OpenLCompilationException {
        int ncol = headerRow.getSource().getWidth();
        for (int columnIndex = 0; columnIndex < ncol; ++columnIndex) {
            String headerStr = headerRow.getSource().getCell(columnIndex, 0).getStringValue();
            if (headerStr == null || !DecisionTableHelper.isValidRetHeader(headerStr = headerStr.toUpperCase())) continue;
            return columnIndex;
        }
        throw new OpenLCompilationException("Lookup table must have at least one RET column");
    }

    private void processHorizConditionsHeaders(IGridRegion displayRowRegion, int firstLookupGridColumn, IGrid grid) throws OpenLCompilationException {
        GridRegion hcHeadersRegion = new GridRegion(displayRowRegion, 1, firstLookupGridColumn);
        GridTable hcHeaderTable = new GridTable(hcHeadersRegion, grid);
        this.validateHCHeaders(hcHeaderTable);
    }

    private IGridTable getLookupValuesTable(ILogicalTable originaltable, int firstLookupGridColumn, IGrid grid) {
        ILogicalTable valueTable = (ILogicalTable)originaltable.getRows(4);
        GridRegion lookupValuesRegion = new GridRegion(valueTable.getSource().getRegion(), 1, firstLookupGridColumn);
        return new GridTable(lookupValuesRegion, grid);
    }

    private Integer getlookupValuesTableHeight(ILogicalTable originaltable, int firstLookupGridColumn, IGrid grid) {
        String stringValue = originaltable.getCell(0, 0).getStringValue();
        if (stringValue == null) {
            stringValue = "";
        }
        stringValue = stringValue.toUpperCase();
        ILogicalTable valueTable = (ILogicalTable)originaltable.getRows(4);
        if (DecisionTableHelper.isValidRuleHeader(stringValue) || DecisionTableHelper.isValidMergedConditionHeader(stringValue)) {
            return valueTable.getHeight();
        }
        return null;
    }

    private int getWidthWithIgnoredEmptyCells(IGridTable table) {
        for (int width = table.getWidth(); width > 0; --width) {
            for (int i = 0; i < table.getHeight(); ++i) {
                if (table.getCell(width - 1, 0).getStringValue() == null) continue;
                return width;
            }
        }
        return 0;
    }

    private void isMultiplier(IGridTable lookupValuesTable) throws OpenLCompilationException {
        boolean isMultiplier;
        int retTableWidth = this.retTable.getSource().getWidth();
        int lookupTableWidth = lookupValuesTable.getWidth();
        boolean bl = isMultiplier = lookupTableWidth % retTableWidth == 0;
        if (!isMultiplier) {
            int w = this.getWidthWithIgnoredEmptyCells(lookupValuesTable);
            boolean bl2 = isMultiplier = w % retTableWidth == 0;
            if (!isMultiplier) {
                String message = String.format("The width of the lookup table(%d) is not a multiple of the RET width(%d)", lookupTableWidth, retTableWidth);
                throw new OpenLCompilationException(message);
            }
        }
    }

    private IGridRegion getDisplayRowRegion(ILogicalTable originaltable) {
        ILogicalTable tableWithDisplay = (ILogicalTable)originaltable.getRows(3);
        ILogicalTable displayRow = (ILogicalTable)tableWithDisplay.getRow(0);
        IGridRegion displayRowRegion = displayRow.getSource().getRegion();
        return displayRowRegion;
    }

    private void validateHCHeaders(IGridTable hcHeaderTable) throws OpenLCompilationException {
        String message = String.format("The width of the horizontal keys must be equal to the number of the %s headers", DecisionTableColumnHeaders.HORIZONTAL_CONDITION.getHeaderKey());
        this.assertEQ(this.hcHeaders.size(), hcHeaderTable.getHeight(), message);
    }

    private void assertEQ(int v1, int v2, String message) throws OpenLCompilationException {
        if (v1 == v2) {
            return;
        }
        throw new OpenLCompilationException(message);
    }

    private int findFirstLookupColumn(ILogicalTable headerRow) throws OpenLCompilationException {
        int ncol = headerRow.getWidth();
        for (int columnIndex = 0; columnIndex < ncol; ++columnIndex) {
            String headerStr = ((ILogicalTable)headerRow.getColumn(columnIndex)).getSource().getCell(0, 0).getStringValue();
            if (headerStr == null || this.isValidSimpleDecisionTableHeader(headerStr = headerStr.toUpperCase())) continue;
            return columnIndex;
        }
        throw new OpenLCompilationException("Lookup table must have at least one horizontal condition");
    }

    private boolean isValidSimpleDecisionTableHeader(String headerStr) {
        return DecisionTableHelper.isValidRuleHeader(headerStr) || DecisionTableHelper.isValidConditionHeader(headerStr) || DecisionTableHelper.isValidMergedConditionHeader(headerStr) || ParserUtils.isBlankOrCommented(headerStr);
    }

    private void loadHorizConditionsAndReturnColumns(ILogicalTable rowHeader, int firstLookupColumn) throws OpenLCompilationException {
        int ncol = rowHeader.getWidth();
        while (firstLookupColumn < ncol) {
            ILogicalTable htable = (ILogicalTable)rowHeader.getColumn(firstLookupColumn);
            String headerStr = htable.getSource().getCell(0, 0).getStringValue();
            if (headerStr != null) {
                if (DecisionTableHelper.isValidHConditionHeader(headerStr = headerStr.toUpperCase())) {
                    this.loadHorizontalCondition(htable);
                } else if (DecisionTableHelper.isValidRetHeader(headerStr)) {
                    this.loadReturnColumn(htable);
                } else {
                    String message = String.format("Lookup Table allows only %s or %s columns after vertical conditions: %s", DecisionTableColumnHeaders.HORIZONTAL_CONDITION.getHeaderKey(), DecisionTableColumnHeaders.RETURN.getHeaderKey(), headerStr);
                    throw new OpenLCompilationException(message);
                }
            }
            firstLookupColumn += htable.getSource().getCell(0, 0).getWidth();
        }
    }

    private void loadReturnColumn(ILogicalTable htable) throws OpenLCompilationException {
        if (this.retTable != null) {
            throw new OpenLCompilationException(String.format("Lookup Table can have only one %s column", DecisionTableColumnHeaders.RETURN.getHeaderKey()));
        }
        this.retTable = htable;
    }

    private void loadHorizontalCondition(ILogicalTable htable) throws OpenLCompilationException {
        this.hcHeaders.add(htable);
        this.assertTableWidth(1, htable, DecisionTableColumnHeaders.HORIZONTAL_CONDITION.getHeaderKey());
    }

    private void validateLookupSection() throws OpenLCompilationException {
        if (this.hcHeaders.size() == 0) {
            String message = String.format("Lookup Table must have at least one Horizontal Condition (%s1)", DecisionTableColumnHeaders.HORIZONTAL_CONDITION.getHeaderKey());
            throw new OpenLCompilationException(message);
        }
        if (this.retTable == null) {
            String message = String.format("Lookup Table must have %s column", DecisionTableColumnHeaders.RETURN.getHeaderKey());
            throw new OpenLCompilationException(message);
        }
    }

    private void assertTableWidth(int w, ILogicalTable htable, String type) throws OpenLCompilationException {
        if (htable.getSource().getWidth() == w) {
            return;
        }
        throw new OpenLCompilationException(String.format("Column %s must have width=%s", type, w));
    }

    public DTScale getScale() {
        return this.scale;
    }
}

