/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.algorithm;

import java.util.ArrayList;
import org.openl.binding.BindingDependencies;
import org.openl.binding.IBindingContext;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.domain.IDomain;
import org.openl.domain.IIntIterator;
import org.openl.domain.IIntSelector;
import org.openl.rules.binding.RulesBindingDependencies;
import org.openl.rules.dt.DecisionTable;
import org.openl.rules.dt.DecisionTableRuleNode;
import org.openl.rules.dt.IBaseCondition;
import org.openl.rules.dt.algorithm.IDecisionTableAlgorithm;
import org.openl.rules.dt.algorithm.IndexInfo;
import org.openl.rules.dt.algorithm.evaluator.ContainsInArrayIndexedEvaluator;
import org.openl.rules.dt.algorithm.evaluator.ContainsInOrNotInArrayIndexedEvaluator;
import org.openl.rules.dt.algorithm.evaluator.DefaultConditionEvaluator;
import org.openl.rules.dt.algorithm.evaluator.DomainCanNotBeDefined;
import org.openl.rules.dt.algorithm.evaluator.EqualsIndexedEvaluator;
import org.openl.rules.dt.algorithm.evaluator.IConditionEvaluator;
import org.openl.rules.dt.algorithm.evaluator.RangeIndexedEvaluator;
import org.openl.rules.dt.data.ConditionOrActionParameterField;
import org.openl.rules.dt.element.ICondition;
import org.openl.rules.dt.index.ARuleIndex;
import org.openl.rules.dt.type.BooleanAdaptorFactory;
import org.openl.rules.dt.type.BooleanTypeAdaptor;
import org.openl.rules.dt.type.DoubleRangeAdaptor;
import org.openl.rules.dt.type.IRangeAdaptor;
import org.openl.rules.dt.type.IntRangeAdaptor;
import org.openl.rules.helpers.DoubleRange;
import org.openl.rules.helpers.IntRange;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IAggregateInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IParameterDeclaration;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.ClassUtils;
import org.openl.util.StringUtils;
import org.openl.vm.IRuntimeEnv;
import org.openl.vm.Tracer;

public class DecisionTableOptimizedAlgorithm
implements IDecisionTableAlgorithm {
    private IConditionEvaluator[] evaluators;
    private DecisionTable table;
    private ARuleIndex indexRoot;
    private BindingDependencies dependencies;
    IndexInfo info;

    public DecisionTableOptimizedAlgorithm(IConditionEvaluator[] evaluators, DecisionTable table, IndexInfo info) {
        this.evaluators = evaluators;
        this.table = table;
        this.info = info;
        this.indexRoot = this.buildIndex(info);
        this.dependencies = new RulesBindingDependencies();
        table.updateDependency(this.dependencies);
    }

    private ARuleIndex buildIndex(IndexInfo info) {
        int first = info.fromCondition;
        IBaseCondition[] cc = this.table.getConditionRows();
        if (cc.length <= first || first > info.toCondition) {
            return null;
        }
        ICondition firstCondition = (ICondition)cc[first];
        if (!this.canIndex(this.evaluators[first], firstCondition)) {
            return null;
        }
        ARuleIndex indexRoot = this.evaluators[first].makeIndex(firstCondition, info.makeRuleIterator());
        this.indexNodes(indexRoot, first + 1, info);
        return indexRoot;
    }

    private boolean canIndex(IConditionEvaluator evaluator, ICondition condition) {
        return evaluator.isIndexed() && !condition.hasFormulas();
    }

    private void indexNodes(ARuleIndex index, int condN, IndexInfo info) {
        if (index == null || condN > info.toCondition) {
            return;
        }
        if (!this.canIndex(this.evaluators[condN], this.table.getCondition(condN))) {
            return;
        }
        for (DecisionTableRuleNode decisionTableRuleNode : index.nodes()) {
            this.indexNode(decisionTableRuleNode, condN, info);
        }
        this.indexNode(index.getEmptyOrFormulaNodes(), condN, info);
    }

    private void indexNode(DecisionTableRuleNode node, int condN, IndexInfo info) {
        ARuleIndex nodeIndex = this.evaluators[condN].makeIndex(this.table.getCondition(condN), node.getRulesIterator());
        node.setNextIndex(nodeIndex);
        this.indexNodes(nodeIndex, condN + 1, info);
    }

    public IConditionEvaluator[] getEvaluators() {
        return this.evaluators;
    }

    public DecisionTable getTable() {
        return this.table;
    }

    private Object evaluateTestValue(ICondition condition, Object target, Object[] dtparams, IRuntimeEnv env) {
        return condition.getEvaluator().invoke(target, dtparams, env);
    }

    static IRangeAdaptor<? extends Object, ? extends Comparable<?>> getRangeAdaptor(IOpenClass methodType, IOpenClass paramType) {
        if (DecisionTableOptimizedAlgorithm.isMethodTypeNumber(methodType)) {
            if (DecisionTableOptimizedAlgorithm.isParameterIntRange(paramType)) {
                return IntRangeAdaptor.getInstance();
            }
            if (DecisionTableOptimizedAlgorithm.isParameterDoubleRange(paramType)) {
                return DoubleRangeAdaptor.getInstance();
            }
        }
        return null;
    }

    private static boolean isParameterDoubleRange(IOpenClass paramType) {
        return DoubleRange.class.equals((Object)paramType.getInstanceClass());
    }

    private static boolean isParameterIntRange(IOpenClass paramType) {
        return IntRange.class.equals((Object)paramType.getInstanceClass());
    }

    private static boolean isMethodTypeNumber(IOpenClass methodType) {
        return ClassUtils.isAssignable((Class)methodType.getInstanceClass(), Number.class);
    }

    public static IConditionEvaluator makeEvaluator(ICondition condition, IOpenClass methodType, IBindingContext bindingContext) throws SyntaxNodeException {
        if (condition.hasFormulas()) {
            return new DefaultConditionEvaluator();
        }
        IOpenCast params = condition.getParams();
        switch (((IParameterDeclaration[])params).length) {
            case 1: {
                IOpenClass paramType = params[0].getType();
                IOpenCast openCast = bindingContext.getCast(paramType, methodType);
                if (openCast != null) {
                    return new EqualsIndexedEvaluator(openCast);
                }
                IAggregateInfo aggregateInfo = paramType.getAggregateInfo();
                if (aggregateInfo.isAggregate(paramType) && aggregateInfo.getComponentType(paramType).isAssignableFrom(methodType)) {
                    return new ContainsInArrayIndexedEvaluator();
                }
                IRangeAdaptor<? extends Object, ? extends Comparable<?>> rangeAdaptor = DecisionTableOptimizedAlgorithm.getRangeAdaptor(methodType, paramType);
                if (rangeAdaptor != null) {
                    return new RangeIndexedEvaluator(rangeAdaptor, 1);
                }
                if (!JavaOpenClass.BOOLEAN.equals((Object)methodType) && !JavaOpenClass.getOpenClass(Boolean.class).equals((Object)methodType)) break;
                return new DefaultConditionEvaluator();
            }
            case 2: {
                BooleanTypeAdaptor booleanTypeAdaptor;
                IOpenClass paramType0 = params[0].getType();
                IOpenClass paramType1 = params[1].getType();
                if (methodType == paramType0 && methodType == paramType1) {
                    Class clazz = methodType.getInstanceClass();
                    if (clazz != Short.TYPE && clazz != Byte.TYPE && clazz != Integer.TYPE && clazz != Long.TYPE && clazz != Double.TYPE && clazz != Float.TYPE && !Comparable.class.isAssignableFrom(clazz)) {
                        String message = String.format("Type '%s' is not Comparable", methodType.getName());
                        throw SyntaxNodeExceptionUtils.createError((String)message, null, null, (IOpenSourceCodeModule)condition.getSourceCodeModule());
                    }
                    return new RangeIndexedEvaluator(null, 2);
                }
                IAggregateInfo aggregateInfo = paramType1.getAggregateInfo();
                if (aggregateInfo.isAggregate(paramType1) && aggregateInfo.getComponentType(paramType1) == methodType && (booleanTypeAdaptor = BooleanAdaptorFactory.getAdaptor(paramType0)) != null) {
                    return new ContainsInOrNotInArrayIndexedEvaluator(booleanTypeAdaptor);
                }
                if (!JavaOpenClass.BOOLEAN.equals((Object)methodType) && !JavaOpenClass.getOpenClass(Boolean.class).equals((Object)methodType)) break;
                return new DefaultConditionEvaluator();
            }
        }
        ArrayList<String> names = new ArrayList<String>();
        for (IOpenCast parameterDeclaration : params) {
            String name = parameterDeclaration.getType().getName();
            names.add(name);
        }
        String parametersString = StringUtils.join(names, (String)",");
        String message = String.format("Can not make a Condition Evaluator for parameter %s and [%s]", methodType.getName(), parametersString);
        throw SyntaxNodeExceptionUtils.createError((String)message, null, null, (IOpenSourceCodeModule)condition.getSourceCodeModule());
    }

    @Override
    public void removeParamValuesForIndexedConditions() {
        for (int i = this.info.fromRule; i <= this.info.toCondition; ++i) {
            if (this.evaluators[i].isIndexed()) {
                if (this.isDependecyOnConditionExists(this.table.getCondition(i))) continue;
                this.table.getCondition(i).clearParamValues();
                continue;
            }
            IConditionEvaluator evaluator = this.evaluators[i];
            this.evaluators[i] = new ConditionEvaluatorDecoratorAsNotIndexed(evaluator);
            break;
        }
        this.dependencies = null;
    }

    private boolean isDependecyOnConditionExists(ICondition condition) {
        for (IOpenField field : this.dependencies.getFieldsMap().values()) {
            if (!(field instanceof ConditionOrActionParameterField) || ((ConditionOrActionParameterField)field).getConditionOrAction() != condition) continue;
            return true;
        }
        return false;
    }

    @Override
    public IIntIterator checkedRules(Object target, Object[] params, IRuntimeEnv env) {
        int conditionNumber;
        IIntIterator iterator = null;
        if (this.indexRoot == null) {
            iterator = this.info.makeRuleIterator();
        } else {
            ARuleIndex index = this.indexRoot;
            for (conditionNumber = this.info.fromCondition; conditionNumber <= this.info.toCondition; ++conditionNumber) {
                ICondition condition = this.table.getCondition(conditionNumber);
                index = (ARuleIndex)Tracer.wrap((Object)this, (Object)index, (Object[])new Object[]{condition});
                Object testValue = this.evaluateTestValue(condition, target, params, env);
                DecisionTableRuleNode node = index.findNode(testValue);
                Tracer.put((Object)this, (String)"index", (Object[])new Object[]{condition, node, true});
                if (!node.hasIndex()) {
                    iterator = node.getRulesIterator();
                    ++conditionNumber;
                    break;
                }
                index = node.getNextIndex();
            }
        }
        while (conditionNumber <= this.info.toCondition) {
            ICondition condition = this.table.getCondition(conditionNumber);
            IConditionEvaluator evaluator = this.evaluators[conditionNumber];
            IIntSelector sel = evaluator.getSelector(condition, target, params, env);
            sel = (IIntSelector)Tracer.wrap((Object)this, (Object)sel, (Object[])new Object[]{condition});
            iterator = iterator.select(sel);
            ++conditionNumber;
        }
        return iterator;
    }

    private static final class ConditionEvaluatorDecoratorAsNotIndexed
    implements IConditionEvaluator {
        IConditionEvaluator decorate;

        public ConditionEvaluatorDecoratorAsNotIndexed(IConditionEvaluator decorate) {
            if (decorate == null) {
                throw new IllegalArgumentException("decorate arg can't be null!");
            }
            this.decorate = decorate;
        }

        @Override
        public void setOptimizedSourceCode(String code) {
            this.decorate.setOptimizedSourceCode(code);
        }

        @Override
        public ARuleIndex makeIndex(ICondition condition, IIntIterator it) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isIndexed() {
            return false;
        }

        @Override
        public IIntSelector getSelector(ICondition condition, Object target, Object[] dtparams, IRuntimeEnv env) {
            return this.decorate.getSelector(condition, target, dtparams, env);
        }

        public IDomain<? extends Object> getRuleParameterDomain(IBaseCondition condition) throws DomainCanNotBeDefined {
            return this.decorate.getRuleParameterDomain(condition);
        }

        @Override
        public String getOptimizedSourceCode() {
            return this.decorate.getOptimizedSourceCode();
        }

        @Override
        public IOpenSourceCodeModule getFormalSourceCode(IBaseCondition condition) {
            return this.decorate.getFormalSourceCode(condition);
        }

        public IDomain<? extends Object> getConditionParameterDomain(int paramIdx, IBaseCondition condition) throws DomainCanNotBeDefined {
            return this.decorate.getConditionParameterDomain(paramIdx, condition);
        }
    }
}

