/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.algorithm;

import org.openl.domain.IIntIterator;
import org.openl.domain.IntRangeDomain;
import org.openl.rules.dt.DTInfo;
import org.openl.rules.dt.DTScale;
import org.openl.rules.dt.DecisionTable;

public class IndexInfo {
    DecisionTable table;
    int fromCondition = 0;
    int toCondition;
    int fromRule = 0;
    int toRule;
    private int step = 1;

    public int getStep() {
        return this.step;
    }

    public IndexInfo withTable(DecisionTable t) {
        this.table = t;
        this.toCondition = this.table.getConditionRows().length - 1;
        this.toRule = this.table.getNumberOfRules() - 1;
        return this;
    }

    public DecisionTable getTable() {
        return this.table;
    }

    public int getFromCondition() {
        return this.fromCondition;
    }

    public int getToCondition() {
        return this.toCondition;
    }

    public int getFromRule() {
        return this.fromRule;
    }

    public int getToRule() {
        return this.toRule;
    }

    public IndexInfo makeVerticalInfo() {
        DTInfo dti = this.table.getDtInfo();
        return new IndexInfo().withTable(this.table).withToCondition(dti.getNumberVConditions() - 1).withToRule(dti.getScale().getHScale().getMultiplier() - 1);
    }

    public IndexInfo makeHorizontalalInfo() {
        DTInfo dti = this.table.getDtInfo();
        DTScale dts = dti.getScale();
        int vSize = dts.getVScale().getMultiplier();
        int hSize = dts.getHScale().getMultiplier();
        return new IndexInfo().withTable(this.table).withFromCondition(dti.getNumberVConditions()).withToCondition(this.toCondition).withToRule((vSize - 1) * hSize).withStep(hSize);
    }

    private IndexInfo withStep(int step) {
        this.step = step;
        return this;
    }

    private IndexInfo withFromCondition(int fromCondition) {
        this.fromCondition = fromCondition;
        return this;
    }

    private IndexInfo withToRule(int toRule) {
        this.toRule = toRule;
        return this;
    }

    private IndexInfo withToCondition(int toCondition) {
        this.toCondition = toCondition;
        return this;
    }

    public IIntIterator makeRuleIterator() {
        return new IntRangeDomain(this.fromRule, this.toRule).iterate(this.step);
    }
}

