/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.algorithm;

import java.util.ArrayList;
import java.util.Iterator;
import org.openl.domain.AIntIterator;
import org.openl.domain.IIntIterator;
import org.openl.rules.dt.algorithm.IDecisionTableAlgorithm;
import org.openl.vm.IRuntimeEnv;

public class TwoDimensionalAlgorithm
implements IDecisionTableAlgorithm {
    private IDecisionTableAlgorithm va;
    private IDecisionTableAlgorithm ha;

    public TwoDimensionalAlgorithm(IDecisionTableAlgorithm va, IDecisionTableAlgorithm ha) {
        this.va = va;
        this.ha = ha;
    }

    @Override
    public void removeParamValuesForIndexedConditions() {
        this.va.removeParamValuesForIndexedConditions();
        this.ha.removeParamValuesForIndexedConditions();
    }

    @Override
    public IIntIterator checkedRules(Object target, Object[] params, IRuntimeEnv env) {
        IIntIterator iv = this.va.checkedRules(target, params, env);
        IIntIterator ih = this.ha.checkedRules(target, params, env);
        return ih.isResetable() ? new TwoDScaleIterator(iv, ih) : new TwoDScaleIteratorNotResetable(iv, ih);
    }

    class TwoDScaleIteratorNotResetable
    extends TwoDScaleIterator {
        ArrayList<Integer> storeIh;
        Iterator<Integer> itH;

        public TwoDScaleIteratorNotResetable(IIntIterator iv, IIntIterator ih) {
            super(iv, ih);
            this.storeIh = new ArrayList();
        }

        @Override
        protected int nextH() {
            if (this.itH != null) {
                return this.itH.next();
            }
            int i = this.ih.nextInt();
            this.storeIh.add(i);
            return i;
        }

        @Override
        protected void resetH() {
            this.itH = this.storeIh.iterator();
        }

        @Override
        protected boolean hasNextH() {
            return this.itH == null ? this.ih.hasNext() : this.itH.hasNext();
        }
    }

    class TwoDScaleIterator
    extends AIntIterator {
        IIntIterator iv;
        IIntIterator ih;
        int vValue = -1;

        public TwoDScaleIterator(IIntIterator iv, IIntIterator ih) {
            this.iv = iv;
            this.ih = ih;
            this.nextV();
        }

        protected void nextV() {
            this.vValue = this.iv.hasNext() ? (Integer)this.iv.next() : -1;
        }

        public int nextInt() {
            return this.vValue + this.nextH();
        }

        protected int nextH() {
            return this.ih.nextInt();
        }

        public boolean hasNext() {
            while (this.vValue >= 0) {
                if (this.hasNextH()) {
                    return true;
                }
                this.resetH();
                this.nextV();
            }
            return false;
        }

        protected void resetH() {
            this.ih.reset();
        }

        protected boolean hasNextH() {
            return this.ih.hasNext();
        }

        public boolean isResetable() {
            return false;
        }

        public void reset() {
            throw new UnsupportedOperationException();
        }
    }
}

