/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.algorithm.evaluator;

import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.domain.EnumDomain;
import org.openl.domain.IDomain;
import org.openl.domain.IIntIterator;
import org.openl.domain.IIntSelector;
import org.openl.rules.dt.DecisionTableRuleNode;
import org.openl.rules.dt.DecisionTableRuleNodeBuilder;
import org.openl.rules.dt.IBaseCondition;
import org.openl.rules.dt.algorithm.evaluator.AConditionEvaluator;
import org.openl.rules.dt.algorithm.evaluator.EqualsSelector;
import org.openl.rules.dt.algorithm.evaluator.FloatTypeComparator;
import org.openl.rules.dt.algorithm.evaluator.IConditionEvaluator;
import org.openl.rules.dt.element.ICondition;
import org.openl.rules.dt.index.ARuleIndex;
import org.openl.rules.dt.index.EqualsIndex;
import org.openl.rules.helpers.NumberUtils;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.StringSourceCodeModule;
import org.openl.vm.IRuntimeEnv;

public class EqualsIndexedEvaluator
extends AConditionEvaluator
implements IConditionEvaluator {
    private IOpenCast openCast;

    public EqualsIndexedEvaluator() {
    }

    public EqualsIndexedEvaluator(IOpenCast openCast) {
        this.openCast = openCast;
    }

    @Override
    public IOpenSourceCodeModule getFormalSourceCode(IBaseCondition condition) {
        IOpenSourceCodeModule condSource = condition.getSourceCodeModule();
        return new StringSourceCodeModule("(" + condSource.getCode() + ") == " + condition.getParams()[0].getName(), condSource.getUri());
    }

    @Override
    public IIntSelector getSelector(ICondition condition, Object target, Object[] dtparams, IRuntimeEnv env) {
        Object value = condition.getEvaluator().invoke(target, dtparams, env);
        return new EqualsSelector(condition, value, target, dtparams, env);
    }

    @Override
    public boolean isIndexed() {
        return true;
    }

    @Override
    public ARuleIndex makeIndex(ICondition condition, IIntIterator it) {
        if (it.size() < 1) {
            return null;
        }
        AbstractMap map = null;
        Map<Object, DecisionTableRuleNode> nodeMap = null;
        DecisionTableRuleNodeBuilder emptyBuilder = new DecisionTableRuleNodeBuilder();
        boolean comparatorBasedMap = false;
        while (it.hasNext()) {
            DecisionTableRuleNodeBuilder dtrb;
            int i = it.nextInt();
            if (condition.isEmpty(i)) {
                emptyBuilder.addRule(i);
                if (map == null) continue;
                for (DecisionTableRuleNodeBuilder dtrnb : map.values()) {
                    dtrnb.addRule(i);
                }
                continue;
            }
            Object value = condition.getParamValue(0, i);
            if (this.openCast != null) {
                value = this.openCast.convert(value);
            }
            if (comparatorBasedMap && !(value instanceof Comparable)) {
                throw new IllegalArgumentException("Invalid state! Index based on comparable interface!");
            }
            if (map == null) {
                if (NumberUtils.isFloatPointNumber(value)) {
                    if (value instanceof BigDecimal) {
                        map = new TreeMap();
                        nodeMap = new TreeMap<Object, DecisionTableRuleNode>();
                    } else {
                        map = new TreeMap(FloatTypeComparator.getInstance());
                        nodeMap = new TreeMap<Object, DecisionTableRuleNode>(FloatTypeComparator.getInstance());
                    }
                    comparatorBasedMap = true;
                } else {
                    map = new HashMap();
                    nodeMap = new HashMap<Object, DecisionTableRuleNode>();
                }
            }
            if ((dtrb = (DecisionTableRuleNodeBuilder)map.get(value)) == null) {
                dtrb = new DecisionTableRuleNodeBuilder(emptyBuilder);
                map.put(value, dtrb);
            }
            dtrb.addRule(i);
        }
        if (map != null) {
            for (Map.Entry element : map.entrySet()) {
                nodeMap.put(element.getKey(), ((DecisionTableRuleNodeBuilder)element.getValue()).makeNode());
            }
        } else {
            nodeMap = Collections.emptyMap();
        }
        EqualsIndex index = new EqualsIndex(emptyBuilder.makeNode(), nodeMap);
        return index;
    }

    protected IDomain<Object> indexedDomain(IBaseCondition condition) {
        int len = condition.getNumberOfRules();
        ArrayList<Object> list = new ArrayList<Object>(len);
        HashSet<Object> set = new HashSet<Object>(len);
        for (int ruleN = 0; ruleN < len; ++ruleN) {
            Object key;
            if (condition.isEmpty(ruleN) || (key = condition.getParamValue(0, ruleN)) == null || !set.add(key)) continue;
            list.add(key);
        }
        EnumDomain ed = new EnumDomain(list.toArray());
        return ed;
    }
}

