/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.algorithm2.nodes;

import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.openl.rules.dt.algorithm.evaluator.FloatTypeComparator;
import org.openl.rules.dt.algorithm2.ConditionDescriptor;
import org.openl.rules.dt.algorithm2.ISearchTreeNode;
import org.openl.rules.dt.algorithm2.NodeBuilder;
import org.openl.rules.dt.algorithm2.nodes.NodeBuilderN;
import org.openl.rules.dt.algorithm2.nodes.NodeBuilderV;
import org.openl.rules.dt.algorithm2.nodes.SearchNodeMN;
import org.openl.rules.dt.algorithm2.nodes.SearchNodeMi;
import org.openl.rules.dt.algorithm2.nodes.SearchNodeN;
import org.openl.rules.dt.algorithm2.nodes.SearchNodeV;
import org.openl.rules.dt.element.ICondition;
import org.openl.rules.helpers.NumberUtils;
import org.openl.types.IOpenClass;
import org.openl.util.trie.IARTNode;

public class ContainsInArrayNodeBuilder {
    public static NodeBuilder makeNodeBuilder(ICondition cond, boolean isFirst, boolean isLast) {
        if (isFirst) {
            if (isLast) {
                return new EqualsNodeBuiderMi(cond, isFirst, isLast);
            }
            return new EqualsNodeBuiderMN(cond, isFirst, isLast);
        }
        if (isLast) {
            return new EqualsNodeBuiderVi(cond, isFirst, isLast);
        }
        return new EqualsNodeBuiderN(cond, isFirst, isLast);
    }

    public static Map<Object, Integer> initilaizeEqualsIndexMap(IOpenClass type, Map<Object, Integer> uniqueIndex) {
        AbstractMap map = null;
        map = NumberUtils.isFloatPointType(type.getInstanceClass().getComponentType()) ? new TreeMap(FloatTypeComparator.getInstance()) : new HashMap(uniqueIndex.size());
        int index = 0;
        Iterator<Map.Entry<Object, Integer>> iterator = uniqueIndex.entrySet().iterator();
        while (iterator.hasNext()) {
            Object ary = iterator.next().getKey();
            int len = Array.getLength(ary);
            for (int i = 0; i < len; ++i) {
                Object key = Array.get(ary, i);
                if (map.containsKey(key)) continue;
                map.put(key, index++);
            }
        }
        return map;
    }

    public static Map<Object, Integer> initilaizeEqualsRuleNMap(IOpenClass type, int size) {
        if (NumberUtils.isFloatPointType(type.getInstanceClass().getComponentType())) {
            return new TreeMap<Object, Integer>(FloatTypeComparator.getInstance());
        }
        return new HashMap<Object, Integer>(size);
    }

    public static IOpenClass getMapKeyType(ICondition condition) {
        return condition.getParameterInfo(0).getParameterDeclaration().getType();
    }

    public static Map<Object, ISearchTreeNode> initializeEqualsNodeMap(IOpenClass type, int size) {
        if (NumberUtils.isFloatPointType(type.getInstanceClass().getComponentType())) {
            return new TreeMap<Object, ISearchTreeNode>(FloatTypeComparator.getInstance());
        }
        return new HashMap<Object, ISearchTreeNode>(size);
    }

    public static class EqualsNodeBuiderMi
    extends NodeBuilder.Single {
        Map<Object, Integer> map;

        public EqualsNodeBuiderMi(ICondition condition, boolean isFirst, boolean isLast) {
            super(condition, isFirst, isLast);
            this.map = ContainsInArrayNodeBuilder.initilaizeEqualsRuleNMap(ContainsInArrayNodeBuilder.getMapKeyType(condition), condition.getStorageInfo(0).getUniqueIndex().size());
        }

        @Override
        public boolean indexRuleN(ISearchTreeNode node, int ruleN) {
            Object ary = this.condition.getParamValue(0, ruleN);
            int len = Array.getLength(ary);
            boolean ret = false;
            for (int i = 0; i < len; ++i) {
                Object value = Array.get(ary, i);
                if (this.map.containsKey(value)) continue;
                this.map.put(value, ruleN);
                ret = true;
            }
            return ret;
        }

        @Override
        public ISearchTreeNode findOrCreateNextNode(ISearchTreeNode node, int ruleN) {
            throw new UnsupportedOperationException("findOrCreateNextNode");
        }

        @Override
        public ISearchTreeNode createNode() {
            return new SearchNodeMi(this.map);
        }

        @Override
        public ConditionDescriptor makeDescriptor() {
            return new ConditionDescriptor(true, this.condition);
        }
    }

    public static class EqualsNodeBuiderMN
    extends NodeBuilder {
        Map<Object, ISearchTreeNode> map;

        public EqualsNodeBuiderMN(ICondition condition, boolean isFirst, boolean isLast) {
            super(condition, isFirst, isLast);
            this.map = ContainsInArrayNodeBuilder.initializeEqualsNodeMap(ContainsInArrayNodeBuilder.getMapKeyType(condition), condition.getStorageInfo(0).getUniqueIndex().size());
        }

        @Override
        public ConditionDescriptor makeDescriptor() {
            return new ConditionDescriptor(true, this.condition);
        }

        @Override
        public boolean indexRuleN(ISearchTreeNode node, int ruleN) {
            throw new UnsupportedOperationException("indexRuleN");
        }

        @Override
        public ISearchTreeNode findOrCreateNextNode(ISearchTreeNode node, int ruleN) {
            Object value = this.condition.getParamValue(0, ruleN);
            ISearchTreeNode nextNode = this.map.get(value);
            if (nextNode == null) {
                nextNode = this.next.createNode();
                this.map.put(value, nextNode);
            }
            return nextNode;
        }

        @Override
        public ISearchTreeNode createNode() {
            return new SearchNodeMN(this.map);
        }

        @Override
        public boolean isSingleNode(int ruleN) {
            return false;
        }

        @Override
        public Iterator<ISearchTreeNode> findOrCreateNextNodes(ISearchTreeNode node, int ruleN) {
            final Object ary = this.condition.getParamValue(0, ruleN);
            final int len = Array.getLength(ary);
            return new Iterator<ISearchTreeNode>(){
                int current = 0;

                @Override
                public boolean hasNext() {
                    return this.current < len;
                }

                @Override
                public ISearchTreeNode next() {
                    Object nextValue;
                    ISearchTreeNode nextNode;
                    if ((nextNode = EqualsNodeBuiderMN.this.map.get(nextValue = Array.get(ary, this.current++))) == null) {
                        nextNode = EqualsNodeBuiderMN.this.next.createNode();
                        EqualsNodeBuiderMN.this.map.put(nextValue, nextNode);
                    }
                    return nextNode;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    public static class EqualsNodeBuiderN
    extends NodeBuilderN {
        private Map<Object, Integer> map;

        public EqualsNodeBuiderN(ICondition condition, boolean isFirst, boolean isLast) {
            super(condition, isFirst, isLast);
            this.map = ContainsInArrayNodeBuilder.initilaizeEqualsIndexMap(ContainsInArrayNodeBuilder.getMapKeyType(condition), condition.getStorageInfo(0).getUniqueIndex());
        }

        @Override
        protected int calculateNodeIndex(int ruleN) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ConditionDescriptor makeDescriptor() {
            return new ConditionDescriptor.WithMap(true, this.condition, this.map);
        }

        @Override
        protected int getNodesSize() {
            return this.map.size();
        }

        @Override
        public boolean isSingleNode(int ruleN) {
            return false;
        }

        @Override
        public Iterator<ISearchTreeNode> findOrCreateNextNodes(ISearchTreeNode node, int ruleN) {
            final SearchNodeN snode = (SearchNodeN)node;
            final Object ary = this.condition.getParamValue(0, ruleN);
            final int len = Array.getLength(ary);
            return new Iterator<ISearchTreeNode>(){
                int current = 0;

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean hasNext() {
                    return this.current < len;
                }

                @Override
                public ISearchTreeNode next() {
                    Object nextValue = Array.get(ary, this.current++);
                    int index = (Integer)EqualsNodeBuiderN.this.map.get(nextValue);
                    IARTNode nextNode = snode.findNode(index);
                    if (nextNode == null) {
                        nextNode = EqualsNodeBuiderN.this.next.createNode();
                        snode.setNode(index, nextNode);
                    }
                    return (ISearchTreeNode)nextNode;
                }
            };
        }
    }

    public static class EqualsNodeBuiderVi
    extends NodeBuilderV.SingleV {
        private Map<Object, Integer> map;

        public EqualsNodeBuiderVi(ICondition condition, boolean isFirst, boolean isLast) {
            super(condition, isFirst, isLast);
            this.map = ContainsInArrayNodeBuilder.initilaizeEqualsIndexMap(ContainsInArrayNodeBuilder.getMapKeyType(condition), condition.getStorageInfo(0).getUniqueIndex());
        }

        @Override
        public ConditionDescriptor makeDescriptor() {
            return new ConditionDescriptor.WithMap(true, this.condition, this.map);
        }

        @Override
        protected int getNodesSize() {
            return this.map.size();
        }

        @Override
        public boolean indexRuleN(ISearchTreeNode node, int ruleN) {
            SearchNodeV vnode = (SearchNodeV)node;
            Object ary = this.condition.getParamValue(0, ruleN);
            int len = Array.getLength(ary);
            boolean ret = false;
            for (int i = 0; i < len; ++i) {
                Object value = Array.get(ary, i);
                int index = this.map.get(value);
                Object oldValue = vnode.getValue(index);
                if (oldValue != null) continue;
                vnode.setValue(index, ruleN);
                ret = true;
            }
            return ret;
        }

        @Override
        protected int calculateNodeIndex(int ruleN) {
            throw new UnsupportedOperationException();
        }
    }
}

