/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.element;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBindingContextDelegator;
import org.openl.binding.impl.NodeType;
import org.openl.binding.impl.component.ComponentOpenClass;
import org.openl.engine.OpenLCellExpressionsCompiler;
import org.openl.exception.OpenLCompilationException;
import org.openl.rules.OpenlToolAdaptor;
import org.openl.rules.binding.RuleRowHelper;
import org.openl.rules.dt.DTScale;
import org.openl.rules.dt.IDecisionTableParameterInfo;
import org.openl.rules.dt.element.ArrayHolder;
import org.openl.rules.dt.element.DecisionTableParameterInfo;
import org.openl.rules.dt.element.IDecisionRow;
import org.openl.rules.dt.element.RuleRow;
import org.openl.rules.dt.storage.IStorage;
import org.openl.rules.dt.storage.IStorageBuilder;
import org.openl.rules.dt.storage.StorageFactory;
import org.openl.rules.dt.storage.StorageInfo;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.LogicalTableHelper;
import org.openl.rules.table.SimpleLogicalTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.CompositeSyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.syntax.impl.Tokenizer;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.IParameterDeclaration;
import org.openl.types.NullOpenClass;
import org.openl.types.impl.CompositeMethod;
import org.openl.types.impl.MethodSignature;
import org.openl.types.impl.OpenMethodHeader;
import org.openl.types.impl.ParameterDeclaration;
import org.openl.vm.IRuntimeEnv;

public abstract class FunctionalRow
implements IDecisionRow {
    private static final String NO_PARAM = "P";
    private String name;
    private int row;
    protected CompositeMethod method;
    private IParameterDeclaration[] params;
    protected IStorage<?>[] storage;
    private ILogicalTable decisionTable;
    private ILogicalTable paramsTable;
    private ILogicalTable codeTable;
    private ILogicalTable presentationTable;
    DTScale.RowScale scale;
    private int noParamsIndex = 0;

    public FunctionalRow(String name, int row, ILogicalTable decisionTable, DTScale.RowScale scale) {
        this.name = name;
        this.row = row;
        this.decisionTable = decisionTable;
        this.paramsTable = (ILogicalTable)decisionTable.getSubtable(2, row, 1, 1);
        this.codeTable = (ILogicalTable)decisionTable.getSubtable(1, row, 1, 1);
        this.presentationTable = (ILogicalTable)decisionTable.getSubtable(3, row, 1, 1);
        this.scale = scale;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public CompositeMethod getMethod() {
        return this.method;
    }

    @Override
    public IParameterDeclaration[] getParams() {
        return this.params;
    }

    protected void setParams(IParameterDeclaration[] params) {
        this.params = params;
    }

    @Override
    public void clearParamValues() {
        this.storage = null;
    }

    @Override
    public IDecisionTableParameterInfo getParameterInfo(int i) {
        return new DecisionTableParameterInfo(i, this);
    }

    @Override
    public IOpenSourceCodeModule getSourceCodeModule() {
        if (this.method != null) {
            return this.method.getMethodBodyBoundNode().getSyntaxNode().getModule();
        }
        return null;
    }

    @Override
    public int getNumberOfParams() {
        return this.params.length;
    }

    @Override
    public ILogicalTable getDecisionTable() {
        return this.decisionTable;
    }

    @Override
    public String[] getParamPresentation() {
        int length = this.paramsTable.getHeight();
        String[] result = new String[length];
        int fromHeight = 0;
        for (int i = 0; i < result.length; ++i) {
            int gridHeight = ((ILogicalTable)this.paramsTable.getRow(i)).getSource().getHeight();
            IGridTable singleParamGridTable = (IGridTable)this.presentationTable.getSource().getRows(fromHeight, fromHeight + gridHeight - 1);
            result[i] = singleParamGridTable.getCell(0, 0).getStringValue();
            fromHeight += gridHeight;
        }
        return result;
    }

    @Override
    public void prepare(IOpenClass methodType, IMethodSignature signature, OpenL openl, ComponentOpenClass componentOpenClass, IBindingContextDelegator bindingContextDelegator, RuleRow ruleRow) throws Exception {
        this.method = this.generateMethod(signature, openl, bindingContextDelegator, (IOpenClass)componentOpenClass, methodType);
        OpenlToolAdaptor openlAdaptor = new OpenlToolAdaptor(openl, (IBindingContext)bindingContextDelegator);
        OpenMethodHeader header = new OpenMethodHeader(this.name, null, signature, (IOpenClass)componentOpenClass);
        openlAdaptor.setHeader((IOpenMethodHeader)header);
        this.prepareParamValues(this.method, openlAdaptor, ruleRow);
        if (bindingContextDelegator.isExecutionMode()) {
            this.decisionTable = null;
            this.paramsTable = null;
            this.codeTable = null;
            this.presentationTable = null;
        }
    }

    protected IParameterDeclaration[] getParams(IOpenSourceCodeModule methodSource, IMethodSignature signature, IOpenClass declaringClass, IOpenClass methodType, OpenL openl, IBindingContext bindingContext) throws Exception {
        if (this.params == null) {
            HashSet<String> paramNames = new HashSet<String>();
            int length = this.paramsTable.getHeight();
            this.params = new IParameterDeclaration[length];
            for (int i = 0; i < length; ++i) {
                ILogicalTable paramTable = (ILogicalTable)this.paramsTable.getRow(i);
                GridCellSourceCodeModule source = new GridCellSourceCodeModule(paramTable.getSource(), bindingContext);
                IParameterDeclaration parameterDeclaration = this.getParameterDeclaration(source, methodSource, signature, declaringClass, methodType, openl, bindingContext, i);
                String paramName = parameterDeclaration.getName();
                if (paramNames.contains(paramName)) {
                    throw SyntaxNodeExceptionUtils.createError((String)("Duplicated parameter name: " + paramName), (IOpenSourceCodeModule)source);
                }
                paramNames.add(paramName);
                this.params[i] = parameterDeclaration;
            }
        }
        return this.params;
    }

    private void prepareParamValues(CompositeMethod method, OpenlToolAdaptor ota, RuleRow ruleRow) throws Exception {
        int i;
        int len = this.nValues();
        IParameterDeclaration[] paramDecl = this.getParams(method.getMethodBodyBoundNode().getSyntaxNode().getModule(), method.getSignature(), method.getDeclaringClass(), method.getType(), ota.getOpenl(), ota.getBindingContext());
        boolean[] paramIndexed = this.getParamIndexed(paramDecl);
        ArrayList<SyntaxNodeException> errors = new ArrayList<SyntaxNodeException>();
        IStorageBuilder<?>[] builders = this.makeStorageBuilders(len, paramDecl);
        int actualStorageSize = this.scale.getActualSize(len);
        for (i = 0; i < actualStorageSize; ++i) {
            int ruleN = this.scale.getLogicalIndex(i);
            this.loadParamsFromColumn(ota, ruleRow, paramDecl, paramIndexed, errors, ruleN, builders);
        }
        if (errors.size() > 0) {
            throw new CompositeSyntaxNodeException("Error:", errors.toArray(new SyntaxNodeException[errors.size()]));
        }
        this.storage = new IStorage[builders.length];
        for (i = 0; i < builders.length; ++i) {
            this.storage[i] = builders[i].optimizeAndBuild();
        }
    }

    private IStorageBuilder<?>[] makeStorageBuilders(int len, IParameterDeclaration[] paramDecl) {
        int nparams = paramDecl.length;
        IStorageBuilder[] builders = new IStorageBuilder[nparams];
        for (int i = 0; i < builders.length; ++i) {
            builders[i] = StorageFactory.makeStorageBuilder(paramDecl[i], len, this.scale);
        }
        return builders;
    }

    private void loadParamsFromColumn(OpenlToolAdaptor ota, RuleRow ruleRow, IParameterDeclaration[] paramDecl, boolean[] paramIndexed, List<SyntaxNodeException> errors, int ruleN, IStorageBuilder<?>[] builders) {
        IGridTable paramGridColumn = this.getValueCell(ruleN).getSource();
        int fromHeight = 0;
        boolean executionMode = ota.getBindingContext().isExecutionMode();
        String ruleName = null;
        if (!executionMode) {
            ruleName = ruleRow == null ? "R" + (ruleN + 1) : ruleRow.getRuleName(ruleN);
        }
        for (int j = 0; j < paramDecl.length; ++j) {
            Object loadedValue;
            int gridHeight;
            block4: {
                if (paramDecl[j] == null) continue;
                gridHeight = ((ILogicalTable)this.paramsTable.getRow(j)).getSource().getHeight();
                IGridTable singleParamGridTable = (IGridTable)paramGridColumn.getRows(fromHeight, fromHeight + gridHeight - 1);
                loadedValue = null;
                try {
                    IOpenClass paramType = paramDecl[j].getType();
                    loadedValue = RuleRowHelper.loadParam(LogicalTableHelper.logicalTable(singleParamGridTable), paramType, paramDecl[j].getName(), ruleName, ota, paramIndexed[j]);
                }
                catch (SyntaxNodeException error) {
                    if (this.haveSameError(errors, error)) break block4;
                    errors.add(error);
                }
            }
            builders[j].writeObject(loadedValue, ruleN);
            fromHeight += gridHeight;
        }
    }

    private boolean haveSameError(List<SyntaxNodeException> errors, SyntaxNodeException error) {
        boolean errorAddedAlready = false;
        for (SyntaxNodeException e : errors) {
            if (!StringUtils.equals((CharSequence)e.getMessage(), (CharSequence)error.getMessage()) || e.getSourceModule() == null || error.getSourceModule() == null || !StringUtils.equals((CharSequence)e.getSourceModule().getUri(), (CharSequence)error.getSourceModule().getUri())) continue;
            errorAddedAlready = true;
            break;
        }
        return errorAddedAlready;
    }

    private boolean[] getParamIndexed(IParameterDeclaration[] paramDecl) {
        boolean[] paramIndexed = new boolean[paramDecl.length];
        for (int i = 0; i < paramIndexed.length; ++i) {
            paramIndexed[i] = paramDecl[i].getType().getAggregateInfo().isAggregate(paramDecl[i].getType());
        }
        return paramIndexed;
    }

    protected Object[] mergeParams(Object target, Object[] dtParams, IRuntimeEnv env, int ruleN) {
        if (dtParams == null) {
            dtParams = new Object[]{};
        }
        Object[] newParams = new Object[dtParams.length + this.getNumberOfParams()];
        System.arraycopy(dtParams, 0, newParams, 0, dtParams.length);
        this.loadValues(newParams, dtParams.length, ruleN, target, dtParams, env);
        return newParams;
    }

    @Override
    public ILogicalTable getValueCell(int column) {
        return (ILogicalTable)this.decisionTable.getSubtable(column + 4, this.row, 1, 1);
    }

    private int nValues() {
        return this.decisionTable.getWidth() - 4;
    }

    private String makeParamName() {
        ++this.noParamsIndex;
        return (NO_PARAM + this.noParamsIndex).intern();
    }

    protected final CompositeMethod generateMethod(IMethodSignature signature, OpenL openl, IBindingContextDelegator bindingContextDelegator, IOpenClass declaringClass, IOpenClass methodType) throws Exception {
        IOpenSourceCodeModule source = this.getExpressionSource((IBindingContext)bindingContextDelegator, openl, declaringClass, signature, methodType);
        IParameterDeclaration[] methodParams = this.getParams(source, signature, declaringClass, methodType, openl, (IBindingContext)bindingContextDelegator);
        MethodSignature newSignature = ((MethodSignature)signature).merge(methodParams);
        OpenMethodHeader methodHeader = new OpenMethodHeader(null, methodType, (IMethodSignature)newSignature, declaringClass);
        return OpenLCellExpressionsCompiler.makeMethod(openl, source, (IOpenMethodHeader)methodHeader, (IBindingContext)bindingContextDelegator);
    }

    protected IOpenSourceCodeModule getExpressionSource(IBindingContext bindingContext, OpenL openl, IOpenClass declaringClass, IMethodSignature signature, IOpenClass methodType) throws Exception {
        return new GridCellSourceCodeModule(this.codeTable.getSource(), bindingContext);
    }

    private IParameterDeclaration getParameterDeclaration(IOpenSourceCodeModule paramSource, IOpenSourceCodeModule methodSource, IMethodSignature signature, IOpenClass declaringClass, IOpenClass methodType, OpenL openl, IBindingContext bindingContext, int paramNum) throws OpenLCompilationException {
        IdentifierNode[] nodes = Tokenizer.tokenize((IOpenSourceCodeModule)paramSource, (String)" \n\r");
        if (nodes.length == 0) {
            try {
                OpenMethodHeader methodHeader = new OpenMethodHeader(null, methodType, signature, declaringClass);
                CompositeMethod method = OpenLCellExpressionsCompiler.makeMethod(openl, methodSource, (IOpenMethodHeader)methodHeader, bindingContext);
                IOpenClass type = method.getBodyType();
                if (type instanceof NullOpenClass) {
                    String message = "Cannot recognize type of local parameter for expression";
                    throw SyntaxNodeExceptionUtils.createError((String)message, null, null, (IOpenSourceCodeModule)methodSource);
                }
                String paramName = this.makeParamName();
                return new ParameterDeclaration(type, paramName);
            }
            catch (Exception ex) {
                throw SyntaxNodeExceptionUtils.createError((String)"Cannot compile expression", (Throwable)ex, null, (IOpenSourceCodeModule)methodSource);
            }
        }
        if (nodes.length > 2) {
            String errMsg = "Parameter Cell format: <type> <name>";
            throw SyntaxNodeExceptionUtils.createError((String)errMsg, null, null, (IOpenSourceCodeModule)methodSource);
        }
        String typeCode = nodes[0].getIdentifier();
        IOpenClass type = RuleRowHelper.getType(typeCode, bindingContext);
        if (type == null) {
            throw SyntaxNodeExceptionUtils.createError((String)("Type '" + typeCode + "'is not found"), (ISyntaxNode)nodes[0]);
        }
        if (!bindingContext.isExecutionMode()) {
            this.setCellMetaInfo(paramNum, type);
        }
        if (nodes.length == 1) {
            String paramName = this.makeParamName();
            return new ParameterDeclaration(type, paramName);
        }
        String name = nodes[1].getIdentifier();
        return new ParameterDeclaration(type, name);
    }

    protected void setCellMetaInfo(int paramNum, IOpenClass type) throws OpenLCompilationException {
        GridCellSourceCodeModule source;
        IdentifierNode[] paramNodes;
        IOpenClass typeForLink = type;
        while (typeForLink.getMetaInfo() == null && typeForLink.isArray()) {
            typeForLink = typeForLink.getComponentClass();
        }
        ILogicalTable table = (ILogicalTable)this.paramsTable.getRow(paramNum);
        if (table != null && (paramNodes = Tokenizer.tokenize((IOpenSourceCodeModule)(source = new GridCellSourceCodeModule(table.getSource())), (String)"[] \n\r")).length > 0) {
            RuleRowHelper.setCellMetaInfoWithNodeUsage(table, paramNodes[0], typeForLink.getMetaInfo(), NodeType.DATATYPE);
        }
    }

    public String toString() {
        return String.format("%s : %s", this.name, this.codeTable.toString());
    }

    @Override
    public Object getParamValue(int paramIndex, int ruleN) {
        return this.storage[paramIndex].getValue(ruleN);
    }

    @Override
    public boolean isEmpty(int ruleN) {
        for (int i = 0; i < this.storage.length; ++i) {
            if (this.storage[i].isSpace(ruleN)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasFormula(int ruleN) {
        if (this.storage != null) {
            for (int i = 0; i < this.storage.length; ++i) {
                if (!this.storage[i].isFormula(ruleN)) continue;
                return true;
            }
        } else {
            IGridTable paramGridColumn = this.getValueCell(ruleN).getSource();
            return RuleRowHelper.isFormula(new SimpleLogicalTable(paramGridColumn));
        }
        return false;
    }

    @Override
    public int getNumberOfRules() {
        return this.storage[0].size();
    }

    @Override
    public void loadValues(Object[] dest, int offset, int ruleN, Object target, Object[] tableParams, IRuntimeEnv env) {
        for (int i = 0; i < dest.length - offset; ++i) {
            Object value = this.storage[i].getValue(ruleN);
            if (value instanceof IOpenMethod) {
                value = ((IOpenMethod)value).invoke(target, tableParams, env);
            }
            if (value instanceof ArrayHolder) {
                value = ((ArrayHolder)value).invoke(target, tableParams, env);
            }
            dest[i + offset] = value;
        }
    }

    @Override
    public boolean hasFormulas() {
        if (this.storage != null) {
            for (int i = 0; i < this.storage.length; ++i) {
                if (this.storage[i].getInfo().getNumberOfFormulas() <= 0) continue;
                return true;
            }
        } else {
            int len = this.nValues();
            int actualStorageSize = this.scale.getActualSize(len);
            for (int i = 0; i < actualStorageSize; ++i) {
                int ruleN = this.scale.getLogicalIndex(i);
                if (!this.hasFormula(ruleN)) continue;
                return true;
            }
        }
        return false;
    }

    public StorageInfo getStorageInfo(int paramN) {
        return this.storage[paramN].getInfo();
    }

    @Override
    public boolean isEqual(int rule1, int rule2) {
        int n = this.getNumberOfParams();
        for (int i = 0; i < n; ++i) {
            if (FunctionalRow.objEquals(this.getParamValue(i, rule1), this.getParamValue(i, rule2))) continue;
            return false;
        }
        return true;
    }

    public static boolean objEquals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    @Override
    public boolean hasEmptyRules() {
        int n = this.getNumberOfParams();
        if (n == 1) {
            return this.storage[0].getInfo().getNumberOfSpaces() > 0;
        }
        boolean hasAnySpaces = false;
        for (int i = 0; i < n; ++i) {
            if (this.storage[i].getInfo().getNumberOfSpaces() <= 0) continue;
            hasAnySpaces = true;
            break;
        }
        if (!hasAnySpaces) {
            return false;
        }
        int nRules = this.getNumberOfRules();
        for (int ruleN = 0; ruleN < nRules; ++ruleN) {
            boolean allSpaces = true;
            for (int np = 0; np < n; ++np) {
                if (this.storage[np].isSpace(ruleN)) continue;
                allSpaces = false;
                break;
            }
            if (!allSpaces) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasSpecialRules() {
        int n = this.getNumberOfParams();
        for (int i = 0; i < n; ++i) {
            if (this.storage[i].getInfo().getNumberOfFormulas() <= 0 && this.storage[i].getInfo().getNumberOfElses() <= 0) continue;
            return true;
        }
        return false;
    }
}

