/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.index;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.openl.rules.dt.DecisionTableIndexedRuleNode;
import org.openl.rules.dt.DecisionTableRuleNode;
import org.openl.rules.dt.index.ARuleIndex;
import org.openl.rules.dt.type.IRangeAdaptor;

public class RangeIndex
extends ARuleIndex {
    protected List<DecisionTableIndexedRuleNode<?>> index;
    public Comparator<? super Object> comparator = null;
    protected IRangeAdaptor<?, ?> adaptor;

    public RangeIndex(DecisionTableRuleNode emptyOrFormulaNodes, List<DecisionTableIndexedRuleNode<?>> index, IRangeAdaptor<?, ?> adaptor) {
        super(emptyOrFormulaNodes);
        this.index = index;
        this.adaptor = adaptor;
    }

    @Override
    DecisionTableRuleNode findNodeInIndex(Object value) {
        int idx;
        if (this.index.isEmpty()) {
            return null;
        }
        if (this.adaptor != null) {
            value = this.adaptor.adaptValueType(value);
        }
        if ((idx = Collections.binarySearch(this.index, value, this.comparator)) >= 0) {
            return this.index.get(idx);
        }
        int insertionPoint = -(idx + 1);
        if (insertionPoint < this.index.size() && insertionPoint > 0) {
            return this.index.get(insertionPoint - 1);
        }
        return null;
    }

    public Iterable<DecisionTableIndexedRuleNode<?>> nodes() {
        return this.index;
    }
}

