/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.storage;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.apache.commons.lang3.ArrayUtils;
import org.openl.rules.dt.DTScale;
import org.openl.rules.dt.storage.IStorage;
import org.openl.rules.dt.storage.IStorageBuilder;
import org.openl.rules.dt.storage.ObjectStorageBuilder;
import org.openl.rules.dt.storage.ScaleStorageBuilder;
import org.openl.rules.dt.storage.StorageBuilder;
import org.openl.types.IParameterDeclaration;
import org.openl.types.java.JavaOpenClass;

public class StorageFactory {
    private static final Class[] integerTypes = new Class[]{Integer.TYPE, Integer.class, Byte.TYPE, Byte.class, Character.TYPE, Character.class, Short.TYPE, Short.class, Long.TYPE, Long.class, BigInteger.class, Date.class};
    private static final Class[] decimalTypes = new Class[]{Double.TYPE, Double.class, Float.TYPE, Float.class, BigDecimal.class};

    public IStorage makeStorage(JavaOpenClass type, int size, Object min, Object max, int decimalPlaces, int nSpaces, int nElses, int nFormulas) {
        JavaOpenClass type2 = JavaOpenClass.OBJECT;
        if (this.isInteger(type)) {
            type2 = this.selectInteger(min, max, nSpaces + nElses + nFormulas);
        }
        return null;
    }

    private JavaOpenClass selectInteger(Object min, Object max, int nSpecialCases) {
        return null;
    }

    private boolean isInteger(JavaOpenClass type) {
        Class c = type.getInstanceClass();
        return ArrayUtils.contains((Object[])integerTypes, (Object)c);
    }

    public static IStorageBuilder makeStorageBuilder(IParameterDeclaration iParameterDeclaration, int size, DTScale.RowScale scale) {
        int newSize = scale.getActualSize(size);
        StorageBuilder sb = StorageFactory.makeStorageBuilder(iParameterDeclaration, newSize);
        if (newSize == size) {
            return sb;
        }
        return new ScaleStorageBuilder(scale, sb);
    }

    private static StorageBuilder makeStorageBuilder(IParameterDeclaration iParameterDeclaration, int size) {
        return new ObjectStorageBuilder(size);
    }
}

