/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.type;

import org.openl.rules.dt.type.IRangeAdaptor;
import org.openl.rules.helpers.IntRange;

public final class IntRangeAdaptor
implements IRangeAdaptor<IntRange, Integer> {
    private static final IntRangeAdaptor INSTANCE = new IntRangeAdaptor();

    private IntRangeAdaptor() {
    }

    public static IRangeAdaptor<IntRange, Integer> getInstance() {
        return INSTANCE;
    }

    @Override
    public Integer getMax(IntRange range) {
        int max = range.getMax();
        if (max != Integer.MAX_VALUE) {
            ++max;
        }
        return max;
    }

    @Override
    public Integer getMin(IntRange range) {
        return range.getMin();
    }

    @Override
    public Integer adaptValueType(Object value) {
        if (value == null) {
            return null;
        }
        return ((Number)value).intValue();
    }

    @Override
    public boolean useOriginalSource() {
        return false;
    }

    @Override
    public Class<?> getIndexType() {
        return Integer.class;
    }
}

