/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.type.domains;

import java.lang.reflect.Array;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openl.domain.EnumDomain;
import org.openl.rules.dt.type.domains.EnumDomainAdaptor;
import org.openl.rules.dt.type.domains.IDomainAdaptor;
import org.openl.rules.dt.type.domains.IDomainCollector;
import org.openl.rules.table.properties.def.TablePropertyDefinitionUtils;

public class ArrayDomainCollector
implements IDomainCollector {
    private String propertyToSearch;
    private Set<Object> arrayEnumProperties = new HashSet<Object>();

    public ArrayDomainCollector(String propertyToSearch) {
        this.propertyToSearch = propertyToSearch;
    }

    @Override
    public void gatherDomains(Map<String, Object> methodProperties) {
        Object[] propValues;
        if (methodProperties != null && (propValues = (Object[])methodProperties.get(this.propertyToSearch)) != null) {
            for (Object propValue : propValues) {
                if (propValue == null) continue;
                this.arrayEnumProperties.add(propValue);
            }
        }
    }

    @Override
    public IDomainAdaptor getGatheredDomain() {
        EnumDomainAdaptor result = null;
        if (!this.arrayEnumProperties.isEmpty()) {
            Class<?> propertyType = TablePropertyDefinitionUtils.getPropertyTypeByPropertyName(this.propertyToSearch);
            Class<?> componentType = propertyType.getComponentType();
            Object[] resultArray = (Object[])Array.newInstance(componentType, this.arrayEnumProperties.size());
            EnumDomain enumDomain = new EnumDomain(this.arrayEnumProperties.toArray(resultArray));
            result = new EnumDomainAdaptor(enumDomain);
        }
        return result;
    }

    public int getNumberOfDomainElements() {
        return this.arrayEnumProperties.size();
    }
}

