/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.type.domains;

import java.util.HashSet;
import org.openl.domain.EnumDomain;
import org.openl.rules.dt.type.domains.IDomainAdaptor;

public class EnumDomainAdaptor
implements IDomainAdaptor {
    private Object[] values;

    public EnumDomainAdaptor(EnumDomain<?> domain) {
        this.values = domain.getEnum().getAllObjects();
    }

    public EnumDomainAdaptor(Object[] values) {
        this.values = values;
    }

    @Override
    public int getIndex(Object value) {
        for (int i = 0; i < this.values.length; ++i) {
            if (!this.values[i].equals(value)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getIntVarDomainType() {
        return 1;
    }

    @Override
    public int getMax() {
        return this.values.length - 1;
    }

    @Override
    public int getMin() {
        return 0;
    }

    @Override
    public Object getValue(int index) {
        return this.values[index];
    }

    public Object[] getValues() {
        return this.values;
    }

    public void setValues(Object[] values) {
        this.values = values;
    }

    public int size() {
        return this.values.length;
    }

    @Override
    public IDomainAdaptor merge(IDomainAdaptor adaptor) {
        int i;
        EnumDomainAdaptor a = (EnumDomainAdaptor)adaptor;
        Object[] v1 = this.getValues();
        Object[] v2 = a.getValues();
        HashSet<Object> set = new HashSet<Object>(v1.length + v2.length);
        for (i = 0; i < v1.length; ++i) {
            set.add(v1[i]);
        }
        for (i = 0; i < v2.length; ++i) {
            set.add(v2[i]);
        }
        Object[] newValues = set.toArray();
        return new EnumDomainAdaptor(new EnumDomain(newValues));
    }
}

