/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.validator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.impl.module.ModuleBindingContext;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.engine.OpenLManager;
import org.openl.exception.OpenLRuntimeException;
import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.IntBoolExp;
import org.openl.ie.constrainer.IntBoolExpConst;
import org.openl.ie.constrainer.IntExpArray;
import org.openl.ie.constrainer.IntVar;
import org.openl.ie.constrainer.consistencyChecking.CDecisionTable;
import org.openl.ie.constrainer.consistencyChecking.DTCheckerImpl;
import org.openl.ie.constrainer.consistencyChecking.Overlapping;
import org.openl.ie.constrainer.consistencyChecking.Uncovered;
import org.openl.rules.dt.IBaseCondition;
import org.openl.rules.dt.IDecisionTable;
import org.openl.rules.dt.validator.DecisionTableAnalyzer;
import org.openl.rules.dt.validator.DecisionTableParamDescription;
import org.openl.rules.dt.validator.DecisionTableValidationResult;
import org.openl.rules.dt.validator.IDecisionTableValidatedObject;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.IParameterDeclaration;
import org.openl.types.impl.MethodSignature;
import org.openl.types.impl.OpenMethodHeader;
import org.openl.types.impl.ParameterDeclaration;
import org.openl.types.java.JavaOpenClass;

public class ValidationAlgorithm {
    private IDecisionTableValidatedObject decisionTableToValidate;
    private IntExpArray vars;
    private OpenL openl;
    private Constrainer constrainer = new Constrainer("Validation");

    public ValidationAlgorithm(IDecisionTableValidatedObject validatedObject, OpenL openl) {
        this.decisionTableToValidate = validatedObject;
        this.openl = openl;
    }

    public DecisionTableValidationResult validate() {
        IDecisionTable decisionTable = this.decisionTableToValidate.getDecisionTable();
        DecisionTableAnalyzer analyzer = new DecisionTableAnalyzer(decisionTable);
        DecisionTableValidationResult result = null;
        if (this.canValidateDecisionTable(decisionTable, analyzer)) {
            int n = decisionTable.getNumberOfConditions();
            IOpenMethod[] methodsForConditionValidation = new IOpenMethod[n];
            for (int i = 0; i < n; ++i) {
                methodsForConditionValidation[i] = this.makeConditionMethod(decisionTable.getConditionRows()[i], analyzer);
            }
            this.vars = this.makeVars(analyzer);
            IntBoolExp[][] expressions = this.makeExpressions(analyzer, methodsForConditionValidation);
            DTCheckerImpl.CDecisionTableImpl cdt = new DTCheckerImpl.CDecisionTableImpl(expressions, this.vars, this.decisionTableToValidate.isOverrideAscending());
            DTCheckerImpl tableChecker = new DTCheckerImpl((CDecisionTable)cdt);
            List completeness = tableChecker.checkCompleteness();
            List overlappings = tableChecker.checkOverlappings();
            result = new DecisionTableValidationResult(decisionTable, overlappings.toArray(new Overlapping[overlappings.size()]), completeness.toArray(new Uncovered[completeness.size()]), this.decisionTableToValidate.getTransformer(), analyzer);
        } else {
            result = new DecisionTableValidationResult(decisionTable);
        }
        return result;
    }

    private boolean canValidateDecisionTable(IDecisionTable decisionTable, DecisionTableAnalyzer analyzer) {
        int ncond = decisionTable.getNumberOfConditions();
        if (ncond == 0) {
            return false;
        }
        for (int i = 0; i < ncond; ++i) {
            if (!analyzer.containsFormula(decisionTable.getConditionRows()[i])) continue;
            return false;
        }
        return true;
    }

    private Object findVar(IntExpArray vars, String name) {
        for (int i = 0; i < vars.size(); ++i) {
            if (!vars.elementAt(i).name().equals(name)) continue;
            return vars.elementAt(i);
        }
        return null;
    }

    private IOpenMethod makeConditionMethod(IBaseCondition condition, DecisionTableAnalyzer analyzer) {
        IMethodSignature newSignature = this.getNewSignature(condition, analyzer);
        JavaOpenClass methodType = JavaOpenClass.getOpenClass(IntBoolExp.class);
        IOpenClass declaringClass = analyzer.getDecisionTable().getDeclaringClass();
        String conditionName = condition.getName();
        OpenMethodHeader methodHeader = new OpenMethodHeader(conditionName, (IOpenClass)methodType, newSignature, declaringClass);
        ModuleBindingContext bindingContext = new ModuleBindingContext(this.openl.getBinder().makeBindingContext(), (ModuleOpenClass)declaringClass);
        IOpenSourceCodeModule formulaSourceCode = condition.getConditionEvaluator().getFormalSourceCode(condition);
        return OpenLManager.makeMethod((OpenL)this.openl, (IOpenSourceCodeModule)formulaSourceCode, (IOpenMethodHeader)methodHeader, (IBindingContext)bindingContext);
    }

    private IMethodSignature getNewSignature(IBaseCondition condition, DecisionTableAnalyzer analyzer) {
        IParameterDeclaration[] paramDeclarations = condition.getParams();
        IParameterDeclaration[] referencedSignatureParams = analyzer.referencedSignatureParams(condition);
        return this.makeSignatureForCondition(paramDeclarations, referencedSignatureParams, analyzer);
    }

    private IntBoolExp[][] makeExpressions(DecisionTableAnalyzer analyzer, IOpenMethod[] methodsForConditionValidation) {
        int rulesNumber = this.decisionTableToValidate.getDecisionTable().getNumberOfRules();
        IntBoolExp[][] expressions = new IntBoolExp[rulesNumber][methodsForConditionValidation.length];
        for (int i = 0; i < rulesNumber; ++i) {
            IntBoolExp[] ruleExpression = new IntBoolExp[methodsForConditionValidation.length];
            expressions[i] = ruleExpression;
            for (int j = 0; j < methodsForConditionValidation.length; ++j) {
                ruleExpression[j] = this.makeExpression(i, this.decisionTableToValidate.getDecisionTable().getConditionRows()[j], analyzer, methodsForConditionValidation[j]);
            }
        }
        return expressions;
    }

    private IntBoolExp makeExpression(int ruleN, IBaseCondition conditionToValidate, DecisionTableAnalyzer analyzer, IOpenMethod methodForConditionValidation) {
        if (conditionToValidate.isEmpty(ruleN)) {
            return new IntBoolExpConst(this.constrainer, true);
        }
        int paramsNum = methodForConditionValidation.getSignature().getNumberOfParameters();
        Object[] args = new Object[paramsNum];
        int tableArgsCount = paramsNum - conditionToValidate.getNumberOfParams();
        for (int i = 0; i < paramsNum; ++i) {
            String name = methodForConditionValidation.getSignature().getParameterName(i);
            args[i] = i < tableArgsCount ? this.findVar(this.vars, name) : this.transformValue(name, conditionToValidate, conditionToValidate.getParamValue(i - tableArgsCount, ruleN), analyzer);
        }
        return (IntBoolExp)methodForConditionValidation.invoke(null, args, this.openl.getVm().getRuntimeEnv());
    }

    private IMethodSignature makeSignatureForCondition(IParameterDeclaration[] paramDeclarations, IParameterDeclaration[] referencedSignatureParams, DecisionTableAnalyzer analyzer) {
        ArrayList<IParameterDeclaration> parameters = new ArrayList<IParameterDeclaration>();
        parameters.addAll(this.getTransformedSignatureParams(referencedSignatureParams, analyzer));
        parameters.addAll(this.getTransformedLocalParams(paramDeclarations));
        return new MethodSignature(parameters.toArray(new IParameterDeclaration[parameters.size()]));
    }

    private List<IParameterDeclaration> getTransformedLocalParams(IParameterDeclaration[] paramDeclarations) {
        ArrayList<IParameterDeclaration> transformeedParameters = new ArrayList<IParameterDeclaration>();
        for (IParameterDeclaration paramDeclaration : paramDeclarations) {
            IOpenClass newType = this.decisionTableToValidate.getTransformer().transformParameterType(paramDeclaration);
            if (newType == null) {
                transformeedParameters.add(paramDeclaration);
                continue;
            }
            ParameterDeclaration parameter = new ParameterDeclaration(newType, paramDeclaration.getName());
            transformeedParameters.add((IParameterDeclaration)parameter);
        }
        return transformeedParameters;
    }

    private List<IParameterDeclaration> getTransformedSignatureParams(IParameterDeclaration[] referencedSignatureParams, DecisionTableAnalyzer analyzer) {
        ArrayList<IParameterDeclaration> parameters = new ArrayList<IParameterDeclaration>();
        for (IParameterDeclaration paramDeclarationFromSignature : referencedSignatureParams) {
            IOpenClass newType = analyzer.transformSignatureType(paramDeclarationFromSignature, this.decisionTableToValidate);
            if (newType == null) {
                newType = paramDeclarationFromSignature.getType();
            }
            ParameterDeclaration parameter = new ParameterDeclaration(newType, paramDeclarationFromSignature.getName());
            parameters.add((IParameterDeclaration)parameter);
        }
        return parameters;
    }

    private IntExpArray makeVars(DecisionTableAnalyzer analyzer) {
        ArrayList<IntVar> vars = new ArrayList<IntVar>();
        Iterator<DecisionTableParamDescription> iterator = analyzer.tableParams();
        while (iterator.hasNext()) {
            DecisionTableParamDescription paramDescriptor = iterator.next();
            String varName = paramDescriptor.getParameterDeclaration().getName();
            IOpenClass varType = paramDescriptor.getParameterDeclaration().getType();
            IntVar var = this.decisionTableToValidate.getTransformer().makeSignatureVar(varName, varType, this.constrainer);
            if (var != null) {
                vars.add(var);
                continue;
            }
            throw new OpenLRuntimeException(String.format("Could not create domain for %s", varName));
        }
        return new IntExpArray(this.constrainer, vars);
    }

    private Object transformValue(String name, IBaseCondition condition, Object value, DecisionTableAnalyzer analyzer) {
        return this.decisionTableToValidate.getTransformer().transformLocalParameterValue(name, condition, value, analyzer);
    }
}

