/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.fuzzy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openl.rules.fuzzy.Token;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;

public final class OpenLFuzzySearch {
    private static final double ACCEPTABLE_SIMILARITY_VALUE = 0.85;
    private static final int DEEP_LEVEL = 5;
    public static ThreadLocal<Map<IOpenClass, Map<Token, IOpenMethod[][]>>> openlClassRecursivelyCacheForSetterMethods = new ThreadLocal<Map<IOpenClass, Map<Token, IOpenMethod[][]>>>(){

        @Override
        protected Map<IOpenClass, Map<Token, IOpenMethod[][]>> initialValue() {
            return new HashMap<IOpenClass, Map<Token, IOpenMethod[][]>>();
        }
    };
    public static ThreadLocal<Map<IOpenClass, Map<Token, IOpenMethod[]>>> openlClassCacheForSetterMethods = new ThreadLocal<Map<IOpenClass, Map<Token, IOpenMethod[]>>>(){

        @Override
        protected Map<IOpenClass, Map<Token, IOpenMethod[]>> initialValue() {
            return new HashMap<IOpenClass, Map<Token, IOpenMethod[]>>();
        }
    };

    public static void clearCaches() {
        openlClassCacheForSetterMethods.remove();
        openlClassRecursivelyCacheForSetterMethods.remove();
    }

    public static Map<Token, IOpenMethod[]> tokensMapToOpenClassSetterMethods(IOpenClass openClass) {
        Map<IOpenClass, Map<Token, IOpenMethod[]>> cache = openlClassCacheForSetterMethods.get();
        Map<Token, IOpenMethod[]> ret = cache.get(openClass);
        if (ret == null) {
            ret = new HashMap<Token, IOpenMethod[]>();
            HashMap<Token, LinkedList<IOpenMethod>> map = new HashMap<Token, LinkedList<IOpenMethod>>();
            if (!openClass.isSimple()) {
                for (IOpenMethod iOpenMethod : openClass.getMethods()) {
                    if (iOpenMethod.isStatic() || iOpenMethod.getSignature().getNumberOfParameters() != 1 || !iOpenMethod.getName().startsWith("set")) continue;
                    String t = OpenLFuzzySearch.toTokenString(iOpenMethod.getName().substring(3));
                    LinkedList<IOpenMethod> m = (LinkedList<IOpenMethod>)map.get(t);
                    if (m == null) {
                        m = new LinkedList<IOpenMethod>();
                        m.add(iOpenMethod);
                        map.put(new Token(t, 0), m);
                        continue;
                    }
                    m.add(iOpenMethod);
                }
            }
            for (Map.Entry entry : map.entrySet()) {
                ret.put((Token)entry.getKey(), ((LinkedList)entry.getValue()).toArray(new IOpenMethod[0]));
            }
            cache.put(openClass, ret);
        }
        return ret;
    }

    public static Map<Token, IOpenMethod[][]> tokensMapToOpenClassSetterMethodsRecursively(IOpenClass openClass) {
        Map<IOpenClass, Map<Token, IOpenMethod[][]>> cache = openlClassRecursivelyCacheForSetterMethods.get();
        Map<Token, IOpenMethod[][]> ret = cache.get(openClass);
        if (ret == null) {
            HashMap<String, Integer> distanceMap = new HashMap<String, Integer>();
            Map<Token, LinkedList<LinkedList<IOpenMethod>>> map = OpenLFuzzySearch.buildTokensMapToOpenClassSetterMethodsRecursively(openClass, distanceMap, 0);
            HashMap<Token, LinkedList[]> tmp = new HashMap<Token, LinkedList[]>();
            for (Map.Entry<Token, LinkedList<LinkedList<IOpenMethod>>> entry : map.entrySet()) {
                tmp.put(entry.getKey(), entry.getValue().toArray(new LinkedList[0]));
            }
            ret = new HashMap<Token, IOpenMethod[][]>();
            for (Map.Entry<Token, LinkedList<LinkedList<Object>>> entry : tmp.entrySet()) {
                IOpenMethod[][] m = new IOpenMethod[((LinkedList[])entry.getValue()).length][];
                int i = 0;
                for (LinkedList x : (LinkedList[])entry.getValue()) {
                    m[i] = x.toArray(new IOpenMethod[0]);
                    ++i;
                }
                ret.put(entry.getKey(), m);
            }
            cache.put(openClass, ret);
        }
        return ret;
    }

    private static boolean isSetterMethod(IOpenMethod method) {
        return !method.isStatic() && method.getSignature().getNumberOfParameters() == 1 && method.getName().startsWith("set");
    }

    private static Map<Token, LinkedList<LinkedList<IOpenMethod>>> buildTokensMapToOpenClassSetterMethodsRecursively(IOpenClass openClass, Map<String, Integer> distanceMap, int deepLevel) {
        if (deepLevel >= 5) {
            return Collections.emptyMap();
        }
        HashMap<Token, LinkedList<LinkedList<IOpenMethod>>> ret = new HashMap<Token, LinkedList<LinkedList<IOpenMethod>>>();
        if (!openClass.isSimple()) {
            for (IOpenMethod method : openClass.getMethods()) {
                if (!OpenLFuzzySearch.isSetterMethod(method)) continue;
                String t = OpenLFuzzySearch.toTokenString(method.getName().substring(3));
                LinkedList<IOpenMethod> methods = new LinkedList<IOpenMethod>();
                methods.add(method);
                LinkedList<LinkedList<IOpenMethod>> x = (LinkedList<LinkedList<IOpenMethod>>)ret.get(t);
                if (x == null) {
                    x = new LinkedList<LinkedList<IOpenMethod>>();
                    ret.put(new Token(t, deepLevel), x);
                    x.add(methods);
                    distanceMap.put(t, deepLevel);
                } else {
                    Integer d = distanceMap.get(t);
                    if (d == null || d == deepLevel) {
                        x.add(methods);
                    } else if (d < deepLevel) {
                        x.clear();
                        x.add(methods);
                        distanceMap.put(t, deepLevel);
                    }
                }
                if (method.getSignature().getParameterType(0).isSimple() || method.getSignature().getParameterType(0).isArray()) continue;
                Map<Token, LinkedList<LinkedList<IOpenMethod>>> map = OpenLFuzzySearch.buildTokensMapToOpenClassSetterMethodsRecursively(method.getSignature().getParameterType(0), distanceMap, deepLevel + 1);
                for (Map.Entry<Token, LinkedList<LinkedList<IOpenMethod>>> entry : map.entrySet()) {
                    String k = t + " " + entry.getKey().getValue();
                    LinkedList<LinkedList> x1 = (LinkedList<LinkedList>)ret.get(k);
                    for (LinkedList linkedList : entry.getValue()) {
                        linkedList.addFirst(method);
                        if (x1 == null) {
                            x1 = new LinkedList<LinkedList>();
                            x1.add(linkedList);
                            ret.put(new Token(k, entry.getKey().getDistance() + 1), x1);
                            distanceMap.put(k, entry.getKey().getDistance() + 1);
                            continue;
                        }
                        Integer d = distanceMap.get(k);
                        if (d == null || d == entry.getKey().getDistance() + 1) {
                            x1.add(linkedList);
                            continue;
                        }
                        if (d >= entry.getKey().getDistance() + 1) continue;
                        x1.clear();
                        x1.add(linkedList);
                        distanceMap.put(k, entry.getKey().getDistance() + 1);
                    }
                }
            }
        }
        return ret;
    }

    private static String[] concatTokens(String[] tokens, String pattern) {
        ArrayList<String> t = new ArrayList<String>();
        StringBuilder sbBuilder = new StringBuilder();
        boolean g = false;
        for (String s : tokens) {
            if (s.length() == 1 && s.matches(pattern)) {
                g = true;
                sbBuilder.append(s);
                continue;
            }
            if (g) {
                t.add(sbBuilder.toString());
                g = false;
                sbBuilder = new StringBuilder();
            }
            t.add(s);
        }
        if (g) {
            t.add(sbBuilder.toString());
        }
        return t.toArray(new String[0]);
    }

    private static String[] cleanUpTokens(String[] tokens) {
        ArrayList<String> t = new ArrayList<String>();
        for (String token : tokens) {
            String s = token.trim().toLowerCase();
            if (s.isEmpty()) continue;
            boolean f = false;
            for (int i = 0; i < s.length(); ++i) {
                if (Character.isLetterOrDigit(s.charAt(i))) continue;
                f = true;
                break;
            }
            if (f) continue;
            t.add(token);
        }
        return t.toArray(new String[0]);
    }

    public static String toTokenString(String source) {
        if (source == null) {
            return "";
        }
        String[] tokens = source.split("(?<=.)(?=\\p{Lu}|\\d|\\s|[_])");
        tokens = OpenLFuzzySearch.concatTokens(tokens, "\\p{Lu}+");
        tokens = OpenLFuzzySearch.concatTokens(tokens, "\\d+");
        tokens = OpenLFuzzySearch.cleanUpTokens(tokens);
        StringBuilder sb = new StringBuilder();
        boolean f = false;
        for (String s : tokens) {
            if (!f) {
                f = true;
            } else {
                sb.append(" ");
            }
            sb.append(s.trim().toLowerCase());
        }
        return sb.toString();
    }

    public static Token[] openlFuzzyExtract(String source, Token[] tokens) {
        int i;
        String[] sourceTokens = source.split(" ");
        String[][] tokensList = new String[tokens.length][];
        for (int i2 = 0; i2 < tokens.length; ++i2) {
            tokensList[i2] = tokens[i2].getValue().split(" ");
        }
        Object[] sortedSourceTokens = new String[sourceTokens.length];
        System.arraycopy(sourceTokens, 0, sortedSourceTokens, 0, sourceTokens.length);
        Arrays.sort(sortedSourceTokens);
        int[] f = new int[tokensList.length];
        int max = 0;
        for (int i3 = 0; i3 < tokensList.length; ++i3) {
            Object[] sortedTokens = new String[tokensList[i3].length];
            System.arraycopy(tokensList[i3], 0, sortedTokens, 0, tokensList[i3].length);
            Arrays.sort(sortedTokens);
            int l = 0;
            int r = 0;
            int c = 0;
            while (l < sortedSourceTokens.length && r < sortedTokens.length) {
                double d = StringUtils.getJaroWinklerDistance((CharSequence)sortedSourceTokens[l], (CharSequence)sortedTokens[r]);
                if (d > 0.85) {
                    ++l;
                    ++r;
                    ++c;
                    continue;
                }
                if (((String)sortedSourceTokens[l]).compareTo((String)sortedTokens[r]) < 0) {
                    ++l;
                    continue;
                }
                ++r;
            }
            if (max < c) {
                max = c;
            }
            f[i3] = c;
        }
        if (max == 0) {
            return new Token[0];
        }
        int min = Integer.MAX_VALUE;
        int minDistance = Integer.MAX_VALUE;
        for (int i4 = 0; i4 < tokensList.length; ++i4) {
            if (f[i4] != max) continue;
            if (min > tokensList[i4].length - f[i4]) {
                min = tokensList[i4].length - f[i4];
            }
            if (minDistance <= tokens[i4].getDistance()) continue;
            minDistance = tokens[i4].getDistance();
        }
        int count = 0;
        for (i = 0; i < tokensList.length; ++i) {
            if (f[i] != max || tokensList[i].length - f[i] != min || tokens[i].getDistance() != minDistance) continue;
            ++count;
        }
        if (count == 0) {
            return new Token[0];
        }
        if (count == 1) {
            for (i = 0; i < tokensList.length; ++i) {
                if (f[i] != max || tokensList[i].length - f[i] != min || tokens[i].getDistance() != minDistance) continue;
                return new Token[]{tokens[i]};
            }
        } else {
            ArrayList<Token> ret = new ArrayList<Token>();
            int best = 0;
            for (int i5 = 0; i5 < tokensList.length; ++i5) {
                if (f[i5] != max || tokensList[i5].length - f[i5] != min) continue;
                int d = StringUtils.getFuzzyDistance((CharSequence)tokens[i5].getValue(), (CharSequence)source, (Locale)Locale.ENGLISH);
                if (d > best) {
                    best = d;
                    ret.clear();
                    ret.add(tokens[i5]);
                    continue;
                }
                if (d != best) continue;
                ret.add(tokens[i5]);
            }
            return ret.toArray(new Token[0]);
        }
        return new Token[0];
    }
}

