/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.helpers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openl.rules.helpers.BExGrammarParser;
import org.openl.rules.helpers.BaseRangeParser;
import org.openl.rules.helpers.RangeParser;
import org.openl.source.SourceType;
import org.openl.util.RangeWithBounds;
import org.openl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoubleRangeParser {
    protected static final BExGrammarParser FALLBACK_PARSER = new BExGrammarParser(SourceType.DOUBLE_RANGE);
    private static final DoubleRangeParser INSTANCE = new DoubleRangeParser();
    protected final RangeParser[] PARSERS = new RangeParser[]{new SimpleRangeParser(), new RangeWithBracketsParser(), new PrefixRangeParser(), new SuffixRangeParser(), new NumberParser(), new RangeWithMoreLessSymbolsParser(), new VerboseRangeParser()};

    protected DoubleRangeParser() {
    }

    public static DoubleRangeParser getInstance() {
        return INSTANCE;
    }

    public RangeWithBounds parse(String range) {
        try {
            range = range.trim();
            for (RangeParser parser : this.PARSERS) {
                RangeWithBounds value = parser.parse(range);
                if (value == null) continue;
                return value;
            }
        }
        catch (RuntimeException e) {
            Logger log = LoggerFactory.getLogger(RangeWithBounds.class);
            log.error(e.getMessage(), (Throwable)e);
        }
        return FALLBACK_PARSER.parse(range);
    }

    private static final class VerboseRangeParser
    extends BaseRangeParser {
        private static final Pattern PATTERN = Pattern.compile("(less than|more than)?\\s*\\$?(-?[,\\d]+\\.?\\d*)([KMB]?)\\s*(and more|or less)?\\s*(less than|more than)?\\s*\\$?(-?[,\\d]+\\.?\\d*)([KMB]?)\\s*(and more|or less)?");

        private VerboseRangeParser() {
        }

        @Override
        public RangeWithBounds parse(String range) {
            Matcher matcher = PATTERN.matcher(range);
            if (!matcher.matches()) {
                return null;
            }
            this.minNumber = matcher.group(2);
            this.minMultiplier = matcher.group(3);
            double first = this.parseDoubleWithMultiplier(this.minNumber, this.minMultiplier);
            this.maxNumber = matcher.group(6);
            this.maxMultiplier = matcher.group(7);
            double second = this.parseDoubleWithMultiplier(this.maxNumber, this.maxMultiplier);
            String firstBound1 = matcher.group(1);
            String firstBound2 = matcher.group(4);
            String secondBound1 = matcher.group(5);
            String secondBound2 = matcher.group(8);
            String firstBound = this.mergeBoundParts(firstBound1, firstBound2);
            String secondBound = this.mergeBoundParts(secondBound1, secondBound2);
            if (StringUtils.isEmpty((CharSequence)firstBound) || StringUtils.isEmpty((CharSequence)secondBound)) {
                return null;
            }
            firstBound = this.replaceVerboseToSymbol(firstBound);
            secondBound = this.replaceVerboseToSymbol(secondBound);
            return this.getRangeWithBounds(first, second, firstBound, secondBound);
        }

        private String replaceVerboseToSymbol(String bound) {
            return bound.replace("less than", "<").replace("more than", ">").replace("or less", "<=").replace("and more", ">=");
        }

        private String mergeBoundParts(String part1, String part2) {
            if (StringUtils.isNotEmpty((CharSequence)part1) && StringUtils.isNotEmpty((CharSequence)part2)) {
                return null;
            }
            return StringUtils.isEmpty((CharSequence)part1) ? part2 : part1;
        }
    }

    private static final class RangeWithMoreLessSymbolsParser
    extends BaseRangeParser {
        private static final Pattern PATTERN = Pattern.compile("(<=?|>=?)\\s*\\$?(-?[,\\d]+\\.?\\d*)([KMB]?)\\s*(<=?|>=?)\\s*\\$?(-?[,\\d]+\\.?\\d*)([KMB]?)");

        private RangeWithMoreLessSymbolsParser() {
        }

        @Override
        public RangeWithBounds parse(String range) {
            Matcher matcher = PATTERN.matcher(range);
            if (!matcher.matches()) {
                return null;
            }
            this.minNumber = matcher.group(2);
            this.minMultiplier = matcher.group(3);
            double first = this.parseDoubleWithMultiplier(this.minNumber, this.minMultiplier);
            this.maxNumber = matcher.group(5);
            this.maxMultiplier = matcher.group(6);
            double second = this.parseDoubleWithMultiplier(this.maxNumber, this.maxMultiplier);
            String firstBound = matcher.group(1);
            String secondBound = matcher.group(4);
            return this.getRangeWithBounds(first, second, firstBound, secondBound);
        }
    }

    private static final class RangeWithBracketsParser
    extends BaseRangeParser {
        private static final Pattern PATTERN = Pattern.compile("([\\[\\(])\\s*\\$?(-?[,\\d]+\\.?\\d*)([KMB]?)\\s*([-;\u2026]|\\.\\.\\.?)\\s*\\$?(-?[,\\d]+\\.?\\d*)([KMB]?)\\s*([\\]\\)])");

        private RangeWithBracketsParser() {
        }

        @Override
        public RangeWithBounds parse(String range) {
            Matcher matcher = PATTERN.matcher(range);
            if (!matcher.matches()) {
                return null;
            }
            this.minNumber = matcher.group(2);
            this.minMultiplier = matcher.group(3);
            this.maxNumber = matcher.group(5);
            this.maxMultiplier = matcher.group(6);
            double min = this.parseDoubleWithMultiplier(this.minNumber, this.minMultiplier);
            double max = this.parseDoubleWithMultiplier(this.maxNumber, this.maxMultiplier);
            RangeWithBounds.BoundType minBound = "[".equals(matcher.group(1)) ? RangeWithBounds.BoundType.INCLUDING : RangeWithBounds.BoundType.EXCLUDING;
            RangeWithBounds.BoundType maxBound = "]".equals(matcher.group(7)) ? RangeWithBounds.BoundType.INCLUDING : RangeWithBounds.BoundType.EXCLUDING;
            return new RangeWithBounds((Number)min, (Number)max, minBound, maxBound);
        }
    }

    private static final class SimpleRangeParser
    extends BaseRangeParser {
        private static final Pattern PATTERN = Pattern.compile("\\$?(-?[,\\d]+\\.?\\d*)([KMB]?)\\s*([-;\u2026]|\\.\\.\\.?)\\s*\\$?(-?[,\\d]+\\.?\\d*)([KMB]?)");

        private SimpleRangeParser() {
        }

        @Override
        public RangeWithBounds parse(String range) {
            Matcher matcher = PATTERN.matcher(range);
            if (!matcher.matches()) {
                return null;
            }
            this.minNumber = matcher.group(1);
            this.minMultiplier = matcher.group(2);
            double min = this.parseDoubleWithMultiplier(this.minNumber, this.minMultiplier);
            String separator = matcher.group(3);
            this.maxNumber = matcher.group(4);
            this.maxMultiplier = matcher.group(5);
            double max = this.parseDoubleWithMultiplier(this.maxNumber, this.maxMultiplier);
            RangeWithBounds.BoundType boundType = "\u2026".equals(separator) || "...".equals(separator) ? RangeWithBounds.BoundType.EXCLUDING : RangeWithBounds.BoundType.INCLUDING;
            return new RangeWithBounds((Number)min, (Number)max, boundType, boundType);
        }
    }

    private static final class SuffixRangeParser
    extends BaseRangeParser {
        private static final Pattern PATTERN = Pattern.compile("\\$?(-?[,\\d]+\\.?\\d*)([KMB]?)\\s*(\\+|and more|or less)");

        private SuffixRangeParser() {
        }

        @Override
        public RangeWithBounds parse(String range) {
            Matcher matcher = PATTERN.matcher(range);
            if (!matcher.matches()) {
                return null;
            }
            String number = matcher.group(1);
            String multiplier = matcher.group(2);
            double value = this.parseDoubleWithMultiplier(number, multiplier);
            String suffix = matcher.group(3);
            if ("or less".equals(suffix)) {
                this.maxNumber = number;
                this.maxMultiplier = multiplier;
                return new RangeWithBounds(this.getMin(value), (Number)value, RangeWithBounds.BoundType.INCLUDING, RangeWithBounds.BoundType.INCLUDING);
            }
            this.minNumber = number;
            this.minMultiplier = multiplier;
            return new RangeWithBounds((Number)value, this.getMax(value), RangeWithBounds.BoundType.INCLUDING, RangeWithBounds.BoundType.INCLUDING);
        }
    }

    private static final class PrefixRangeParser
    extends BaseRangeParser {
        private static final Pattern PATTERN = Pattern.compile("(<=?|>=?|less than|more than)\\s*\\$?(-?[,\\d]+\\.?\\d*)([KMB]?)");

        private PrefixRangeParser() {
        }

        @Override
        public RangeWithBounds parse(String range) {
            Matcher matcher = PATTERN.matcher(range);
            if (!matcher.matches()) {
                return null;
            }
            String prefix = matcher.group(1);
            String number = matcher.group(2);
            String multiplier = matcher.group(3);
            double value = this.parseDoubleWithMultiplier(number, multiplier);
            if ("<".equals(prefix) || "less than".equals(prefix)) {
                this.maxNumber = number;
                this.maxMultiplier = multiplier;
                return new RangeWithBounds(this.getMin(value), (Number)value, RangeWithBounds.BoundType.INCLUDING, RangeWithBounds.BoundType.EXCLUDING);
            }
            if ("<=".equals(prefix)) {
                this.maxNumber = number;
                this.maxMultiplier = multiplier;
                return new RangeWithBounds(this.getMin(value), (Number)value, RangeWithBounds.BoundType.INCLUDING, RangeWithBounds.BoundType.INCLUDING);
            }
            if (">".equals(prefix) || "more than".equals(prefix)) {
                this.minNumber = number;
                this.minMultiplier = multiplier;
                return new RangeWithBounds((Number)value, this.getMax(value), RangeWithBounds.BoundType.EXCLUDING, RangeWithBounds.BoundType.INCLUDING);
            }
            if (">=".equals(prefix)) {
                this.minNumber = number;
                this.minMultiplier = multiplier;
                return new RangeWithBounds((Number)value, this.getMax(value), RangeWithBounds.BoundType.INCLUDING, RangeWithBounds.BoundType.INCLUDING);
            }
            throw new IllegalArgumentException("Incorrect prefix");
        }
    }

    private static final class NumberParser
    extends BaseRangeParser {
        private static final Pattern PATTERN = Pattern.compile("\\$?(-?[,\\d]+\\.?\\d*)([KMB]?)");

        private NumberParser() {
        }

        @Override
        public RangeWithBounds parse(String range) {
            Matcher matcher = PATTERN.matcher(range);
            if (!matcher.matches()) {
                return null;
            }
            String number = matcher.group(1);
            String multiplier = matcher.group(2);
            this.minNumber = this.maxNumber = number;
            this.minMultiplier = this.maxMultiplier = multiplier;
            double value = this.parseDoubleWithMultiplier(number, multiplier);
            return new RangeWithBounds((Number)value, (Number)value);
        }
    }
}

