/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.helpers;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.bind.annotation.XmlRootElement;
import org.openl.domain.IntRangeDomain;
import org.openl.meta.BigDecimalValue;
import org.openl.meta.BigIntegerValue;
import org.openl.meta.ByteValue;
import org.openl.meta.DoubleValue;
import org.openl.meta.FloatValue;
import org.openl.meta.IntValue;
import org.openl.meta.LongValue;
import org.openl.meta.ShortValue;
import org.openl.rules.helpers.INumberRange;
import org.openl.rules.helpers.IntRangeParser;
import org.openl.util.RangeWithBounds;

@XmlRootElement
public class IntRange
extends IntRangeDomain
implements INumberRange {
    public IntRange(int min, int max) {
        super(min, max);
        if (min > max) {
            throw new RuntimeException(max + " must be more or equal than " + min);
        }
    }

    public IntRange(Integer number) {
        super(number.intValue(), number.intValue());
    }

    public boolean contains(IntValue value) {
        return this.contains(value.intValue());
    }

    public IntRange() {
        super(0, 0);
    }

    public IntRange(String range) {
        super(0, 0);
        RangeWithBounds res = IntRange.getRangeWithBounds(range);
        this.min = res.getMin().intValue();
        if (!res.getMin().equals(this.min)) {
            throw new IllegalArgumentException("Min value is out of int values range.");
        }
        if (res.getLeftBoundType() == RangeWithBounds.BoundType.EXCLUDING) {
            ++this.min;
        }
        this.max = res.getMax().intValue();
        if (!res.getMax().equals(this.max)) {
            throw new IllegalArgumentException("Max value is out of int values range.");
        }
        if (res.getRightBoundType() == RangeWithBounds.BoundType.EXCLUDING) {
            --this.max;
        }
        if (this.min > this.max) {
            throw new RuntimeException(this.max + " must be more or equal than " + this.min);
        }
    }

    public static RangeWithBounds getRangeWithBounds(String range) {
        return IntRangeParser.getInstance().parse(range);
    }

    public static IntRange autocast(byte x, IntRange y) {
        return new IntRange(Integer.valueOf(x));
    }

    public static IntRange autocast(short x, IntRange y) {
        return new IntRange(Integer.valueOf(x));
    }

    public static IntRange autocast(int x, IntRange y) {
        return new IntRange(x);
    }

    public static IntRange cast(long x, IntRange y) {
        return new IntRange((int)x);
    }

    public static IntRange cast(float x, IntRange y) {
        return new IntRange((int)x);
    }

    public static IntRange cast(double x, IntRange y) {
        return new IntRange((int)x);
    }

    public static IntRange cast(BigInteger x, IntRange y) {
        return new IntRange(x.intValue());
    }

    public static IntRange cast(BigDecimal x, IntRange y) {
        return new IntRange(x.intValue());
    }

    public static IntRange cast(ByteValue x, IntRange y) {
        return new IntRange(x.intValue());
    }

    public static IntRange cast(ShortValue x, IntRange y) {
        return new IntRange(x.intValue());
    }

    public static IntRange cast(IntValue x, IntRange y) {
        return new IntRange(x.intValue());
    }

    public static IntRange cast(LongValue x, IntRange y) {
        return new IntRange(x.intValue());
    }

    public static IntRange cast(FloatValue x, IntRange y) {
        return new IntRange(x.intValue());
    }

    public static IntRange cast(DoubleValue x, IntRange y) {
        return new IntRange(x.intValue());
    }

    public static IntRange cast(BigIntegerValue x, IntRange y) {
        return new IntRange(x.intValue());
    }

    public static IntRange cast(BigDecimalValue x, IntRange y) {
        return new IntRange(x.intValue());
    }
}

