/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.helpers;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.openl.meta.BigDecimalValue;
import org.openl.meta.DoubleValue;
import org.openl.meta.FloatValue;

public class NumberUtils {
    public static boolean isFloatPointNumber(Object object) {
        if (object != null) {
            return NumberUtils.isFloatPointType(object.getClass());
        }
        return false;
    }

    public static boolean isFloatPointType(Class<?> clazz) {
        return Float.TYPE.equals(clazz) || Double.TYPE.equals(clazz) || Float.class.equals(clazz) || FloatValue.class.isAssignableFrom(clazz) || Double.class.equals(clazz) || DoubleValue.class.isAssignableFrom(clazz) || BigDecimal.class.equals(clazz) || BigDecimalValue.class.equals(clazz);
    }

    public static Double convertToDouble(Object object) {
        if (Float.class.equals(object.getClass())) {
            return Double.valueOf(object.toString());
        }
        if (FloatValue.class.isAssignableFrom(object.getClass())) {
            return Double.valueOf(object.toString());
        }
        if (Double.class.equals(object.getClass())) {
            return (Double)object;
        }
        if (DoubleValue.class.isAssignableFrom(object.getClass())) {
            return ((DoubleValue)object).doubleValue();
        }
        if (BigDecimal.class.equals(object.getClass())) {
            return ((BigDecimal)object).doubleValue();
        }
        if (BigDecimalValue.class.equals(object.getClass())) {
            return ((BigDecimalValue)object).doubleValue();
        }
        return null;
    }

    public static DoubleValue convertToDoubleValue(Object object) {
        if (FloatValue.class.isAssignableFrom(object.getClass())) {
            return FloatValue.autocast((FloatValue)((FloatValue)object), (DoubleValue)null);
        }
        if (DoubleValue.class.isAssignableFrom(object.getClass())) {
            return (DoubleValue)object;
        }
        if (BigDecimalValue.class.isAssignableFrom(object.getClass())) {
            return BigDecimalValue.cast((BigDecimalValue)((BigDecimalValue)object), (DoubleValue)null);
        }
        return new DoubleValue(NumberUtils.convertToDouble(object).doubleValue());
    }

    public static Double roundValue(Double value, int scale) {
        if (value != null) {
            if (value.isInfinite() || value.isNaN()) {
                return value;
            }
            BigDecimal roundedValue = BigDecimal.valueOf(value);
            roundedValue = roundedValue.setScale(scale, RoundingMode.HALF_UP);
            return roundedValue.doubleValue();
        }
        return null;
    }

    public static int getScale(Number value) {
        if (value == null) {
            throw new NullPointerException("Null value is not supported");
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).scale();
        }
        if (value instanceof BigDecimalValue) {
            return ((BigDecimalValue)value).getValue().scale();
        }
        if (NumberUtils.isFloatPointNumber(value)) {
            return NumberUtils.getScale(NumberUtils.convertToDouble(value));
        }
        return BigDecimal.valueOf(value.longValue()).scale();
    }

    public static int getScale(double value) {
        if (!Double.isNaN(value) && !Double.isInfinite(value)) {
            BigDecimal decimal = BigDecimal.valueOf(value);
            return decimal.scale();
        }
        return 0;
    }

    public static int getScale(float value) {
        return NumberUtils.getScale(Double.valueOf(Float.toString(value)));
    }

    public static Class<?> getNumericPrimitive(Class<?> wrapperClass) {
        if (Byte.class.equals(wrapperClass)) {
            return Byte.TYPE;
        }
        if (Short.class.equals(wrapperClass)) {
            return Short.TYPE;
        }
        if (Integer.class.equals(wrapperClass)) {
            return Integer.TYPE;
        }
        if (Long.class.equals(wrapperClass)) {
            return Long.TYPE;
        }
        if (Float.class.equals(wrapperClass)) {
            return Float.TYPE;
        }
        if (Double.class.equals(wrapperClass)) {
            return Double.TYPE;
        }
        return null;
    }
}

