/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls;

import org.openl.IOpenParser;
import org.openl.exception.OpenLCompilationException;
import org.openl.message.OpenLMessagesUtils;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.code.IParsedCode;
import org.openl.syntax.code.impl.ParsedCode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;

public abstract class BaseParser
implements IOpenParser {
    public IParsedCode parseAsMethodBody(IOpenSourceCodeModule source) {
        return this.getNotSupportedCode(source, "a Method Body");
    }

    public IParsedCode parseAsMethodHeader(IOpenSourceCodeModule source) {
        return this.getNotSupportedCode(source, "a Method Header");
    }

    public IParsedCode parseAsModule(IOpenSourceCodeModule source) {
        return this.getNotSupportedCode(source, "a Module");
    }

    public IParsedCode parseAsType(IOpenSourceCodeModule source) {
        return this.getNotSupportedCode(source, "a Type");
    }

    public IParsedCode parseAsIntegerRange(IOpenSourceCodeModule source) {
        return this.getNotSupportedCode(source, "an integer range");
    }

    public IParsedCode parseAsFloatRange(IOpenSourceCodeModule source) {
        return this.getNotSupportedCode(source, "a float range");
    }

    protected IParsedCode getNotSupportedCode(IOpenSourceCodeModule source, String sourceType) {
        String message = String.format("The source can't be parsed as %s", sourceType);
        return this.getInvalidCode(message, source);
    }

    protected IParsedCode getInvalidCode(String message, IOpenSourceCodeModule source) {
        SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)message, (IOpenSourceCodeModule)source);
        OpenLMessagesUtils.addError((OpenLCompilationException)((Object)error));
        SyntaxNodeException[] errors = new SyntaxNodeException[]{error};
        return new ParsedCode(null, source, errors);
    }
}

