/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.openl.conf.IConfigurableResourceContext;
import org.openl.message.OpenLMessagesUtils;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.URLSourceCodeModule;
import org.openl.util.PathTool;

public class IncludeSearcher {
    private static final String INCLUDE = "include/";
    private IConfigurableResourceContext ucxt;

    public IncludeSearcher(IConfigurableResourceContext ucxt) {
        this.ucxt = ucxt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IOpenSourceCodeModule findInclude(String include) {
        String p = PathTool.mergePath((String)INCLUDE, (String)include);
        URL url = this.ucxt.findClassPathResource(p);
        if (url != null) {
            return new URLSourceCodeModule(url);
        }
        File f = this.ucxt.findFileSystemResource(p);
        if (f != null) {
            try {
                return new URLSourceCodeModule(f.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        String u2 = INCLUDE + include;
        URL xurl = new URL(u2);
        InputStream is = null;
        try {
            is = xurl.openStream();
            if (is == null) return new URLSourceCodeModule(xurl);
        }
        catch (IOException iox) {
            IOpenSourceCodeModule iOpenSourceCodeModule;
            try {
                iOpenSourceCodeModule = null;
                if (is == null) return iOpenSourceCodeModule;
            }
            catch (Throwable throwable) {
                try {
                    if (is == null) throw throwable;
                    is.close();
                    throw throwable;
                }
                catch (Throwable t) {
                    OpenLMessagesUtils.addWarn((String)String.format("Cannot find '%s' (%s)", include, t.getMessage()));
                    return null;
                }
            }
            is.close();
            return iOpenSourceCodeModule;
        }
        is.close();
        return new URLSourceCodeModule(xurl);
    }
}

