/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls;

import org.apache.commons.lang3.StringUtils;
import org.openl.rules.calc.CellsHeaderExtractor;
import org.openl.rules.lang.xls.TableSyntaxNodeRelationsDeterminer;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.syntax.SpreadsheetHeaderNode;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.syntax.TableSyntaxNodeHelper;
import org.openl.rules.table.ILogicalTable;

public class SpreadsheetTableSyntaxNodeRelationsDeterminer
implements TableSyntaxNodeRelationsDeterminer {
    @Override
    public boolean determine(TableSyntaxNode node, TableSyntaxNode dependsOnNode) {
        if (SpreadsheetTableSyntaxNodeRelationsDeterminer.isSpreadsheet(node) && SpreadsheetTableSyntaxNodeRelationsDeterminer.isSpreadsheet(dependsOnNode)) {
            CellsHeaderExtractor extractor1 = SpreadsheetTableSyntaxNodeRelationsDeterminer.extractNames(node);
            if (extractor1 == null) {
                return false;
            }
            String methodName2 = TableSyntaxNodeHelper.getTableName(dependsOnNode);
            return StringUtils.isNotBlank((CharSequence)methodName2) && extractor1.getDependentSignatureSpreadsheetTypes().contains(methodName2);
        }
        throw new IllegalStateException("Spreadsheet tables are supported only!");
    }

    private static boolean isSpreadsheet(TableSyntaxNode o1) {
        return XlsNodeTypes.XLS_SPREADSHEET.equals((Object)o1.getNodeType());
    }

    private static CellsHeaderExtractor extractNames(TableSyntaxNode tableSyntaxNode) {
        ILogicalTable body;
        SpreadsheetHeaderNode header = (SpreadsheetHeaderNode)tableSyntaxNode.getHeader();
        CellsHeaderExtractor extractor = header.getCellHeadersExtractor();
        if (extractor == null && (body = tableSyntaxNode.getTableBody()) != null) {
            extractor = new CellsHeaderExtractor(TableSyntaxNodeHelper.getSignature(tableSyntaxNode), (ILogicalTable)((ILogicalTable)body.getRow(0)).getColumns(1), (ILogicalTable)((ILogicalTable)body.getColumn(0)).getRows(1));
            extractor.extract();
            header.setCellHeadersExtractor(extractor);
        }
        return extractor;
    }
}

