/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls;

import java.util.ArrayDeque;
import org.openl.rules.lang.xls.TableSyntaxNodeCircularDependencyException;
import org.openl.rules.lang.xls.TableSyntaxNodeRelationsDeterminer;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;

final class TableSyntaxNodeRelationsUtils {
    private TableSyntaxNodeRelationsUtils() {
    }

    public static boolean[][] buildRelationsMatrix(TableSyntaxNode[] tableSyntaxNodes, TableSyntaxNodeRelationsDeterminer tableSyntaxNodeRelationsDeterminer) {
        boolean[][] matrix = new boolean[tableSyntaxNodes.length][tableSyntaxNodes.length];
        for (int i = 0; i < tableSyntaxNodes.length; ++i) {
            for (int j = 0; j < tableSyntaxNodes.length; ++j) {
                if (i == j || !tableSyntaxNodeRelationsDeterminer.determine(tableSyntaxNodes[i], tableSyntaxNodes[j])) continue;
                matrix[j][i] = true;
            }
        }
        return matrix;
    }

    public static TableSyntaxNode[] sort(TableSyntaxNode[] tableSyntaxNodes, TableSyntaxNodeRelationsDeterminer tableSyntaxNodeRelationsDeterminer) throws TableSyntaxNodeCircularDependencyException {
        boolean[][] matrix = TableSyntaxNodeRelationsUtils.buildRelationsMatrix(tableSyntaxNodes, tableSyntaxNodeRelationsDeterminer);
        return TableSyntaxNodeRelationsUtils.sort(tableSyntaxNodes, matrix);
    }

    public static TableSyntaxNode[] sort(TableSyntaxNode[] tableSyntaxNodes, boolean[][] matrix) throws TableSyntaxNodeCircularDependencyException {
        TableSyntaxNode[] result = new TableSyntaxNode[tableSyntaxNodes.length];
        int[] countArray = new int[tableSyntaxNodes.length];
        for (int i = 0; i < tableSyntaxNodes.length; ++i) {
            for (int j = 0; j < tableSyntaxNodes.length; ++j) {
                if (i == j || !matrix[j][i]) continue;
                int n = i;
                countArray[n] = countArray[n] + 1;
            }
        }
        int n = 0;
        ArrayDeque<Integer> queue = new ArrayDeque<Integer>();
        for (int i = 0; i < tableSyntaxNodes.length; ++i) {
            if (countArray[i] != 0) continue;
            queue.add(i);
        }
        while (!queue.isEmpty()) {
            int t = (Integer)queue.poll();
            result[n++] = tableSyntaxNodes[t];
            for (int i = 0; i < tableSyntaxNodes.length; ++i) {
                if (!matrix[t][i]) continue;
                int n2 = i;
                countArray[n2] = countArray[n2] - 1;
                if (countArray[i] != 0) continue;
                queue.add(i);
            }
        }
        if (n < tableSyntaxNodes.length) {
            TableSyntaxNode[] invalidTableSyntaxNodes = new TableSyntaxNode[tableSyntaxNodes.length - n];
            int j = 0;
            for (int i = 0; i < tableSyntaxNodes.length; ++i) {
                if (countArray[i] <= 0) continue;
                invalidTableSyntaxNodes[j++] = tableSyntaxNodes[i];
            }
            throw new TableSyntaxNodeCircularDependencyException(invalidTableSyntaxNodes);
        }
        return result;
    }
}

