/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.openl.exception.OpenLCompilationException;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.XlsSheetSourceCodeModule;
import org.openl.rules.lang.xls.syntax.HeaderSyntaxNode;
import org.openl.rules.lang.xls.syntax.SpreadsheetHeaderNode;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.syntax.XlsModuleSyntaxNode;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.rules.table.syntax.GridLocation;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.syntax.impl.Tokenizer;
import org.openl.util.Log;
import org.openl.util.StringTool;
import org.openl.util.text.ILocation;
import org.openl.util.text.TextInterval;

public abstract class XlsHelper {
    private static Map<String, String> tableHeaders;

    public static String getModuleName(XlsModuleSyntaxNode node) {
        String uri = node.getModule().getUri();
        try {
            URL url = new URL(uri);
            String file = url.getFile();
            int index = file.lastIndexOf(47);
            file = index < 0 ? file : file.substring(index + 1);
            index = file.lastIndexOf(46);
            if (index > 0) {
                file = file.substring(0, index);
            }
            return StringTool.makeJavaIdentifier((String)file);
        }
        catch (MalformedURLException e) {
            if ("<virtual_uri>".equals(uri)) {
                return "VirtualModule";
            }
            Log.error((Object)"Error URI to name conversion", (Throwable)e);
            return "UndefinedXlsType";
        }
    }

    public static TableSyntaxNode createTableSyntaxNode(IGridTable table, XlsSheetSourceCodeModule source) throws OpenLCompilationException {
        GridCellSourceCodeModule src = new GridCellSourceCodeModule(table);
        IdentifierNode[] headerTokens = Tokenizer.tokenize((IOpenSourceCodeModule)src, (String)" \n\r");
        if (headerTokens.length == 0) {
            headerTokens = new IdentifierNode[]{Tokenizer.firstToken((IOpenSourceCodeModule)src, (String)" \n\r")};
        }
        IdentifierNode headerToken = headerTokens[0];
        String header = headerTokens[0].getIdentifier();
        String xls_type = tableHeaders.get(header);
        if (xls_type == null) {
            xls_type = XlsNodeTypes.XLS_OTHER.toString();
        }
        ArrayList<String> collectParameters = new ArrayList<String>();
        boolean isCollect = false;
        if ((header.equals("SimpleRules") || header.equals("SmartRules")) && headerTokens.length > 1 && headerTokens[1].getIdentifier().equals("Collect")) {
            isCollect = true;
            if (headerTokens.length > 2 && headerTokens[2].getIdentifier().equals("as")) {
                int i = 3;
                collectParameters.add(headerTokens[i].getIdentifier());
                if (i < headerTokens.length && headerTokens[i + 1].getIdentifier().equals("and")) {
                    collectParameters.add(headerTokens[i += 2].getIdentifier());
                }
                TextInterval location = new TextInterval(headerToken.getLocation().getStart(), headerTokens[i].getLocation().getEnd());
                headerToken = new IdentifierNode(headerToken.getType(), (ILocation)location, header, headerToken.getModule());
            } else {
                TextInterval location = new TextInterval(headerToken.getLocation().getStart(), headerTokens[1].getLocation().getEnd());
                headerToken = new IdentifierNode(headerToken.getType(), (ILocation)location, header, headerToken.getModule());
            }
        }
        HeaderSyntaxNode headerNode = XlsNodeTypes.XLS_SPREADSHEET.toString().equals(xls_type) ? new SpreadsheetHeaderNode(src, headerToken) : new HeaderSyntaxNode(src, headerToken, isCollect, collectParameters.toArray(new String[0]));
        GridLocation pos = new GridLocation(table);
        return new TableSyntaxNode(xls_type, pos, source, table, headerNode);
    }

    static {
        if (tableHeaders == null) {
            tableHeaders = new HashMap<String, String>();
            tableHeaders.put("DT", XlsNodeTypes.XLS_DT.toString());
            tableHeaders.put("Rules", XlsNodeTypes.XLS_DT.toString());
            tableHeaders.put("SimpleRules", XlsNodeTypes.XLS_DT.toString());
            tableHeaders.put("SmartRules", XlsNodeTypes.XLS_DT.toString());
            tableHeaders.put("SimpleLookup", XlsNodeTypes.XLS_DT.toString());
            tableHeaders.put("SmartLookup", XlsNodeTypes.XLS_DT.toString());
            tableHeaders.put("Spreadsheet", XlsNodeTypes.XLS_SPREADSHEET.toString());
            tableHeaders.put("Calc", XlsNodeTypes.XLS_SPREADSHEET.toString());
            tableHeaders.put("TBasic", XlsNodeTypes.XLS_TBASIC.toString());
            tableHeaders.put("Algorithm", XlsNodeTypes.XLS_TBASIC.toString());
            tableHeaders.put("ColumnMatch", XlsNodeTypes.XLS_COLUMN_MATCH.toString());
            tableHeaders.put("Data", XlsNodeTypes.XLS_DATA.toString());
            tableHeaders.put("Datatype", XlsNodeTypes.XLS_DATATYPE.toString());
            tableHeaders.put("Code", XlsNodeTypes.XLS_METHOD.toString());
            tableHeaders.put("Method", XlsNodeTypes.XLS_METHOD.toString());
            tableHeaders.put("Environment", XlsNodeTypes.XLS_ENVIRONMENT.toString());
            tableHeaders.put("Testmethod", XlsNodeTypes.XLS_TEST_METHOD.toString());
            tableHeaders.put("Test", XlsNodeTypes.XLS_TEST_METHOD.toString());
            tableHeaders.put("Runmethod", XlsNodeTypes.XLS_RUN_METHOD.toString());
            tableHeaders.put("Run", XlsNodeTypes.XLS_RUN_METHOD.toString());
            tableHeaders.put("TablePart", XlsNodeTypes.XLS_TABLEPART.toString());
            tableHeaders.put("Properties", XlsNodeTypes.XLS_PROPERTIES.toString());
        }
    }
}

