/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.binding.wrapper;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.openl.rules.lang.xls.binding.wrapper.IOpenMethodWrapper;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;

class TopClassMethodCache {
    private Map<IOpenClass, Map<IOpenMethodWrapper, WeakReference<IOpenMethod>>> classToWrapperMethodCache = new WeakHashMap<IOpenClass, Map<IOpenMethodWrapper, WeakReference<IOpenMethod>>>();
    private ReentrantReadWriteLock wrapperMethodCacheReadWriteLock = new ReentrantReadWriteLock();

    TopClassMethodCache() {
    }

    public static TopClassMethodCache getInstance() {
        return TopClassMethodCacheHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOpenMethod getTopClassMethod(IOpenClass topClass, IOpenMethodWrapper wrapper) {
        if (topClass == null) {
            return null;
        }
        ReentrantReadWriteLock.ReadLock lock = this.wrapperMethodCacheReadWriteLock.readLock();
        try {
            IOpenMethod method;
            WeakReference<IOpenMethod> reference;
            lock.lock();
            Map<IOpenMethodWrapper, WeakReference<IOpenMethod>> wrapperToMethodCache = this.classToWrapperMethodCache.get(topClass);
            if (wrapperToMethodCache != null && (reference = wrapperToMethodCache.get(wrapper)) != null && (method = (IOpenMethod)reference.get()) != null) {
                IOpenMethod iOpenMethod = method;
                return iOpenMethod;
            }
        }
        finally {
            lock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.wrapperMethodCacheReadWriteLock.writeLock();
        try {
            writeLock.lock();
            IOpenMethod method = topClass.getMethod(wrapper.getDelegate().getName(), wrapper.getDelegate().getSignature().getParameterTypes());
            Map<IOpenMethodWrapper, WeakReference<IOpenMethod>> wrapperToMethodCache = this.classToWrapperMethodCache.get(topClass);
            if (wrapperToMethodCache == null) {
                wrapperToMethodCache = new WeakHashMap<IOpenMethodWrapper, WeakReference<IOpenMethod>>();
                this.classToWrapperMethodCache.put(topClass, wrapperToMethodCache);
            }
            wrapperToMethodCache.put(wrapper, new WeakReference<IOpenMethod>(method));
            IOpenMethod iOpenMethod = method;
            return iOpenMethod;
        }
        finally {
            writeLock.unlock();
        }
    }

    private static final class TopClassMethodCacheHolder {
        private static final TopClassMethodCache INSTANCE = new TopClassMethodCache();

        private TopClassMethodCacheHolder() {
        }
    }
}

