/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.binding.wrapper;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.openl.rules.lang.xls.binding.wrapper.IOpenMethodWrapper;
import org.openl.rules.lang.xls.binding.wrapper.TopClassMethodCache;
import org.openl.rules.lang.xls.prebind.LazyMethodWrapper;
import org.openl.rules.tbasic.runtime.TBasicContextHolderEnv;
import org.openl.rules.vm.SimpleRulesRuntimeEnv;
import org.openl.runtime.OpenLInvocationHandler;
import org.openl.types.IDynamicObject;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.impl.MethodDelegator;
import org.openl.vm.IRuntimeEnv;

public final class WrapperLogic {
    private WrapperLogic() {
    }

    public static IOpenMethod getTopClassMethod(IOpenMethodWrapper wrapper, IRuntimeEnv env) {
        IOpenMethod method;
        SimpleRulesRuntimeEnv simpleRulesRuntimeEnv = WrapperLogic.extractSimpleRulesRuntimeEnv(env);
        IOpenClass topClass = simpleRulesRuntimeEnv.getTopClass();
        if (topClass != null && topClass != wrapper.getXlsModuleOpenClass() && (method = TopClassMethodCache.getInstance().getTopClassMethod(topClass, wrapper)) != null && (method = WrapperLogic.extractMethod(simpleRulesRuntimeEnv, method)) != wrapper) {
            return method;
        }
        return wrapper.getDelegate();
    }

    private static SimpleRulesRuntimeEnv extractSimpleRulesRuntimeEnv(IRuntimeEnv env) {
        IRuntimeEnv env1 = env;
        if (env instanceof TBasicContextHolderEnv) {
            TBasicContextHolderEnv tBasicContextHolderEnv = (TBasicContextHolderEnv)env;
            env1 = tBasicContextHolderEnv.getEnv();
            while (env1 instanceof TBasicContextHolderEnv) {
                tBasicContextHolderEnv = (TBasicContextHolderEnv)env1;
                env1 = tBasicContextHolderEnv.getEnv();
            }
        }
        SimpleRulesRuntimeEnv simpleRulesRuntimeEnv = (SimpleRulesRuntimeEnv)env1;
        return simpleRulesRuntimeEnv;
    }

    private static IOpenMethod extractMethod(SimpleRulesRuntimeEnv simpleRulesRuntimeEnv, IOpenMethod method) {
        while (method instanceof LazyMethodWrapper || method instanceof MethodDelegator) {
            if (method instanceof LazyMethodWrapper) {
                method = ((LazyMethodWrapper)method).getCompiledMethod((IRuntimeEnv)simpleRulesRuntimeEnv);
            }
            if (!(method instanceof MethodDelegator)) continue;
            MethodDelegator methodDelegator = (MethodDelegator)method;
            method = methodDelegator.getMethod();
        }
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object invoke(IOpenMethodWrapper wrapper, Object target, Object[] params, IRuntimeEnv env) {
        IOpenMethod method;
        SimpleRulesRuntimeEnv simpleRulesRuntimeEnv = WrapperLogic.extractSimpleRulesRuntimeEnv(env);
        IOpenClass topClass = simpleRulesRuntimeEnv.getTopClass();
        if (topClass == null) {
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                IOpenClass typeClass;
                if (target instanceof IDynamicObject) {
                    IDynamicObject dynamicObject = (IDynamicObject)target;
                    typeClass = dynamicObject.getType();
                } else {
                    if (!Proxy.isProxyClass(target.getClass())) throw new IllegalStateException("Can't define openl class from target object");
                    InvocationHandler invocationHandler = Proxy.getInvocationHandler(target);
                    if (!(invocationHandler instanceof OpenLInvocationHandler)) throw new IllegalStateException("Can't define openl class from target object!");
                    OpenLInvocationHandler openLInvocationHandler = (OpenLInvocationHandler)invocationHandler;
                    Object openlInstance = openLInvocationHandler.getInstance();
                    if (!(openlInstance instanceof IDynamicObject)) throw new IllegalStateException("Can't define openl class from target object!");
                    IDynamicObject dynamicObject = (IDynamicObject)openlInstance;
                    typeClass = dynamicObject.getType();
                }
                simpleRulesRuntimeEnv.setTopClass(typeClass);
                Thread.currentThread().setContextClassLoader(wrapper.getXlsModuleOpenClass().getClassLoader());
                Object object = wrapper.getDelegate().invoke(target, params, env);
                return object;
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
                simpleRulesRuntimeEnv.setTopClass(null);
            }
        }
        if (topClass == wrapper.getXlsModuleOpenClass() || (method = TopClassMethodCache.getInstance().getTopClassMethod(topClass, wrapper)) == null || (method = WrapperLogic.extractMethod(simpleRulesRuntimeEnv, method)) == wrapper) return wrapper.getDelegate().invoke(target, params, env);
        return method.invoke(target, params, env);
    }
}

