/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.load;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.openl.rules.lang.xls.load.CellLoader;
import org.openl.rules.lang.xls.load.NullCellLoader;
import org.openl.rules.lang.xls.load.SheetLoader;
import org.openl.rules.lang.xls.load.SimpleCellLoader;
import org.openl.rules.table.xls.PoiExcelHelper;

public class SimpleSheetLoader
implements SheetLoader {
    private final Sheet sheet;
    private String sheetName;

    public SimpleSheetLoader(Sheet sheet) {
        this.sheet = sheet;
    }

    @Override
    public Sheet getSheet() {
        return this.sheet;
    }

    @Override
    public String getSheetName() {
        if (this.sheetName == null) {
            this.sheetName = this.sheet.getSheetName();
        }
        return this.sheetName;
    }

    @Override
    public CellLoader getCellLoader(int column, int row) {
        Cell cell = PoiExcelHelper.getCell(column, row, this.sheet);
        return cell == null ? NullCellLoader.INSTANCE : new SimpleCellLoader(cell);
    }
}

