/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.syntax;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.openl.meta.StringValue;
import org.openl.rules.annotations.Executable;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.XlsSheetSourceCodeModule;
import org.openl.rules.lang.xls.syntax.HeaderSyntaxNode;
import org.openl.rules.lang.xls.syntax.TableUtils;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.LogicalTableHelper;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.table.syntax.GridLocation;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.CompositeSyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.impl.NaryNode;
import org.openl.types.IOpenMember;
import org.openl.util.CollectionUtils;
import org.openl.util.text.ILocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableSyntaxNode
extends NaryNode {
    private final Logger log = LoggerFactory.getLogger(TableSyntaxNode.class);
    private ILogicalTable table;
    private HeaderSyntaxNode headerNode;
    private ITableProperties tableProperties;
    private IOpenMember member;
    private Map<String, ILogicalTable> subTables = new HashMap<String, ILogicalTable>();
    private ArrayList<SyntaxNodeException> errors;
    private Object validationResult;

    public TableSyntaxNode(String type, GridLocation pos, XlsSheetSourceCodeModule module, IGridTable gridtable, HeaderSyntaxNode header) {
        super(type, (ILocation)pos, null, (IOpenSourceCodeModule)module);
        this.table = LogicalTableHelper.logicalTable(gridtable);
        this.headerNode = header;
        header.setParent((ISyntaxNode)this);
    }

    public void setTable(IGridTable gridTable) {
        this.table = LogicalTableHelper.logicalTable(gridTable);
    }

    public void addError(SyntaxNodeException error) {
        if (this.errors == null) {
            this.errors = new ArrayList();
        }
        for (SyntaxNodeException exception : this.errors) {
            if (!exception.getMessage().equals(error.getMessage()) || !error.getSourceLocation().equals(exception.getSourceLocation())) continue;
            this.log.warn("Skip duplicated message: " + error.getMessage(), (Throwable)error);
            return;
        }
        this.errors.add(error);
    }

    public void addError(CompositeSyntaxNodeException error) {
        SyntaxNodeException[] errors;
        for (SyntaxNodeException e : errors = error.getErrors()) {
            this.addError(e);
        }
    }

    public void clearErrors() {
        this.errors = null;
    }

    public String getDisplayName() {
        return this.table.getSource().getCell(0, 0).getStringValue();
    }

    public SyntaxNodeException[] getErrors() {
        return this.errors == null ? null : this.errors.toArray(new SyntaxNodeException[this.errors.size()]);
    }

    public boolean hasErrors() {
        return CollectionUtils.isNotEmpty(this.errors);
    }

    public GridLocation getGridLocation() {
        return (GridLocation)this.getLocation();
    }

    public HeaderSyntaxNode getHeader() {
        return this.headerNode;
    }

    public StringValue getHeaderLineValue() {
        String value = this.table.getSource().getCell(0, 0).getStringValue();
        if (value == null) {
            return new StringValue("");
        }
        return new StringValue(value, value, value, (IOpenSourceCodeModule)new GridCellSourceCodeModule(this.table.getSource(), 0, 0, null));
    }

    public IOpenMember getMember() {
        return this.member;
    }

    public ITableProperties getTableProperties() {
        return this.tableProperties;
    }

    public Map<String, ILogicalTable> getSubTables() {
        return this.subTables;
    }

    public ILogicalTable getTable(String view) {
        return this.subTables.get(view);
    }

    public ILogicalTable getTable() {
        return this.table;
    }

    public IGridTable getGridTable() {
        return this.table.getSource();
    }

    public ILogicalTable getTableBody() {
        int startRow;
        int n = startRow = !this.hasPropertiesDefinedInTable() ? 1 : 2;
        if (this.table.getHeight() <= startRow) {
            return null;
        }
        return (ILogicalTable)this.table.getRows(startRow);
    }

    public String getUri() {
        return this.getGridTable().getUri();
    }

    public String getId() {
        return TableUtils.makeTableId(this.getUri());
    }

    public Object getValidationResult() {
        return this.validationResult;
    }

    public XlsSheetSourceCodeModule getXlsSheetSourceCodeModule() {
        return (XlsSheetSourceCodeModule)this.getModule();
    }

    public void setMember(IOpenMember member) {
        this.member = member;
    }

    public void setTableProperties(ITableProperties properties) {
        this.tableProperties = properties;
    }

    public void setValidationResult(Object validationResult) {
        this.validationResult = validationResult;
    }

    public boolean hasPropertiesDefinedInTable() {
        boolean result = false;
        if (this.tableProperties != null && this.tableProperties.getPropertiesSection() != null) {
            result = true;
        }
        return result;
    }

    public boolean isExecutableNode() {
        if (this.getMember() != null) {
            Annotation[] annotations;
            Class<?> memberClass = this.getMember().getClass();
            for (Annotation annotation : annotations = memberClass.getAnnotations()) {
                if (!(annotation instanceof Executable)) continue;
                return true;
            }
        }
        return false;
    }

    public XlsNodeTypes getNodeType() {
        return XlsNodeTypes.getEnumByValue(this.getType());
    }
}

