/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.types;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.openl.types.IAggregateInfo;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;
import org.openl.types.IParameterDeclaration;
import org.openl.types.impl.ADynamicClass;
import org.openl.types.impl.DynamicArrayAggregateInfo;
import org.openl.types.impl.MethodKey;
import org.openl.types.impl.MethodSignature;
import org.openl.types.impl.ParameterDeclaration;
import org.openl.types.java.JavaOpenClass;
import org.openl.types.java.JavaOpenMethod;
import org.openl.util.RuntimeExceptionWrapper;
import org.openl.util.StringUtils;
import org.openl.vm.IRuntimeEnv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatatypeOpenClass
extends ADynamicClass {
    private final Logger log = LoggerFactory.getLogger(DatatypeOpenClass.class);
    private IOpenClass superClass;
    private final String javaName;
    private Map<String, IOpenField> fields = null;
    private static final IOpenMethod toString;
    private static final IOpenMethod equals;
    private static final IOpenMethod hashCode;
    private static final MethodKey toStringKey;
    private static final MethodKey equalsKey;
    private static final MethodKey hashCodeKey;

    public DatatypeOpenClass(String name, String packageName) {
        super(name, null);
        this.javaName = StringUtils.isBlank((CharSequence)packageName) ? name : packageName + '.' + name;
    }

    public IAggregateInfo getAggregateInfo() {
        return DynamicArrayAggregateInfo.aggregateInfo;
    }

    public IOpenClass getSuperClass() {
        return this.superClass;
    }

    public void setSuperClass(IOpenClass superClass) {
        this.superClass = superClass;
    }

    public Iterable<IOpenClass> superClasses() {
        if (this.superClass != null) {
            return Collections.singletonList(this.superClass);
        }
        return Collections.emptyList();
    }

    public String getJavaName() {
        return this.javaName;
    }

    protected LinkedHashMap<String, IOpenField> fieldMap() {
        if (this.fieldMap == null) {
            this.fieldMap = new LinkedHashMap();
        }
        return (LinkedHashMap)this.fieldMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, IOpenField> getFields() {
        if (this.fields == null) {
            DatatypeOpenClass datatypeOpenClass = this;
            synchronized (datatypeOpenClass) {
                if (this.fields == null) {
                    this.fields = this.initializeFields();
                }
            }
        }
        return Collections.unmodifiableMap(this.fields);
    }

    private Map<String, IOpenField> initializeFields() {
        LinkedHashMap<String, IOpenField> fields = new LinkedHashMap<String, IOpenField>();
        Iterable<IOpenClass> superClasses = this.superClasses();
        for (IOpenClass superClass : superClasses) {
            fields.putAll(superClass.getFields());
        }
        fields.putAll(this.fieldMap());
        return fields;
    }

    public Map<String, IOpenField> getDeclaredFields() {
        return (Map)((HashMap)this.fieldMap()).clone();
    }

    public Object newInstance(IRuntimeEnv env) {
        Object instance = null;
        try {
            instance = this.getInstanceClass().newInstance();
        }
        catch (InstantiationException e) {
            this.log.error("{}", (Object)this, (Object)e);
        }
        catch (IllegalAccessException e) {
            this.log.error("{}", (Object)this, (Object)e);
        }
        catch (Throwable e) {
            this.log.error("{}", (Object)this, (Object)e);
        }
        return instance;
    }

    public IOpenClass getComponentClass() {
        if (this.isArray()) {
            return JavaOpenClass.getOpenClass(this.getInstanceClass().getComponentType());
        }
        return null;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.superClass).append((Object)this.getMetaInfo()).append((Object)this.javaName).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        DatatypeOpenClass other = (DatatypeOpenClass)((Object)obj);
        return new EqualsBuilder().append((Object)this.superClass, (Object)other.getSuperClass()).append((Object)this.getMetaInfo(), (Object)other.getMetaInfo()).append((Object)this.javaName, (Object)other.getJavaName()).isEquals();
    }

    public String toString() {
        return this.javaName;
    }

    protected Map<MethodKey, IOpenMethod> initMethodMap() {
        HashMap<MethodKey, IOpenMethod> methods = super.initMethodMap();
        if (methods == STUB) {
            methods = new HashMap<MethodKey, IOpenMethod>(5);
        }
        methods.put(toStringKey, toString);
        methods.put(equalsKey, equals);
        methods.put(hashCodeKey, hashCode);
        return methods;
    }

    static {
        try {
            toString = new JavaOpenMethod(Object.class.getMethod("toString", new Class[0]));
            equals = new JavaOpenMethod(Object.class.getMethod("equals", Object.class));
            hashCode = new JavaOpenMethod(Object.class.getMethod("hashCode", new Class[0]));
            toStringKey = new MethodKey(toString);
            equalsKey = new MethodKey(equals);
            hashCodeKey = new MethodKey(hashCode);
        }
        catch (NoSuchMethodException nsme) {
            throw RuntimeExceptionWrapper.wrap((Throwable)nsme);
        }
    }

    public static class OpenFieldsConstructor
    implements IOpenMethod {
        private IOpenClass openClass;

        public OpenFieldsConstructor(IOpenClass openClass) {
            this.openClass = openClass;
        }

        public IOpenClass getDeclaringClass() {
            return this.openClass;
        }

        public String getDisplayName(int mode) {
            return this.openClass.getDisplayName(mode);
        }

        public IMemberMetaInfo getInfo() {
            return null;
        }

        public IOpenMethod getMethod() {
            return this;
        }

        public String getName() {
            return this.openClass.getName();
        }

        public IMethodSignature getSignature() {
            Map fields = this.openClass.getFields();
            IParameterDeclaration[] params = new IParameterDeclaration[fields.size()];
            int i = 0;
            for (Map.Entry field : fields.entrySet()) {
                params[i] = new ParameterDeclaration(((IOpenField)field.getValue()).getType(), (String)field.getKey());
                ++i;
            }
            return new MethodSignature(params);
        }

        public IOpenClass getType() {
            return this.openClass;
        }

        public Object invoke(Object target, Object[] params, IRuntimeEnv env) {
            Object result = this.openClass.newInstance(env);
            int i = 0;
            for (IOpenField field : this.openClass.getFields().values()) {
                field.set(result, params[i], env);
                ++i;
            }
            return result;
        }

        public boolean isStatic() {
            return true;
        }

        public boolean isConstructor() {
            return true;
        }

        public String toString() {
            return this.openClass.getName();
        }
    }
}

