/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.method.table;

import org.openl.OpenL;
import org.openl.binding.BindingDependencies;
import org.openl.binding.IBindingContext;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.engine.OpenLCellExpressionsCompiler;
import org.openl.rules.lang.xls.binding.AMethodBasedNode;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.method.ExecutableRulesMethod;
import org.openl.rules.method.table.TableMethod;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.CompositeSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethodHeader;

public class MethodTableBoundNode
extends AMethodBasedNode {
    public MethodTableBoundNode(TableSyntaxNode tableSyntaxNode, OpenL openl, IOpenMethodHeader header, ModuleOpenClass module) {
        super(tableSyntaxNode, openl, header, module);
    }

    @Override
    protected ExecutableRulesMethod createMethodShell() {
        return new TableMethod(this.getHeader(), null, this);
    }

    @Override
    public void finalizeBind(IBindingContext bindingContext) throws Exception {
        super.finalizeBind(bindingContext);
        TableSyntaxNode tsn = this.getTableSyntaxNode();
        ILogicalTable logicalTable = tsn.getTable();
        boolean tableHasProperties = tsn.hasPropertiesDefinedInTable();
        ILogicalTable bodyTable = (ILogicalTable)logicalTable.getRows(tableHasProperties ? 2 : 1);
        if (bodyTable == null) {
            String errorMessage = "Method table must contain a body section";
            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)errorMessage, (ISyntaxNode)tsn);
            tsn.addError(error);
            BindHelper.processError((SyntaxNodeException)error);
        } else {
            int height = bodyTable.getHeight();
            IOpenSourceCodeModule[] cellSources = new IOpenSourceCodeModule[height];
            for (int i = 0; i < height; ++i) {
                cellSources[i] = new GridCellSourceCodeModule(((ILogicalTable)bodyTable.getRow(i)).getSource(), bindingContext);
            }
            CompositeSourceCodeModule src = new CompositeSourceCodeModule(cellSources, "\n");
            OpenLCellExpressionsCompiler.compileMethod(this.getOpenl(), (IOpenSourceCodeModule)src, this.getTableMethod().getCompositeMethod(), bindingContext);
        }
    }

    @Override
    public IOpenClass getType() {
        return this.getHeader().getType();
    }

    public void updateDependency(BindingDependencies dependencies) {
        this.getTableMethod().getCompositeMethod().getMethodBodyBoundNode().updateDependency(dependencies);
    }

    private TableMethod getTableMethod() {
        return (TableMethod)this.getMethod();
    }

    @Override
    public void removeDebugInformation(IBindingContext cxt) throws Exception {
        super.removeDebugInformation(cxt);
        this.getTableMethod().getCompositeMethod().removeDebugInformation();
    }
}

