/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.openl.binding.impl.component.ComponentOpenClass;
import org.openl.rules.runtime.RuleInfo;
import org.openl.rules.testmethod.TestSuiteMethod;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMember;
import org.openl.types.IOpenMethod;
import org.openl.types.impl.ADynamicClass;
import org.openl.types.impl.MethodKey;
import org.openl.types.java.JavaOpenConstructor;
import org.openl.util.ClassUtils;
import org.openl.util.StringUtils;

public class InterfaceGenerator {
    public static final int PUBLIC_ABSTRACT_INTERFACE = 1537;
    public static final int PUBLIC_ABSTRACT = 1025;
    public static final String JAVA_LANG_OBJECT = "java/lang/Object";
    private static final RuleInfo[] EMPTY_RULES = new RuleInfo[0];

    public static Class<?> generateInterface(String className, RuleInfo[] rules, ClassLoader classLoader) throws Exception {
        ClassWriter classWriter = new ClassWriter(0);
        String name = className.replace('.', '/');
        classWriter.visit(51, 1537, name, null, JAVA_LANG_OBJECT, null);
        for (RuleInfo ruleInfo : rules) {
            String ruleName = ruleInfo.getName();
            classWriter.visitMethod(1025, ruleName, InterfaceGenerator.getMethodTypes(ruleInfo), null, null);
        }
        classWriter.visitEnd();
        ClassUtils.defineClass((String)className, (byte[])classWriter.toByteArray(), (ClassLoader)classLoader);
        return Class.forName(className, true, classLoader);
    }

    public static Class<?> generateInterface(String className, IOpenClass openClass, ClassLoader classLoader, String[] includes, String[] excludes) throws Exception {
        if (openClass == null) {
            return InterfaceGenerator.generateInterface(className, EMPTY_RULES, classLoader);
        }
        ArrayList<RuleInfo> rules = new ArrayList<RuleInfo>();
        HashSet<MethodKey> methodsInClass = new HashSet<MethodKey>();
        Collection methods = openClass.getMethods();
        for (IOpenMethod method : methods) {
            RuleInfo ruleInfo;
            boolean isMember;
            if (InterfaceGenerator.isIgnoredMember((IOpenMember)method) || !(isMember = InterfaceGenerator.isMember(ruleInfo = InterfaceGenerator.getRuleInfoForMethod(method), includes, excludes))) continue;
            rules.add(ruleInfo);
            methodsInClass.add(new MethodKey(method));
        }
        Collection fields = openClass.getFields().values();
        for (IOpenField field : fields) {
            MethodKey key;
            RuleInfo ruleInfo;
            boolean isMember;
            if (InterfaceGenerator.isIgnoredMember((IOpenMember)field) || !field.isReadable() || !(isMember = InterfaceGenerator.isMember(ruleInfo = InterfaceGenerator.getRuleInfoForField(field), includes, excludes)) || methodsInClass.contains(key = new MethodKey(ruleInfo.getName(), new IOpenClass[0], false))) continue;
            rules.add(ruleInfo);
            methodsInClass.add(key);
        }
        return InterfaceGenerator.generateInterface(className, rules.toArray(new RuleInfo[rules.size()]), classLoader);
    }

    private static boolean isMember(RuleInfo ruleInfo, String[] includes, String[] excludes) {
        boolean isMember = true;
        String methodSignature = InterfaceGenerator.getRuleInfoSignature(ruleInfo);
        if (includes != null && includes.length > 0) {
            isMember = false;
            for (String pattern : includes) {
                if (!Pattern.matches(pattern, methodSignature)) continue;
                isMember = true;
            }
        }
        if (excludes != null && excludes.length > 0 && isMember) {
            for (String pattern : excludes) {
                if (!Pattern.matches(pattern, methodSignature)) continue;
                isMember = false;
            }
        }
        return isMember;
    }

    private static String getRuleInfoSignature(RuleInfo ruleInfo) {
        StringBuilder sb = new StringBuilder();
        sb.append(ruleInfo.getReturnType().getCanonicalName());
        sb.append(" ");
        sb.append(ruleInfo.getName());
        sb.append("(");
        boolean first = true;
        for (Class<?> paramType : ruleInfo.getParamTypes()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(paramType.getCanonicalName());
        }
        sb.append(")");
        return sb.toString();
    }

    public static Class<?> generateInterface(String className, IOpenClass openClass, ClassLoader classLoader) throws Exception {
        return InterfaceGenerator.generateInterface(className, openClass, classLoader, null, null);
    }

    private static RuleInfo getRuleInfoForField(IOpenField field) {
        String methodName = String.format("get%s", StringUtils.capitalize((String)field.getName()));
        Class[] paramTypes = new Class[]{};
        Class returnType = field.getType().getInstanceClass();
        RuleInfo ruleInfo = InterfaceGenerator.createRuleInfo(methodName, paramTypes, returnType);
        return ruleInfo;
    }

    private static RuleInfo getRuleInfoForMethod(IOpenMethod method) {
        String methodName = method.getName();
        IOpenClass[] paramClasses = method.getSignature().getParameterTypes();
        Class returnType = method.getType().getInstanceClass();
        Class<?>[] paramTypes = InterfaceGenerator.getInstanceClasses(paramClasses);
        RuleInfo ruleInfo = InterfaceGenerator.createRuleInfo(methodName, paramTypes, returnType);
        return ruleInfo;
    }

    public static RuleInfo createRuleInfo(String ruleName, Class<?>[] paramTypes, Class<?> returnType) {
        RuleInfo ruleInfo = new RuleInfo();
        ruleInfo.setName(ruleName);
        ruleInfo.setParamTypes(paramTypes);
        ruleInfo.setReturnType(returnType);
        return ruleInfo;
    }

    private static boolean isIgnoredMember(IOpenMember member) {
        return member instanceof ADynamicClass.OpenConstructor || member instanceof JavaOpenConstructor || member instanceof ComponentOpenClass.ThisField || member instanceof ComponentOpenClass.GetOpenClass || member instanceof TestSuiteMethod;
    }

    private static String getMethodTypes(RuleInfo ruleInfo) {
        Class<?> returnType = ruleInfo.getReturnType();
        Class<?>[] paramTypes = ruleInfo.getParamTypes();
        StringBuilder builder = new StringBuilder("(");
        for (int i = 0; i < paramTypes.length; ++i) {
            builder.append(Type.getType(paramTypes[i]));
        }
        builder.append(")");
        builder.append(Type.getType(returnType));
        return builder.toString();
    }

    private static Class<?>[] getInstanceClasses(IOpenClass[] openClasses) {
        ArrayList<Class> classes = new ArrayList<Class>();
        if (openClasses != null) {
            for (IOpenClass openClass : openClasses) {
                Class clazz = openClass.getInstanceClass();
                classes.add(clazz);
            }
        }
        return classes.toArray(new Class[classes.size()]);
    }
}

