/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table;

public class CellKey {
    private int col;
    private int row;
    public static CellKey ZERO_ZERO = new CellKey(0, 0);
    public static CellKey ZERO_ONE = new CellKey(0, 1);
    public static CellKey ONE_ZERO = new CellKey(1, 0);
    public static CellKey ONE_ONE = new CellKey(1, 1);

    private CellKey(int col, int row) {
        this.col = col;
        this.row = row;
    }

    public int getColumn() {
        return this.col;
    }

    public int getRow() {
        return this.row;
    }

    public int hashCode() {
        return this.col * 773 + this.row;
    }

    public boolean equals(Object obj) {
        CellKey k = (CellKey)obj;
        return this.col == k.col && this.row == k.row;
    }

    public String toString() {
        return String.format("row: %d, col: %d", this.row, this.col);
    }

    public static final class CellKeyFactory {
        public static CellKey getCellKey(int col, int row) {
            if (col == 0 && row == 0) {
                return ZERO_ZERO;
            }
            if (col == 0 && row == 1) {
                return ZERO_ONE;
            }
            if (col == 1 && row == 0) {
                return ONE_ZERO;
            }
            if (col == 1 && row == 1) {
                return ONE_ONE;
            }
            return new CellKey(col, row);
        }
    }
}

