/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table;

import java.util.Date;
import org.openl.rules.lang.xls.types.CellMetaInfo;
import org.openl.rules.table.ICell;
import org.openl.rules.table.ICellComment;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.ui.CellFont;
import org.openl.rules.table.ui.CellStyle;
import org.openl.rules.table.ui.ICellFont;
import org.openl.rules.table.ui.ICellStyle;
import org.openl.rules.table.ui.filters.IGridFilter;
import org.openl.rules.table.xls.IncorrectFormulaException;
import org.openl.util.formatters.IFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormattedCell
implements ICell {
    private final Logger log = LoggerFactory.getLogger(FormattedCell.class);
    private ICell delegate;
    private ICellFont font;
    private ICellStyle style;
    private IGridFilter filter;
    private Object objectValue;
    private String formattedValue;

    @Override
    public ICell getTopLeftCellFromRegion() {
        return this.delegate.getTopLeftCellFromRegion();
    }

    public FormattedCell(ICell delegate) {
        this.delegate = delegate;
        try {
            this.objectValue = this.delegate.getObjectValue();
        }
        catch (IncorrectFormulaException e) {
            this.objectValue = "#ERROR";
        }
        this.formattedValue = this.delegate.getFormattedValue();
        this.font = new CellFont(delegate.getFont());
        this.style = new CellStyle(delegate.getStyle());
    }

    @Override
    public ICellStyle getStyle() {
        return this.style;
    }

    @Override
    public ICellFont getFont() {
        return this.font;
    }

    @Override
    public Object getObjectValue() {
        return this.objectValue;
    }

    public void setObjectValue(Object objectValue) {
        this.objectValue = objectValue;
    }

    public IGridFilter getFilter() {
        return this.filter;
    }

    public void setFilter(IGridFilter filter) {
        if (this.filter != null) {
            this.log.warn("More than one filter set on cell");
        }
        this.filter = filter;
    }

    @Override
    public String getFormattedValue() {
        return this.formattedValue;
    }

    public void setFormattedValue(String formattedValue) {
        this.formattedValue = formattedValue;
    }

    @Override
    public int getAbsoluteColumn() {
        return this.delegate.getAbsoluteColumn();
    }

    @Override
    public int getAbsoluteRow() {
        return this.delegate.getAbsoluteRow();
    }

    @Override
    public IGridRegion getAbsoluteRegion() {
        return this.delegate.getAbsoluteRegion();
    }

    @Override
    public int getRow() {
        return this.delegate.getRow();
    }

    @Override
    public int getColumn() {
        return this.delegate.getColumn();
    }

    @Override
    public IGridRegion getRegion() {
        return this.delegate.getRegion();
    }

    @Override
    public int getHeight() {
        return this.delegate.getHeight();
    }

    @Override
    public String getStringValue() {
        return this.delegate.getStringValue();
    }

    @Override
    public int getWidth() {
        return this.delegate.getWidth();
    }

    @Override
    public String getFormula() {
        return this.delegate.getFormula();
    }

    @Override
    public int getType() {
        return this.delegate.getType();
    }

    @Override
    public String getUri() {
        return this.delegate.getUri();
    }

    @Override
    public boolean getNativeBoolean() {
        return this.delegate.getNativeBoolean();
    }

    @Override
    public double getNativeNumber() {
        return this.delegate.getNativeNumber();
    }

    @Override
    public int getNativeType() {
        return this.delegate.getNativeType();
    }

    @Override
    public boolean hasNativeType() {
        return this.delegate.hasNativeType();
    }

    @Override
    public Date getNativeDate() {
        return this.delegate.getNativeDate();
    }

    @Override
    public CellMetaInfo getMetaInfo() {
        return this.delegate.getMetaInfo();
    }

    @Override
    public void setMetaInfo(CellMetaInfo metaInfo) {
        this.delegate.setMetaInfo(metaInfo);
    }

    @Override
    public ICellComment getComment() {
        return this.delegate.getComment();
    }

    @Override
    public IFormatter getDataFormatter() {
        return this.delegate.getDataFormatter();
    }
}

