/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.openl.rules.table.GridRegion;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGrid;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.actions.AUndoableCellAction;
import org.openl.rules.table.actions.GridRegionAction;
import org.openl.rules.table.actions.IUndoableGridTableAction;
import org.openl.rules.table.actions.MergeCellsAction;
import org.openl.rules.table.actions.SetBorderStyleAction;
import org.openl.rules.table.actions.UndoableClearAction;
import org.openl.rules.table.actions.UndoableCompositeAction;
import org.openl.rules.table.actions.UndoableCopyValueAction;
import org.openl.rules.table.actions.UndoableResizeMergedRegionAction;
import org.openl.rules.table.actions.UndoableSetValueAction;
import org.openl.rules.table.actions.UndoableShiftValueAction;
import org.openl.rules.table.actions.UnmergeByColumnsAction;
import org.openl.rules.table.ui.CellStyle;
import org.openl.rules.table.ui.ICellStyle;

public class GridTool {
    private static final String PROPERTIES_SECTION_NAME = "properties";
    static final boolean COLUMNS = true;
    static final boolean ROWS = false;
    static final boolean INSERT = true;
    static final boolean REMOVE = false;

    private static List<IUndoableGridTableAction> resizeMergedRegions(IGrid grid, int firstRowOrColumn, int numberOfRowsOrColumns, boolean isInsert, boolean isColumns, IGridRegion regionOfTable) {
        ArrayList<IUndoableGridTableAction> resizeActions = new ArrayList<IUndoableGridTableAction>();
        for (int i = 0; i < grid.getNumberOfMergedRegions(); ++i) {
            IGridRegion existingMergedRegion = grid.getMergedRegion(i);
            if (!IGridRegion.Tool.contains(regionOfTable, existingMergedRegion.getLeft(), existingMergedRegion.getTop()) || !GridTool.isRegionMustBeResized(existingMergedRegion, firstRowOrColumn, numberOfRowsOrColumns, isColumns, regionOfTable)) continue;
            ICellStyle oldCellStyle = grid.getCell(existingMergedRegion.getLeft(), existingMergedRegion.getBottom()).getStyle();
            if (!isColumns && isInsert) {
                for (int j = 1; j <= numberOfRowsOrColumns; ++j) {
                    grid.getCell(existingMergedRegion.getLeft(), existingMergedRegion.getBottom() + 1).getStyle();
                    resizeActions.add(new SetBorderStyleAction(existingMergedRegion.getLeft(), existingMergedRegion.getBottom() + j, oldCellStyle));
                }
            }
            resizeActions.add(new UndoableResizeMergedRegionAction(existingMergedRegion, numberOfRowsOrColumns, isInsert, isColumns));
        }
        return resizeActions;
    }

    private static boolean isRegionMustBeResized(IGridRegion region, int firstRowOrColumn, int numberOfRowsOrColumns, boolean isColumns, IGridRegion regionOfTable) {
        if (isColumns) {
            return IGridRegion.Tool.width(region) > numberOfRowsOrColumns && IGridRegion.Tool.contains(region, regionOfTable.getLeft() + firstRowOrColumn, region.getTop());
        }
        return IGridRegion.Tool.height(region) > numberOfRowsOrColumns && IGridRegion.Tool.contains(region, region.getLeft(), regionOfTable.getTop() + firstRowOrColumn);
    }

    public static IUndoableGridTableAction insertColumns(int nCols, int beforeColumns, IGridRegion region, IGrid grid) {
        int h = IGridRegion.Tool.height(region);
        int w = IGridRegion.Tool.width(region);
        int columnsToMove = w - beforeColumns;
        ArrayList<IUndoableGridTableAction> actions = new ArrayList<IUndoableGridTableAction>(h * columnsToMove);
        int firstToMove = region.getLeft() + beforeColumns;
        int colTo = firstToMove + nCols;
        int top = region.getTop();
        actions.addAll(GridTool.shiftColumns(colTo, nCols, true, region, grid));
        actions.addAll(GridTool.copyCells(firstToMove, top, colTo, top, nCols, h, grid));
        actions.addAll(GridTool.resizeMergedRegions(grid, beforeColumns, nCols, true, true, region));
        actions.addAll(GridTool.emptyCells(firstToMove, top, nCols, h, grid));
        return new UndoableCompositeAction(actions);
    }

    public static IUndoableGridTableAction insertRows(int nRows, int afterRow, IGridRegion region, IGrid grid) {
        return GridTool.insertRows(nRows, afterRow, region, grid, false);
    }

    private static IUndoableGridTableAction insertRows(int nRows, int row, IGridRegion region, IGrid grid, boolean before) {
        int h = IGridRegion.Tool.height(region);
        int w = IGridRegion.Tool.width(region);
        int rowsToMove = h - row;
        ArrayList<IUndoableGridTableAction> actions = new ArrayList<IUndoableGridTableAction>(w * rowsToMove);
        int firstToMove = region.getTop() + row;
        int rowTo = firstToMove + nRows;
        int left = region.getLeft();
        actions.addAll(GridTool.shiftRows(rowTo, nRows, true, region, grid));
        actions.addAll(GridTool.copyCells(left, firstToMove, left, rowTo, w, nRows, grid));
        actions.addAll(GridTool.resizeMergedRegions(grid, row, nRows, true, false, region));
        int rowFrom = before ? firstToMove : rowTo;
        actions.addAll(GridTool.emptyCells(left, rowFrom, w, nRows, grid));
        return new UndoableCompositeAction(actions);
    }

    private static List<IUndoableGridTableAction> copyCells(int colFrom, int rowFrom, int colTo, int rowTo, int nCols, int nRows, IGrid grid) {
        ArrayList<IUndoableGridTableAction> actions = new ArrayList<IUndoableGridTableAction>();
        for (int i = nCols - 1; i >= 0; --i) {
            for (int j = nRows - 1; j >= 0; --j) {
                int cFrom = colFrom + i;
                int rFrom = rowFrom + j;
                int cTo = colTo + i;
                int rTo = rowTo + j;
                if (grid.isInOneMergedRegion(cFrom, rFrom, cTo, rTo)) continue;
                actions.add(new UndoableCopyValueAction(cFrom, rFrom, cTo, rTo));
            }
        }
        return actions;
    }

    private static List<IUndoableGridTableAction> emptyCells(int colFrom, int rowFrom, int nCols, int nRows, IGrid grid) {
        ArrayList<IUndoableGridTableAction> actions = new ArrayList<IUndoableGridTableAction>();
        for (int i = nCols - 1; i >= 0; --i) {
            for (int j = nRows - 1; j >= 0; --j) {
                ICell cell;
                int cFrom = colFrom + i;
                int rFrom = rowFrom + j;
                if (grid.isTopLeftCellInMergedRegion(cFrom, rFrom) ? (cell = grid.getCell(cFrom, rFrom)).getHeight() > nRows || cell.getWidth() > nCols : grid.isPartOfTheMergedRegion(cFrom, rFrom)) continue;
                actions.add(new UndoableSetValueAction(cFrom, rFrom, null));
            }
        }
        return actions;
    }

    public static IUndoableGridTableAction insertProp(IGridRegion tableRegion, IGrid grid, String newPropName, Object newPropValue) {
        if (newPropValue == null) {
            return null;
        }
        int propertyRowIndex = GridTool.getPropertyRowIndex(tableRegion, grid, newPropName);
        if (propertyRowIndex > 0) {
            return GridTool.setExistingPropertyValue(tableRegion, grid, newPropValue, propertyRowIndex);
        }
        return GridTool.insertNewProperty(tableRegion, grid, newPropName, newPropValue);
    }

    private static int getPropertyRowIndex(IGridRegion tableRegion, IGrid grid, String newPropName) {
        int firstPropertyRow;
        int topCell;
        int leftCell = tableRegion.getLeft();
        String propsHeader = grid.getCell(leftCell, (topCell = tableRegion.getTop()) + (firstPropertyRow = IGridRegion.Tool.height(grid.getCell(leftCell, topCell).getAbsoluteRegion()))).getStringValue();
        if (!GridTool.tableContainsPropertySection(propsHeader)) {
            return -1;
        }
        int propsCount = grid.getCell(leftCell, topCell + 1).getHeight();
        int propNameCellOffset = grid.getCell(leftCell, topCell + 1).getWidth();
        for (int i = 0; i < propsCount; ++i) {
            String propNameFromTable = grid.getCell(leftCell + propNameCellOffset, topCell + 1 + i).getStringValue();
            if (propNameFromTable == null || !propNameFromTable.equals(newPropName)) continue;
            return topCell + 1 + i;
        }
        return -1;
    }

    private static IUndoableGridTableAction setExistingPropertyValue(IGridRegion tableRegion, IGrid grid, Object newPropValue, int propertyRowIndex) {
        int topCell;
        int propNameCellOffset;
        int propValueCellOffset;
        int leftCell = tableRegion.getLeft();
        Object propValueFromTable = grid.getCell(leftCell + (propValueCellOffset = (propNameCellOffset = grid.getCell(leftCell, (topCell = tableRegion.getTop()) + 1).getWidth()) + grid.getCell(leftCell + propNameCellOffset, topCell + 1).getWidth()), propertyRowIndex).getObjectValue();
        if (propValueFromTable != null && newPropValue != null && propValueFromTable.equals(newPropValue)) {
            return null;
        }
        return new UndoableSetValueAction(leftCell + propValueCellOffset, propertyRowIndex, newPropValue);
    }

    private static IUndoableGridTableAction insertNewProperty(IGridRegion tableRegion, IGrid grid, String newPropName, Object newPropValue) {
        int propValueCellOffset;
        int propNameCellOffset;
        int leftCell = tableRegion.getLeft();
        int topCell = tableRegion.getTop();
        int firstPropertyRow = IGridRegion.Tool.height(grid.getCell(leftCell, topCell).getAbsoluteRegion());
        int rowsToMove = IGridRegion.Tool.height(tableRegion) - firstPropertyRow;
        ArrayList<IUndoableGridTableAction> actions = new ArrayList<IUndoableGridTableAction>(IGridRegion.Tool.width(tableRegion) * rowsToMove);
        String propsHeader = grid.getCell(leftCell, topCell + firstPropertyRow).getStringValue();
        if (!GridTool.tableContainsPropertySection(propsHeader)) {
            actions.addAll(GridTool.shiftRows(tableRegion.getTop() + firstPropertyRow, 1, true, tableRegion, grid));
            actions.add(GridTool.createPropertiesSection(tableRegion, grid));
            propNameCellOffset = 1;
            propValueCellOffset = 2;
        } else {
            actions.add(GridTool.insertRows(1, firstPropertyRow, tableRegion, grid, true));
            actions.add(GridTool.resizePropertiesHeader(tableRegion, grid));
            propNameCellOffset = grid.getCell(leftCell, topCell + firstPropertyRow).getWidth();
            propValueCellOffset = propNameCellOffset + grid.getCell(leftCell + propNameCellOffset, topCell + firstPropertyRow).getWidth();
        }
        actions.add(new UndoableSetValueAction(leftCell + propNameCellOffset, topCell + firstPropertyRow, newPropName));
        actions.add(new UndoableSetValueAction(leftCell + propValueCellOffset, topCell + firstPropertyRow, newPropValue));
        return new UndoableCompositeAction(actions);
    }

    private static IUndoableGridTableAction createPropertiesSection(IGridRegion tableRegion, IGrid grid) {
        int regionWidth = IGridRegion.Tool.width(tableRegion);
        int leftCell = tableRegion.getLeft();
        int topCell = tableRegion.getTop();
        IGridRegion headerRegion = grid.getCell(leftCell, topCell).getAbsoluteRegion();
        ArrayList<IUndoableGridTableAction> actions = new ArrayList<IUndoableGridTableAction>();
        actions.add(new SetBorderStyleAction(leftCell, headerRegion.getBottom() + 1, GridTool.makeNewPropStyle(grid, leftCell, headerRegion.getBottom() + 1, leftCell, regionWidth)));
        actions.add(new UnmergeByColumnsAction(new GridRegion(headerRegion.getBottom() + 1, leftCell, headerRegion.getBottom() + 1, tableRegion.getRight())));
        actions.add(new UndoableSetValueAction(leftCell, headerRegion.getBottom() + 1, PROPERTIES_SECTION_NAME));
        for (int prpCell = leftCell + 1; prpCell < leftCell + regionWidth; ++prpCell) {
            actions.add(new UndoableClearAction(prpCell, headerRegion.getBottom() + 1));
        }
        if (regionWidth >= 3) {
            for (int j = leftCell + 2; j < leftCell + regionWidth; ++j) {
                actions.add(new SetBorderStyleAction(j, headerRegion.getBottom() + 1, GridTool.makeNewPropStyle(grid, j, headerRegion.getBottom() + 1, leftCell, regionWidth)));
            }
        } else if (regionWidth < 3) {
            int j;
            int row;
            int propSize = 3;
            actions.add(new MergeCellsAction(new GridRegion(topCell, leftCell, headerRegion.getBottom(), leftCell + 2)));
            for (row = topCell; row < tableRegion.getBottom(); ++row) {
                for (j = leftCell + regionWidth; j < leftCell + 3; ++j) {
                    actions.add(new SetBorderStyleAction(j, row, grid.getCell(leftCell + regionWidth - 1, row).getStyle()));
                }
            }
            for (row = topCell + 1; row < tableRegion.getBottom(); ++row) {
                for (j = leftCell + regionWidth; j < leftCell + 3; ++j) {
                    actions.add(new SetBorderStyleAction(j, row + 1, grid.getCell(leftCell + regionWidth - 1, row).getStyle()));
                }
            }
            int row2 = headerRegion.getBottom() + 1;
            while (row2 < tableRegion.getBottom()) {
                IGridRegion cellToExpandRegion = grid.getCell(leftCell + regionWidth - 1, row2).getAbsoluteRegion();
                actions.add(new MergeCellsAction(new GridRegion(row2 + 1, cellToExpandRegion.getLeft(), cellToExpandRegion.getBottom() + 1, leftCell + 2)));
                actions.add(new SetBorderStyleAction(leftCell + 2, topCell, grid.getCell(leftCell + regionWidth - 1, topCell).getStyle()));
                row2 = cellToExpandRegion.getBottom() + 1;
            }
            actions.add(new GridRegionAction(tableRegion, true, true, GridRegionAction.ActionType.EXPAND, propSize - regionWidth));
        }
        return new UndoableCompositeAction(actions);
    }

    private static CellStyle makeNewPropStyle(IGrid grid, int col, int row, int regionLeftCell, int regionWidth) {
        BorderStyle[] borderStyle;
        ICell cell = grid.getCell(col, row);
        CellStyle newCellStyle = new CellStyle(cell.getStyle());
        ICellStyle cellStyle = cell.getStyle();
        BorderStyle[] borderStyleArray = borderStyle = cellStyle != null ? cellStyle.getBorderStyle() : null;
        if (borderStyle != null && col == regionLeftCell) {
            if (borderStyle.length == 4) {
                borderStyle = new BorderStyle[]{BorderStyle.NONE, BorderStyle.NONE, BorderStyle.NONE, borderStyle[3]};
            }
        } else if (borderStyle != null && col - regionLeftCell == regionWidth - 1) {
            if (borderStyle.length == 4) {
                borderStyle = new BorderStyle[]{BorderStyle.NONE, borderStyle[1], BorderStyle.NONE, BorderStyle.NONE};
            }
        } else {
            borderStyle = new BorderStyle[]{BorderStyle.NONE, BorderStyle.NONE, BorderStyle.NONE, BorderStyle.NONE};
        }
        newCellStyle.setBorderStyle(borderStyle);
        return newCellStyle;
    }

    private static IUndoableGridTableAction resizePropertiesHeader(IGridRegion tableRegion, IGrid grid) {
        int firstPropertyRow;
        int topCell;
        int leftCell = tableRegion.getLeft();
        int propsCount = grid.getCell(leftCell, (topCell = tableRegion.getTop()) + (firstPropertyRow = IGridRegion.Tool.height(grid.getCell(leftCell, topCell).getAbsoluteRegion()))).getHeight();
        if (propsCount == 1) {
            IGridRegion propHeaderRegion = grid.getRegionContaining(leftCell, topCell + firstPropertyRow);
            if (propHeaderRegion == null) {
                propHeaderRegion = new GridRegion(topCell + firstPropertyRow, leftCell, topCell + firstPropertyRow, leftCell);
            }
            return new UndoableResizeMergedRegionAction(propHeaderRegion, 1, true, false);
        }
        return new UndoableCompositeAction(GridTool.resizeMergedRegions(grid, firstPropertyRow, 1, true, false, tableRegion));
    }

    private static boolean tableContainsPropertySection(String propsHeader) {
        boolean containsPropSection = false;
        if (propsHeader != null && propsHeader.equals(PROPERTIES_SECTION_NAME)) {
            containsPropSection = true;
        }
        return containsPropSection;
    }

    private static List<IUndoableGridTableAction> clearCells(int startColumn, int nCols, int startRow, int nRows, IGrid grid) {
        ArrayList<IUndoableGridTableAction> clearActions = new ArrayList<IUndoableGridTableAction>();
        for (int i = startColumn; i < startColumn + nCols; ++i) {
            for (int j = startRow; j < startRow + nRows; ++j) {
                if (grid.isPartOfTheMergedRegion(i, j) && !grid.isTopLeftCellInMergedRegion(i, j)) continue;
                clearActions.add(new UndoableClearAction(i, j));
            }
        }
        return clearActions;
    }

    private static AUndoableCellAction shiftCell(int colFrom, int rowFrom, int colTo, int rowTo, IGrid grid) {
        if (!grid.isPartOfTheMergedRegion(colFrom, rowFrom) || grid.isTopLeftCellInMergedRegion(colFrom, rowFrom)) {
            return new UndoableShiftValueAction(colFrom, rowFrom, colTo, rowTo);
        }
        return new SetBorderStyleAction(colTo, rowTo, grid.getCell(colFrom, rowFrom).getStyle(), false);
    }

    private static List<IUndoableGridTableAction> shiftColumns(int startColumn, int nCols, boolean isInsert, IGridRegion region, IGrid grid) {
        int colFromCopy;
        int direction;
        ArrayList<IUndoableGridTableAction> shiftActions = new ArrayList<IUndoableGridTableAction>();
        if (isInsert) {
            shiftActions.addAll(GridTool.clearCells(region.getRight() + 1, nCols, region.getTop(), IGridRegion.Tool.height(region), grid));
        } else {
            for (int column = startColumn - nCols; column < startColumn; ++column) {
                for (int row = region.getTop(); row <= region.getBottom(); ++row) {
                    if (grid.isPartOfTheMergedRegion(column, row) && (!grid.isTopLeftCellInMergedRegion(column, row) || IGridRegion.Tool.width(grid.getRegionStartingAt(column, row)) > nCols)) continue;
                    shiftActions.add(new UndoableClearAction(column, row));
                }
            }
        }
        if (isInsert) {
            direction = -1;
            colFromCopy = region.getRight();
        } else {
            direction = 1;
            colFromCopy = startColumn;
        }
        int numColumnsToBeShifted = region.getRight() - startColumn;
        for (int i = 0; i <= numColumnsToBeShifted; ++i) {
            int colToCopy = colFromCopy - direction * nCols;
            for (int row = region.getBottom(); row >= region.getTop(); --row) {
                AUndoableCellAction action = GridTool.shiftCell(colFromCopy, row, colToCopy, row, grid);
                if (action == null) continue;
                shiftActions.add(action);
            }
            colFromCopy += direction;
        }
        return shiftActions;
    }

    private static List<IUndoableGridTableAction> shiftRows(int startRow, int nRows, boolean isInsert, IGridRegion region, IGrid grid) {
        int rowFromCopy;
        int direction;
        ArrayList<IUndoableGridTableAction> shiftActions = new ArrayList<IUndoableGridTableAction>();
        if (isInsert) {
            shiftActions.addAll(GridTool.clearCells(region.getLeft(), IGridRegion.Tool.width(region), region.getBottom() + 1, nRows, grid));
        } else {
            for (int row = startRow - nRows; row < startRow; ++row) {
                for (int column = region.getLeft(); column <= region.getRight(); ++column) {
                    if (grid.isPartOfTheMergedRegion(column, row) && (!grid.isTopLeftCellInMergedRegion(column, row) || IGridRegion.Tool.height(grid.getRegionStartingAt(column, row)) > nRows)) continue;
                    shiftActions.add(new UndoableClearAction(column, row));
                }
            }
        }
        if (isInsert) {
            direction = -1;
            rowFromCopy = region.getBottom();
        } else {
            direction = 1;
            rowFromCopy = startRow;
        }
        int numRowsToBeShifted = region.getBottom() - startRow;
        for (int i = 0; i <= numRowsToBeShifted; ++i) {
            int rowToCopy = rowFromCopy - direction * nRows;
            for (int column = region.getRight(); column >= region.getLeft(); --column) {
                AUndoableCellAction action = GridTool.shiftCell(column, rowFromCopy, column, rowToCopy, grid);
                if (action == null) continue;
                shiftActions.add(action);
            }
            rowFromCopy += direction;
        }
        return shiftActions;
    }

    public static IUndoableGridTableAction removeColumns(int nCols, int startColumn, IGridRegion region, IGrid grid) {
        int firstToMove = region.getLeft() + startColumn + nCols;
        int w = IGridRegion.Tool.width(region);
        int h = IGridRegion.Tool.height(region);
        ArrayList<IUndoableGridTableAction> actions = new ArrayList<IUndoableGridTableAction>(h * (w - startColumn));
        actions.addAll(GridTool.resizeMergedRegions(grid, startColumn, nCols, false, true, region));
        actions.addAll(GridTool.shiftColumns(firstToMove, nCols, false, region, grid));
        actions.addAll(GridTool.clearCells(region.getRight() + 1 - nCols, nCols, region.getTop(), h, grid));
        return new UndoableCompositeAction(actions);
    }

    public static IUndoableGridTableAction removeRows(int nRows, int startRow, IGridRegion region, IGrid grid) {
        int w = IGridRegion.Tool.width(region);
        int h = IGridRegion.Tool.height(region);
        int firstToMove = region.getTop() + startRow + nRows;
        ArrayList<IUndoableGridTableAction> actions = new ArrayList<IUndoableGridTableAction>(w * (h - startRow));
        actions.addAll(GridTool.resizeMergedRegions(grid, startRow, nRows, false, false, region));
        actions.addAll(GridTool.shiftRows(firstToMove, nRows, false, region, grid));
        actions.addAll(GridTool.clearCells(region.getLeft(), w, region.getBottom() + 1 - nRows, nRows, grid));
        return new UndoableCompositeAction(actions);
    }
}

