/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table;

import org.openl.rules.table.GridRegion;
import org.openl.util.StringTool;

public interface IGridRegion {
    public static final short TOP = 0;
    public static final short LEFT = 1;
    public static final short BOTTOM = 2;
    public static final short RIGHT = 3;

    public int getBottom();

    public int getLeft();

    public int getRight();

    public int getTop();

    public static class Tool {
        public static boolean contains(IGridRegion i1, int x, int y) {
            return i1.getLeft() <= x && x <= i1.getRight() && i1.getTop() <= y && y <= i1.getBottom();
        }

        public static int getAbsoluteColumn(IGridRegion region, int column) {
            return column + region.getLeft();
        }

        public static int getAbsoluteRow(IGridRegion region, int row) {
            return row + region.getTop();
        }

        public static int height(IGridRegion i1) {
            return i1.getBottom() - i1.getTop() + 1;
        }

        public static IGridRegion intersect(IGridRegion i1, IGridRegion i2) {
            int bottom;
            int left = Math.max(i1.getLeft(), i2.getLeft());
            int right = Math.min(i1.getRight(), i2.getRight());
            int top = Math.max(i1.getTop(), i2.getTop());
            return top <= (bottom = Math.min(i1.getBottom(), i2.getBottom())) && left <= right ? new GridRegion(top, left, bottom, right) : null;
        }

        public static boolean intersects(IGridRegion i1, IGridRegion i2) {
            int bottom;
            int left = Math.max(i1.getLeft(), i2.getLeft());
            int right = Math.min(i1.getRight(), i2.getRight());
            if (right < left) {
                return false;
            }
            int top = Math.max(i1.getTop(), i2.getTop());
            return top <= (bottom = Math.min(i1.getBottom(), i2.getBottom()));
        }

        public static GridRegion move(IGridRegion reg, int dx, int dy) {
            return new GridRegion(reg.getTop() + dy, reg.getLeft() + dx, reg.getBottom() + dy, reg.getRight() + dx);
        }

        public static int width(IGridRegion i1) {
            return i1.getRight() - i1.getLeft() + 1;
        }

        public static int getColumn(String cell) {
            int col = 0;
            int mul = 26;
            for (int i = 0; i < cell.length(); ++i) {
                char ch = cell.charAt(i);
                if (!Character.isLetter(ch)) {
                    return col - 1;
                }
                col = col * mul + ch - 65 + 1;
            }
            throw new RuntimeException("Invalid cell: " + cell);
        }

        public static int getRow(String cell) {
            for (int i = 0; i < cell.length(); ++i) {
                char ch = cell.charAt(i);
                if (!Character.isDigit(ch)) continue;
                return Integer.parseInt(cell.substring(i)) - 1;
            }
            throw new RuntimeException("Invalid cell: " + cell);
        }

        public static IGridRegion makeRegion(String range) {
            int idx = range.indexOf(":");
            if (idx < 0) {
                int col1 = Tool.getColumn(range);
                int row1 = Tool.getRow(range);
                return new GridRegion(row1, col1, row1, col1);
            }
            String[] rr = StringTool.tokenize((String)range, (String)":");
            int col1 = Tool.getColumn(rr[0]);
            int row1 = Tool.getRow(rr[0]);
            int col2 = Tool.getColumn(rr[1]);
            int row2 = Tool.getRow(rr[1]);
            return new GridRegion(row1, col1, row2, col2);
        }
    }
}

