/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.actions;

import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.actions.IUndoableGridTableAction;

public class UndoableCompositeAction
implements IUndoableGridTableAction {
    List<IUndoableGridTableAction> actions;

    public UndoableCompositeAction(List<IUndoableGridTableAction> actions) {
        this.actions = actions;
    }

    public UndoableCompositeAction(IUndoableGridTableAction ... gridActions) {
        this.actions = Arrays.asList(gridActions);
    }

    @Override
    public void doAction(IGridTable table) {
        for (IUndoableGridTableAction action : this.actions) {
            action.doAction(table);
        }
    }

    @Override
    public void undoAction(IGridTable table) {
        ListIterator<IUndoableGridTableAction> iter = this.actions.listIterator(this.actions.size());
        while (iter.hasPrevious()) {
            IUndoableGridTableAction action = iter.previous();
            action.undoAction(table);
        }
    }
}

