/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.actions;

import org.openl.rules.table.GridRegion;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.IWritableGrid;
import org.openl.rules.table.actions.AUndoableCellAction;

public class UndoableShiftValueAction
extends AUndoableCellAction {
    private int colFrom;
    private int rowFrom;
    private IGridRegion toRestore;
    private IGridRegion toRemove;

    public UndoableShiftValueAction(int colFrom, int rowFrom, int colTo, int rowTo) {
        super(colTo, rowTo);
        this.colFrom = colFrom;
        this.rowFrom = rowFrom;
    }

    @Override
    public void doAction(IGridTable table) {
        IWritableGrid grid = (IWritableGrid)table.getGrid();
        IGridRegion rrFrom = grid.getRegionStartingAt(this.colFrom, this.rowFrom);
        ICell cell = grid.getCell(this.colFrom, this.rowFrom);
        this.setPrevValue(cell.getObjectValue());
        this.setPrevFormula(cell.getFormula());
        this.setPrevStyle(cell.getStyle());
        this.setPrevComment(cell.getComment());
        this.setPrevMetaInfo(cell.getMetaInfo());
        if (rrFrom != null) {
            this.toRestore = rrFrom;
            grid.removeMergedRegion(rrFrom);
            GridRegion copyFrom = new GridRegion(rrFrom.getTop() + this.getRow() - this.rowFrom, rrFrom.getLeft() + this.getCol() - this.colFrom, rrFrom.getBottom() + this.getRow() - this.rowFrom, rrFrom.getRight() + this.getCol() - this.colFrom);
            grid.addMergedRegion(copyFrom);
            this.toRemove = copyFrom;
        }
        grid.setCellFormula(this.getCol(), this.getRow(), this.getPrevFormula());
        grid.setCellValue(this.getCol(), this.getRow(), this.getPrevValue());
        grid.setCellStyle(this.getCol(), this.getRow(), this.getPrevStyle());
        grid.setCellComment(this.getCol(), this.getRow(), this.getPrevComment());
        grid.getCell(this.getCol(), this.getRow()).setMetaInfo(this.getPrevMetaInfo());
        ICell newCell = grid.getCell(this.getCol(), this.getRow());
        if (cell.getType() == 1 && newCell.getType() == 2) {
            grid.setCellStringValue(this.getCol(), this.getRow(), cell.getObjectValue().toString());
        }
    }

    @Override
    public void undoAction(IGridTable table) {
        IWritableGrid grid = (IWritableGrid)table.getGrid();
        ICell cell = grid.getCell(this.getCol(), this.getRow());
        this.setPrevValue(cell.getObjectValue());
        this.setPrevFormula(cell.getFormula());
        this.setPrevStyle(cell.getStyle());
        this.setPrevComment(cell.getComment());
        if (this.toRemove != null) {
            grid.removeMergedRegion(this.toRemove);
            grid.addMergedRegion(this.toRestore);
        }
        grid.setCellFormula(this.colFrom, this.rowFrom, this.getPrevFormula());
        grid.setCellValue(this.colFrom, this.rowFrom, this.getPrevValue());
        grid.setCellStyle(this.colFrom, this.rowFrom, this.getPrevStyle());
        grid.setCellComment(this.colFrom, this.rowFrom, this.getPrevComment());
        grid.getCell(this.colFrom, this.rowFrom).setMetaInfo(this.getPrevMetaInfo());
    }
}

